/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.animation.recoil;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.items.attachments.util.newSys.IAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.IRecoilModifiable;
import sheridan.gunscraft.render.utils.Quaternions;

@OnlyIn(value=Dist.CLIENT)
public class RecoilAnimationHandler {
    public static RecoilAnimationHandler INSTANCE;
    public static final float TIME_FACTOR = 0.17f;
    private final RecoilAnimationState mainHandState = new RecoilAnimationState(true);
    private final RecoilAnimationState offHandState = new RecoilAnimationState(false);
    long lastTick = -1L;

    public static void init() {
        INSTANCE = new RecoilAnimationHandler();
    }

    public void handleTransform(PoseStack stack, int id, boolean aiming, boolean mainHand) {
        RecoilAnimationState state = mainHand ? this.mainHandState : this.offHandState;
        state.applyTransform(stack, id, aiming, mainHand);
    }

    public void clear(boolean mainHand, boolean disable) {
        RecoilAnimationState state = mainHand ? this.mainHandState : this.offHandState;
        state.clear(disable);
    }

    public void clearAll(boolean disable) {
        this.clear(true, disable);
        this.clear(false, disable);
    }

    public boolean isEnable(boolean mainHand) {
        return mainHand ? this.mainHandState.isEnable() : this.offHandState.isEnable();
    }

    public void onShoot(RecoilAnimationData data, boolean mainHand, int randomDirectionX, int randomDirectionY) {
        RecoilAnimationState state = mainHand ? this.mainHandState : this.offHandState;
        state.onShoot(data, randomDirectionX, randomDirectionY);
    }

    public void update() {
        if (this.lastTick != -1L) {
            float delta = (float)(System.currentTimeMillis() - this.lastTick) * 0.17f;
            this.mainHandState.update(delta);
            delta = (float)(System.currentTimeMillis() - this.lastTick) * 0.17f;
            this.offHandState.update(delta);
        }
        this.lastTick = System.currentTimeMillis();
    }

    public static class RecoilAnimationState {
        public static final float UP_FACTOR = 0.175f;
        public static final float BACK_FACTOR = 0.175f;
        public static final float ROTATE_FACTOR = 0.175f;
        private long startTime;
        private boolean enable;
        private final boolean mainHand;
        private RecoilAnimationData data;
        private float up;
        private float upSpeed;
        private float back;
        private float backSpeed;
        private float rotate;
        private float rotateSpeed;
        private float randomX;
        private float randomXSpeed;
        private float randomY;
        private float randomYSpeed;

        public void applyTransform(PoseStack stack, int id, boolean aiming, boolean mainHand) {
            if (this.data == null) {
                return;
            }
            if (id != this.data.id) {
                this.clear(true);
                return;
            }
            if (this.enable) {
                try {
                    LocalPlayer player;
                    List<IAttachment> attachments = Clients.getAttachmentManager(mainHand).getByFilter(attachment -> attachment instanceof IRecoilModifiable);
                    float[] args = new float[]{1.0f, 1.0f, 1.0f};
                    for (IAttachment attachment2 : attachments) {
                        IRecoilModifiable recoilModifiable = (IRecoilModifiable)((Object)attachment2);
                        args = recoilModifiable.onComputeRecoilAniScale(args);
                    }
                    float scaleY = args[0];
                    float scaleZ = args[1];
                    float scaleRot = args[2];
                    float aimingProgress = Clients.mainHandStatus.getLerpAimingProgress();
                    if (aiming || aimingProgress > 0.0f) {
                        scaleY = Mth.m_14179_((float)aimingProgress, (float)scaleY, (float)this.data.aimingScaleUp);
                        scaleZ = Mth.m_14179_((float)aimingProgress, (float)scaleY, (float)this.data.aimingBackScale);
                        scaleRot = Mth.m_14179_((float)aimingProgress, (float)scaleY, (float)this.data.aimingRotateScale);
                    }
                    if ((player = Minecraft.m_91087_().f_91074_) != null && player.m_6047_()) {
                        scaleRot = Math.max(0.2f, scaleRot - 0.08f);
                    }
                    float r0 = (this.rotate + this.randomY) * scaleRot * 0.175f;
                    float r1 = this.randomX * scaleRot * 0.175f;
                    float s0 = this.back < 0.0f ? 0.25f : 1.0f;
                    float s1 = this.up < 0.0f ? 0.27f : 1.0f;
                    stack.m_252880_(0.0f, -this.up * 0.175f * scaleY * s1, this.back * 0.175f * scaleZ * s0);
                    stack.m_252781_(Quaternions.rotateDeg(-r0, r1, 0.0f));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void onShoot(RecoilAnimationData data, int randomDirectionX, int randomDirectionY) {
            if (data != null) {
                List<IAttachment> attachments = Clients.getAttachmentManager(this.mainHand).getByFilter(attachment -> attachment instanceof IRecoilModifiable);
                float[] args = new float[]{1.0f, 1.0f};
                for (IAttachment attachment2 : attachments) {
                    IRecoilModifiable recoilModifiable = (IRecoilModifiable)((Object)attachment2);
                    args = recoilModifiable.onSetRecoilAniRandomScale(args);
                }
                float scaleY = args[0];
                float scaleZ = args[1];
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null && player.m_6047_()) {
                    scaleY = Math.max(0.2f, scaleY - 0.1f);
                    scaleZ = Math.max(0.2f, scaleZ - 0.1f);
                }
                this.upSpeed += data.up;
                this.backSpeed += data.back;
                this.rotateSpeed += data.rotate;
                this.data = data;
                this.startTime = System.currentTimeMillis();
                this.enable = true;
                this.randomYSpeed += data.randomY * (float)randomDirectionY * scaleY;
                this.randomXSpeed += data.randomX * (float)randomDirectionX * scaleZ;
            } else {
                this.clear(true);
            }
        }

        public RecoilAnimationState(boolean mainHand) {
            this.mainHand = mainHand;
        }

        public boolean isMainHand() {
            return this.mainHand;
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void clear(boolean disable) {
            this.upSpeed = 0.0f;
            this.up = 0.0f;
            this.backSpeed = 0.0f;
            this.back = 0.0f;
            this.rotateSpeed = 0.0f;
            this.rotate = 0.0f;
            this.randomXSpeed = 0.0f;
            this.randomX = 0.0f;
            this.randomYSpeed = 0.0f;
            this.randomY = 0.0f;
            this.data = null;
            this.enable = !disable;
        }

        private boolean shouldClear(float speed, float val) {
            return (double)Math.abs(speed) <= 1.0E-4 && (double)Math.abs(val) <= 1.0E-4;
        }

        public void update(float delta) {
            if (this.enable && this.data != null) {
                float rate = (float)Math.max(1.0 - 0.1 * (double)delta, 0.0);
                this.upSpeed -= this.up * this.data.upDesc * delta;
                this.upSpeed *= rate;
                this.up += this.upSpeed * delta;
                if (this.shouldClear(this.upSpeed, this.up)) {
                    this.up = 0.0f;
                    this.upSpeed = 0.0f;
                }
                this.back += this.backSpeed * delta;
                this.backSpeed -= this.back * this.data.backDesc * delta;
                this.backSpeed *= rate;
                if (this.shouldClear(this.backSpeed, this.back)) {
                    this.back = 0.0f;
                    this.backSpeed = 0.0f;
                }
                this.rotateSpeed -= this.rotate * this.data.rotateDesc * delta;
                this.rotateSpeed *= rate;
                this.rotate += this.rotateSpeed * delta;
                if (this.shouldClear(this.rotateSpeed, this.rotate)) {
                    this.rotate = 0.0f;
                    this.rotateSpeed = 0.0f;
                }
                float randomRate = (float)Math.max(1.0 - 0.08 * (double)delta, 0.0);
                this.randomX += this.randomXSpeed * delta;
                this.randomXSpeed *= randomRate;
                this.randomX *= randomRate;
                if (this.shouldClear(this.randomXSpeed, this.randomX)) {
                    this.randomX = 0.0f;
                    this.randomXSpeed = 0.0f;
                }
                this.randomY += this.randomYSpeed * delta;
                this.randomYSpeed *= randomRate;
                this.randomY *= randomRate;
                if (this.shouldClear(this.randomYSpeed, this.randomY)) {
                    this.randomY = 0.0f;
                    this.randomYSpeed = 0.0f;
                }
                if (System.currentTimeMillis() - this.startTime > this.data.lengthToClear) {
                    this.clear(true);
                }
            }
        }
    }

    public static class RecoilAnimationData {
        public float up;
        public float upDesc;
        public float back;
        public float backDesc;
        public float rotate;
        public float rotateDesc;
        public long lengthToClear;
        public float aimingScaleUp;
        public float aimingBackScale;
        public float aimingRotateScale;
        public float randomX;
        public float randomY;
        public boolean allowStaticRecoilAnimation;
        public boolean allowAimingStaticRecoilAnimation;
        public float aimingStaticRecoilAnimationScale;
        private static int tempId;
        public final int id;

        private static int getId() {
            return tempId++;
        }

        public RecoilAnimationData(float up, float upDesc, float back, float backDesc, float rotate, float rotateDesc, long length, float aimingScaleUp, float aimingBackScale, float aimingRotateScale, float randomX, float randomY) {
            this.up = up;
            this.upDesc = upDesc;
            this.back = back;
            this.backDesc = backDesc;
            this.rotate = rotate;
            this.rotateDesc = rotateDesc;
            this.lengthToClear = length;
            this.aimingScaleUp = aimingScaleUp;
            this.aimingBackScale = aimingBackScale;
            this.aimingRotateScale = aimingRotateScale;
            this.randomX = randomX;
            this.randomY = randomY;
            this.id = RecoilAnimationData.getId();
        }
    }
}

