/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.animation.recoil;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.Clients;

@OnlyIn(value=Dist.CLIENT)
public class RecoilCameraHandler {
    public static RecoilCameraHandler INSTANCE;
    private Player player;
    private static final float MIN_SPEED = 0.1f;
    private static final float TIME_FACTOR = 0.008f;
    public float upSpeed;
    public float randomSpeed;
    public float speedDec = 0.9f;
    public AtomicBoolean inModify = new AtomicBoolean(false);
    private boolean enable;
    private float tempUpDec = 0.0f;
    private float tempRandomDec = 0.0f;
    private long lastTick = -1L;

    public static void init() {
        INSTANCE = new RecoilCameraHandler();
    }

    public void handle() {
        if (this.lastTick != -1L) {
            float delta = System.currentTimeMillis() - this.lastTick;
            if (this.player != null && this.player.m_19879_() == Clients.clientPlayerId && this.enable) {
                this.player.m_146926_(this.player.m_146909_() - this.upSpeed * (delta *= 0.008f));
                this.player.m_146922_(this.player.m_146908_() + this.randomSpeed * delta);
                this.upSpeed -= this.tempUpDec * delta;
                this.randomSpeed -= this.tempRandomDec * delta;
                if (this.upSpeed < 0.1f && Math.abs(this.randomSpeed) < 0.1f || this.upSpeed < 0.0f) {
                    this.clear();
                }
            } else {
                this.player = Minecraft.m_91087_().f_91074_;
            }
        }
        this.lastTick = System.currentTimeMillis();
    }

    public void onShoot(float up, float random, float dec, int direction) {
        this.upSpeed = up;
        this.randomSpeed = random * (float)direction;
        this.tempUpDec = dec;
        this.tempRandomDec = dec * (float)direction * (random / up);
        this.enable = true;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void clear() {
        this.upSpeed = 0.0f;
        this.randomSpeed = 0.0f;
        this.tempUpDec = 0.0f;
        this.tempRandomDec = 0.0f;
        this.enable = false;
    }
}

