/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.blocks;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import sheridan.gunscraft.config.CommonConfig;
import sheridan.gunscraft.container.provider.VendingMachineMenuProvider;
import sheridan.gunscraft.items.Cash;
import sheridan.gunscraft.items.ModItems;
import sheridan.gunscraft.items.Ticket;
import sheridan.gunscraft.sounds.SoundEvents;

public class VendingMachine
extends HorizontalDirectionalBlock
implements IForgeBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape VOXEL_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static Map<String, List<Product>> products = new HashMap<String, List<Product>>();
    public static final String WEAPONS = "weapons";
    public static final String AMMO = "ammo";
    public static final String ATTACHMENTS = "attachments";
    public static final String ECONOMY = "economy";

    public void handleJsonObject(JsonObject jsonObject) {
        for (Map.Entry<String, List<Product>> entry : products.entrySet()) {
            String key = entry.getKey();
            List<Product> productsList = entry.getValue();
            JsonArray jsonArray = new JsonArray();
            for (Product product : productsList) {
                if (product.item == ModItems.CASH.get()) continue;
                JsonObject productObject = new JsonObject();
                product.handleJsonObject(productObject);
                jsonArray.add((JsonElement)productObject);
            }
            jsonObject.add(key, (JsonElement)jsonArray);
        }
    }

    protected VendingMachine(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.f_49792_.m_61090_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public static void deal(Player player, List<ItemStack> products, int cost) {
        int totalAsset;
        if (player != null && (totalAsset = Cash.getTotalAsset(player)) > 0 && totalAsset >= cost) {
            Cash.costCash(player, cost);
            for (ItemStack stack : products) {
                ItemEntity entity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                player.m_9236_().m_7967_((Entity)entity);
            }
            SoundEvents.playSound("item.vending_machine.deal_done", (LivingEntity)player, 1.0f, 1.0f);
            if (CommonConfig.getPrintDealCredit()) {
                ItemStack ticket = new ItemStack((ItemLike)ModItems.TICKET.get());
                Ticket.writeInfo(ticket, player, cost, products);
                ItemEntity entity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), ticket);
                player.m_9236_().m_7967_((Entity)entity);
            }
        }
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return false;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return true;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return 15;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return VOXEL_SHAPE;
    }

    public void m_6402_(Level level, BlockPos p_52750_, BlockState p_52751_, LivingEntity p_52752_, ItemStack p_52753_) {
        level.m_7731_(p_52750_.m_7494_(), (BlockState)p_52751_.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void m_6861_(BlockState prevState, Level level, BlockPos prevPos, Block neighborBlock, BlockPos neighborPos, boolean p_52781_) {
        if (prevState.m_60734_() == neighborBlock) {
            if (prevState.m_61143_(HALF) == DoubleBlockHalf.LOWER && prevPos.m_123342_() + 1 == neighborPos.m_123342_()) {
                level.m_46961_(prevPos, false);
            }
            if (prevState.m_61143_(HALF) == DoubleBlockHalf.UPPER && prevPos.m_123342_() - 1 == neighborPos.m_123342_()) {
                level.m_46961_(prevPos, false);
            }
        }
    }

    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player player, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (!p_60504_.f_46443_ && CommonConfig.getEnableVendingMachine()) {
            player.m_5893_((MenuProvider)new VendingMachineMenuProvider());
            player.m_36220_(Stats.f_12967_);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        if (blockPlaceContext.m_8083_().m_123342_() < blockPlaceContext.m_43725_().m_151558_() - 1 && blockPlaceContext.m_43725_().m_8055_(blockPlaceContext.m_8083_().m_7494_()).m_60629_(blockPlaceContext)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_());
        }
        return null;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF});
    }

    public void readFromNBT(CompoundTag tag) {
        products = new HashMap<String, List<Product>>();
        for (String category : tag.m_128431_()) {
            ListTag listTag = (ListTag)tag.m_128423_(category);
            ArrayList<Product> products = new ArrayList<Product>();
            if (ECONOMY.equals(category)) {
                products.add(new Product((Item)ModItems.CASH.get(), -1));
            }
            listTag.forEach(tag1 -> {
                Product product = Product.createFromNBT((CompoundTag)tag1);
                products.add(product);
            });
            VendingMachine.products.put(category, products);
        }
    }

    static {
        products.put(WEAPONS, new ArrayList());
        products.put(AMMO, new ArrayList());
        products.put(ATTACHMENTS, new ArrayList());
        products.put(ECONOMY, new ArrayList());
    }

    public static class Product {
        public Item item;
        public int price;

        public Product(Item item, int price) {
            this.item = item;
            this.price = price;
        }

        public String toString() {
            return "Product{item=" + this.item + ", price=" + this.price + "}";
        }

        public void handleJsonObject(JsonObject jsonObject) {
            ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)this.item);
            String name = key == null ? "un_known" : key.toString();
            jsonObject.addProperty("item", name);
            jsonObject.addProperty("price", (Number)this.price);
        }

        public CompoundTag getNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("id", Item.m_41393_((Item)this.item));
            tag.m_128405_("price", this.price);
            return tag;
        }

        public static Product createFromNBT(CompoundTag tag) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.m_128461_("id")));
            int price = tag.m_128451_("price");
            return new Product(item, price);
        }
    }
}

