/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.capability;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.AfterPlayerRebornPacket;
import sheridan.gunscraft.network.packets.SyncPlayerStatusPacket;

@Mod.EventBusSubscriber
public class PlayerStatusEvents {
    @SubscribeEvent
    public static void registerCapabilityEvent(RegisterCapabilitiesEvent event) {
        event.register(PlayerStatusProvider.class);
    }

    @SubscribeEvent
    public static void playerServerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_()) {
            Player player = event.player;
            player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                if (cap.dataChanged) {
                    PacketHandler.simpleChannel.send(PacketDistributor.TRACKING_ENTITY.with(() -> event.player), (Object)new SyncPlayerStatusPacket(player.m_19879_(), cap.lastShootRight, cap.lastShootLeft, cap.lastChamber, cap.reloading, cap.aiming));
                    cap.dataChanged = false;
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PacketHandler.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getOriginal()), (Object)new AfterPlayerRebornPacket());
    }
}

