/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sheridan.gunscraft.capability.PlayerStatus;

public class PlayerStatusProvider
implements ICapabilityProvider,
INBTSerializable {
    public PlayerStatus playerStatus;
    public static final Capability<PlayerStatus> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerStatus>(){});
    public final LazyOptional<PlayerStatus> longLazyOptional = LazyOptional.of(() -> this.playerStatus);

    public PlayerStatusProvider() {
        this.playerStatus = new PlayerStatus();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == CAPABILITY) {
            return this.longLazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    public Tag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.playerStatus.saveToNbt(tag);
        return tag;
    }

    public void deserializeNBT(Tag nbt) {
        this.playerStatus.readFromNbt((CompoundTag)nbt);
    }

    public static PlayerStatus getStatus(Player player) {
        return (PlayerStatus)player.getCapability(CAPABILITY).orElse((Object)PlayerStatus.EMPTY);
    }
}

