/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import sheridan.gunscraft.entities.projectile.utils.HeadBox;

public class CommonConfig {
    public static final float MAX_HEADSHOT_DAMAGE_FACTOR = 5.0f;
    public static final float MIN_HEADSHOT_DAMAGE_FACTOR = 1.0f;
    static String str3 = "1.0 ~ 5.0";
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec.BooleanValue shotBreakGlass;
    public static ForgeConfigSpec.BooleanValue shotActiveRedstone;
    public static ForgeConfigSpec.BooleanValue creativeModeUseAmmo;
    public static ForgeConfigSpec.BooleanValue enableVendingMachine;
    public static ForgeConfigSpec.BooleanValue printDealCredit;
    public static ForgeConfigSpec.BooleanValue enableHeadShot;
    public static ForgeConfigSpec.BooleanValue enableKnockBack;
    public static ForgeConfigSpec.IntValue maxBulletLifeLength;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> headshotModify;
    public static ForgeConfigSpec SPEC;

    public static boolean getCreativeModeUseAmmo() {
        try {
            return (Boolean)creativeModeUseAmmo.get();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean getEnableKnockBack() {
        try {
            return (Boolean)enableKnockBack.get();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean getEnableHeadShot() {
        try {
            return (Boolean)enableHeadShot.get();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static int getMaxBulletLifeLength() {
        try {
            return (Integer)maxBulletLifeLength.get();
        }
        catch (Exception exception) {
            return 100;
        }
    }

    public static boolean getShotBreakGlass() {
        try {
            return (Boolean)shotBreakGlass.get();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean getEnableVendingMachine() {
        try {
            return (Boolean)enableVendingMachine.get();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean getPrintDealCredit() {
        try {
            return (Boolean)printDealCredit.get();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean getShotActiveRedstone() {
        try {
            return (Boolean)shotActiveRedstone.get();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean verifyHeadShotModify(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            if ("".equals(str) || str.length() <= 0) {
                return false;
            }
            HeadBox headBox = HeadBox.parseAndInit(str);
            return headBox != null;
        }
        return false;
    }

    static {
        BUILDER.comment("Can bullet break glass block\n\u5b50\u5f39\u53ef\u4ee5\u51fb\u788e\u73bb\u7483\u5757");
        shotBreakGlass = BUILDER.define("shot_break_glass", true);
        BUILDER.comment("Can bullet active redstone signal when hit 'Target Block'\n\u5b50\u5f39\u51fb\u4e2d\u2018\u6807\u9776\u65b9\u5757\u2019\u65f6\u6fc0\u6d3b\u5176\u7ea2\u77f3\u4fe1\u53f7");
        shotActiveRedstone = BUILDER.define("shot_active_redstone", true);
        BUILDER.comment("The maximum tick value that the bullet entity can exist, if it exceeds this value, the bullet entity will be destroyed no matter what, in general you do not need to change this value\n\u5b50\u5f39\u5b9e\u4f53\u80fd\u5b58\u5728\u7684\u6700\u5927tick\u503c\uff0c\u5982\u679c\u8d85\u8fc7\u8fd9\u4e2a\u503c\uff0c\u5219\u65e0\u8bba\u5982\u4f55\u5b50\u5f39\u5b9e\u4f53\u90fd\u4f1a\u88ab\u9500\u6bc1\uff0c\u4e00\u822c\u60c5\u51b5\u4e0b\u4f60\u4e0d\u9700\u8981\u6539\u52a8\u8fd9\u4e2a\u503c");
        maxBulletLifeLength = BUILDER.defineInRange("max_bullet_life_length", 100, 10, 500);
        BUILDER.comment("Creative use ammo\n\u521b\u9020\u6a21\u5f0f\u6d88\u8017\u5b50\u5f39");
        creativeModeUseAmmo = BUILDER.define("creative_mode_use_ammo", false);
        BUILDER.comment("Enable vending machine\n\u542f\u7528\u81ea\u52a8\u552e\u8d27\u673a");
        enableVendingMachine = BUILDER.define("enable_vending_machine", true);
        BUILDER.comment("Vending machine print deal credit ticket for player\n\u81ea\u52a8\u552e\u8d27\u673a\u4ea4\u6613\u5b8c\u6210\u540e\u4e3a\u73a9\u5bb6\u6253\u5370\u4ea4\u6613\u51ed\u636e");
        printDealCredit = BUILDER.define("print_deal_credit", false);
        BUILDER.comment("Enable head shot\n\u542f\u7528\u7206\u5934\u5224\u5b9a");
        enableHeadShot = BUILDER.define("enable_head_shot", true);
        BUILDER.comment("Enable knock back\n\u542f\u7528\u5b50\u5f39\u51fb\u9000");
        enableKnockBack = BUILDER.define("enable_knock_back", true);
        BUILDER.comment("Set the headshot parameters. The following are the parameters of the registered minecraft original creatures.\nYou just need to add a custom project that mimics the existing project format.\nFirst parameter: headshot damage multiplier(" + str3 + ")\nSecond parameter: the size of the head bounding box (which is a cube) relative to the original mob bounding box\nThird parameter: the height of the center of the head bounding box relative to the original mob bounding box (0 for the bottom of the foot, 1 for the top of the head)\n\u914d\u7f6eheadshot\u53c2\u6570\uff0c\u4ee5\u4e0b\u662f\u5df2\u7ecf\u6ce8\u518c\u597d\u7684minecraft\u539f\u7248\u751f\u7269\u7684\u53c2\u6570\uff0c\n\u4f60\u53ea\u9700\u8981\u4eff\u7167\u5df2\u6709\u7684\u9879\u76ee\u683c\u5f0f\u6dfb\u52a0\u81ea\u5b9a\u4e49\u9879\u76ee\u5c31\u884c\u4e86\u3002\n\u7b2c\u4e00\u4e2a\u53c2\u6570\uff1aheadshot\u4f24\u5bb3\u500d\u6570\uff08" + str3 + "\uff09\n\u7b2c\u4e8c\u4e2a\u53c2\u6570\uff1a\u5934\u90e8\u78b0\u649e\u7bb1\uff08\u8fd9\u662f\u4e00\u4e2a\u6b63\u65b9\u4f53\uff09\u76f8\u5bf9\u4e8e\u539f\u751f\u7269\u78b0\u649e\u7bb1\u7684\u5927\u5c0f\n\u7b2c\u4e09\u4e2a\u53c2\u6570\uff1a\u5934\u90e8\u78b0\u649e\u7bb1\u4e2d\u5fc3\u76f8\u5bf9\u4e8e\u76f8\u5bf9\u4e8e\u539f\u751f\u7269\u78b0\u649e\u7bb1\u7684\u9ad8\u5ea6\uff08\u811a\u5e95\u4e3a0\uff0c\u5934\u9876\u4e3a1\uff09");
        headshotModify = BUILDER.defineListAllowEmpty("headshot_modify", List.of("minecraft:zombie=2.0,0.75,0.8", "minecraft:husk=2.0,0.8,0.82", "minecraft:zombified_piglin=2.0,0.85,0.8", "minecraft:piglin_brute=2.0,0.85,0.8", "minecraft:piglin=2.0,0.85,0.8", "minecraft:enderman=2.0,0.85,0.825", "minecraft:drowned=2.0,0.75,0.8", "minecraft:zombie_villager=2.0,0.9,0.8", "minecraft:pillager=2.0,0.9,0.8", "minecraft:evoker=2.0,0.9,0.8", "minecraft:villager=1.5,0.9,0.8", "minecraft:wandering_trader=1.5,0.9,0.8", "minecraft:vindicator=2.0,0.9,0.8", "minecraft:witch=2.0,0.9,0.8", "minecraft:blaze=2.0,0.75,0.8", "minecraft:skeleton=2.0,0.75,0.8", "minecraft:player=1.5,0.7,0.82", "minecraft:iron_golem=1.5,0.5,0.82", "minecraft:snow_golem=1.5,0.9,0.8", "minecraft:vex=2.0,0.9,0.65", "minecraft:warden=2.0,1.0,0.8", "minecraft:creeper=2.0,0.8,0.75"), CommonConfig::verifyHeadShotModify);
        SPEC = BUILDER.build();
    }
}

