/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.container;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import sheridan.gunscraft.container.ModContainers;

public class VendingMachineMenu
extends AbstractContainerMenu {
    public final BlockPos blockPos;
    public SimpleContainer shoppingCart;
    public SimpleContainer productsList;
    public SimpleContainer economyProducts;
    public Set<SimpleSlot> economyProductsSlots = new HashSet<SimpleSlot>();
    private SimpleSlot productList_3;
    private SimpleSlot productList_4;
    private SimpleSlot productList_5;

    public VendingMachineMenu(int i, BlockPos pos) {
        super((MenuType)ModContainers.VENDING_MACHINE.get(), i);
        this.blockPos = pos;
        this.initSlot();
    }

    public VendingMachineMenu(int i, Inventory inventory) {
        super((MenuType)ModContainers.VENDING_MACHINE.get(), i);
        this.blockPos = BlockPos.f_121853_;
        this.initSlot();
    }

    public void setupNormalSlotStatus() {
        for (SimpleSlot simpleSlot : this.economyProductsSlots) {
            simpleSlot.active = false;
        }
        this.productList_3.active = true;
        this.productList_4.active = true;
        this.productList_5.active = true;
    }

    public boolean isEconomySlot(SimpleSlot simpleSlot) {
        return this.economyProductsSlots.contains((Object)simpleSlot);
    }

    public void setupEconomyProductsSlotStatus() {
        for (SimpleSlot simpleSlot : this.economyProductsSlots) {
            simpleSlot.active = true;
        }
        this.productList_3.active = false;
        this.productList_4.active = false;
        this.productList_5.active = false;
    }

    void initSlot() {
        int i;
        this.shoppingCart = new SimpleContainer(9);
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.shoppingCart, i, 8 + i * 18, 18));
            this.shoppingCart.m_6836_(i, new ItemStack((ItemLike)Items.f_41852_));
        }
        this.productsList = new SimpleContainer(5);
        for (i = 0; i < 5; ++i) {
            SimpleSlot simpleSlot = new SimpleSlot((Container)this.productsList, i, 17, 59 + i * 27);
            this.m_38897_(simpleSlot);
            switch (i) {
                case 2: {
                    this.productList_3 = simpleSlot;
                    break;
                }
                case 3: {
                    this.productList_4 = simpleSlot;
                    break;
                }
                case 4: {
                    this.productList_5 = simpleSlot;
                }
            }
            this.productsList.m_6836_(i, new ItemStack((ItemLike)Items.f_41852_));
        }
        this.economyProducts = new SimpleContainer(28);
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                SimpleSlot simpleSlot = new SimpleSlot((Container)this.economyProducts, i * 7 + j, 15 + j * 18, 122 + i * 18);
                this.economyProductsSlots.add(simpleSlot);
                this.m_38897_(simpleSlot);
            }
        }
    }

    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return player.m_20275_((double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_() + 0.5, (double)this.blockPos.m_123343_() + 0.5) <= 64.0;
    }

    public static class SimpleSlot
    extends Slot {
        public boolean active = true;

        public SimpleSlot(Container p_40223_, int p_40224_, int p_40225_, int p_40226_) {
            super(p_40223_, p_40224_, p_40225_, p_40226_);
        }

        public boolean m_6659_() {
            return this.active;
        }
    }
}

