/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import sheridan.gunscraft.items.guns.utils.ProjectileData;

public class GunProperties {
    public int baseMagSize;
    public float baseSpread;
    public float maxSpread;
    public float spreadPreShoot;
    public int shootDelay;
    public float adsSpeed;
    public float recoilUp;
    public float recoilRandom;
    public float recoilDec;
    public int ammoPrice;
    public boolean isFreeBolt;
    public boolean isSniper = false;
    public boolean isPistol = false;
    public int reloadLength;
    public int fullReloadLength;
    public int burstCount = 0;
    public int weight;
    public float fireSoundVol = 1.0f;
    public float fireSoundPitch = 1.0f;
    public ProjectileData projectileData;

    public GunProperties(int baseMagSize, float baseSpread, float maxSpread, float spreadPreShoot, int shootDelay, float adsSpeed, float recoilUp, float recoilRandom, float recoilDec, int ammoPrice, boolean isFreeBlot, boolean isSniper, boolean isPistol, int reloadLength, int fullReloadLength, int burstCount, int weight, float fireSoundVol, float fireSoundPitch) {
        this.baseMagSize = baseMagSize;
        this.baseSpread = baseSpread;
        this.maxSpread = maxSpread;
        this.spreadPreShoot = spreadPreShoot;
        this.shootDelay = shootDelay;
        this.adsSpeed = adsSpeed;
        this.recoilUp = recoilUp;
        this.recoilRandom = recoilRandom;
        this.recoilDec = recoilDec;
        this.ammoPrice = ammoPrice;
        this.isFreeBolt = isFreeBlot;
        this.isSniper = isSniper;
        this.isPistol = isPistol;
        this.reloadLength = reloadLength;
        this.fullReloadLength = fullReloadLength;
        this.burstCount = burstCount;
        this.weight = weight;
        this.fireSoundVol = fireSoundVol;
        this.fireSoundPitch = fireSoundPitch;
    }

    public GunProperties() {
    }

    public GunProperties setBaseMagSize(int baseMagSize) {
        this.baseMagSize = baseMagSize;
        return this;
    }

    public GunProperties setBaseSpread(float baseSpread) {
        this.baseSpread = baseSpread;
        return this;
    }

    public GunProperties setMaxSpread(float maxSpread) {
        this.maxSpread = maxSpread;
        return this;
    }

    public GunProperties setSpreadPreShoot(float spreadPreShoot) {
        this.spreadPreShoot = spreadPreShoot;
        return this;
    }

    public GunProperties setShootDelay(int shootDelay) {
        this.shootDelay = shootDelay;
        return this;
    }

    public GunProperties setIsFreeBolt(boolean isFreeBlot) {
        this.isFreeBolt = isFreeBlot;
        return this;
    }

    public GunProperties setIsPistol(boolean isPistol) {
        this.isPistol = isPistol;
        this.isSniper = false;
        return this;
    }

    public GunProperties setIsSniper(boolean isSniper) {
        this.isSniper = isSniper;
        this.isPistol = false;
        return this;
    }

    public GunProperties setAdsSpeed(float adsSpeed) {
        this.adsSpeed = adsSpeed;
        return this;
    }

    public GunProperties setRecoilUp(float recoilUp) {
        this.recoilUp = recoilUp;
        return this;
    }

    public GunProperties setRecoilRandom(float recoilRandom) {
        this.recoilRandom = recoilRandom;
        return this;
    }

    public GunProperties setRecoilDec(float recoilDec) {
        this.recoilDec = recoilDec;
        return this;
    }

    public GunProperties setAmmoPrice(int ammoPrice) {
        this.ammoPrice = ammoPrice;
        return this;
    }

    public GunProperties setPistol(boolean pistol) {
        this.isPistol = pistol;
        return this;
    }

    public GunProperties setReloadLength(int reloadLength) {
        this.reloadLength = reloadLength;
        return this;
    }

    public GunProperties setFullReloadLength(int fullReloadLength) {
        this.fullReloadLength = fullReloadLength;
        return this;
    }

    public GunProperties setBurstCount(int burstCount) {
        this.burstCount = burstCount;
        return this;
    }

    public GunProperties setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public GunProperties setFireSoundVol(float fireSoundVol) {
        this.fireSoundVol = fireSoundVol;
        return this;
    }

    public GunProperties setFireSoundPitch(float fireSoundPitch) {
        this.fireSoundPitch = fireSoundPitch;
        return this;
    }

    public CompoundTag getInitialAttachmentModifiableTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("mag_size", this.baseMagSize);
        tag.m_128350_("min_spread_rate", 1.0f);
        tag.m_128350_("max_spread_rate", 1.0f);
        tag.m_128350_("spread_pre_shoot_rate", 1.0f);
        tag.m_128350_("ads_speed_rate", 1.0f);
        tag.m_128350_("recoil_up_rate", 1.0f);
        tag.m_128350_("recoil_random_rate", 1.0f);
        tag.m_128350_("recoil_dec_rate", 1.0f);
        tag.m_128405_("weight", this.weight);
        tag.m_128350_("fire_sound_vol_rate", 1.0f);
        tag.m_128350_("fire_sound_pitch_rate", 1.0f);
        tag.m_128359_("muzzle_flash_state", "normal");
        tag.m_128350_("move_spread_factor_rate", 1.0f);
        tag.m_128350_("sprinting_spread_factor_rate", 1.0f);
        return tag;
    }

    public void readFromNBT(CompoundTag tag) {
        this.baseMagSize = tag.m_128451_("baseMagSize");
        this.baseSpread = tag.m_128457_("baseSpread");
        this.maxSpread = tag.m_128457_("maxSpread");
        this.spreadPreShoot = tag.m_128457_("spreadPreShoot");
        this.shootDelay = tag.m_128451_("shootDelay");
        this.adsSpeed = tag.m_128457_("adsSpeed");
        this.recoilUp = tag.m_128457_("recoilUp");
        this.recoilRandom = tag.m_128457_("recoilRandom");
        this.recoilDec = tag.m_128457_("recoilDec");
        this.ammoPrice = tag.m_128451_("ammoPrice");
        this.isFreeBolt = tag.m_128471_("isFreeBolt");
        this.isSniper = tag.m_128471_("isSniper");
        this.isPistol = tag.m_128471_("isPistol");
        this.reloadLength = tag.m_128451_("reloadLength");
        this.fullReloadLength = tag.m_128451_("fullReloadLength");
        this.burstCount = tag.m_128451_("burstCount");
        this.weight = tag.m_128451_("weight");
        this.fireSoundVol = tag.m_128457_("fireSoundVol");
        this.fireSoundPitch = tag.m_128457_("fireSoundPitch");
        if (tag.m_128441_("projectileData")) {
            if (this.projectileData == null) {
                this.projectileData = new ProjectileData();
            }
            this.projectileData.readFromNBT(tag.m_128469_("projectileData"));
        }
    }

    public CompoundTag getNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("baseMagSize", this.baseMagSize);
        tag.m_128350_("baseSpread", this.baseSpread);
        tag.m_128350_("maxSpread", this.maxSpread);
        tag.m_128350_("spreadPreShoot", this.spreadPreShoot);
        tag.m_128405_("shootDelay", this.shootDelay);
        tag.m_128350_("adsSpeed", this.adsSpeed);
        tag.m_128350_("recoilUp", this.recoilUp);
        tag.m_128350_("recoilRandom", this.recoilRandom);
        tag.m_128350_("recoilDec", this.recoilDec);
        tag.m_128405_("ammoPrice", this.ammoPrice);
        tag.m_128379_("isFreeBolt", this.isFreeBolt);
        tag.m_128379_("isSniper", this.isSniper);
        tag.m_128379_("isPistol", this.isPistol);
        tag.m_128405_("reloadLength", this.reloadLength);
        tag.m_128405_("fullReloadLength", this.fullReloadLength);
        tag.m_128405_("burstCount", this.burstCount);
        tag.m_128405_("weight", this.weight);
        tag.m_128350_("fireSoundVol", this.fireSoundVol);
        tag.m_128350_("fireSoundPitch", this.fireSoundPitch);
        if (this.projectileData != null) {
            CompoundTag projectileTag = this.projectileData.getNBT();
            tag.m_128365_("projectileData", (Tag)projectileTag);
        }
        return tag;
    }

    public void handleJsonObj(JsonObject jsonObject) {
        jsonObject.addProperty("baseMagSize", (Number)this.baseMagSize);
        jsonObject.addProperty("baseSpread", (Number)Float.valueOf(this.baseSpread));
        jsonObject.addProperty("maxSpread", (Number)Float.valueOf(this.maxSpread));
        jsonObject.addProperty("spreadPreShoot", (Number)Float.valueOf(this.spreadPreShoot));
        jsonObject.addProperty("shootDelay", (Number)this.shootDelay);
        jsonObject.addProperty("adsSpeed", (Number)Float.valueOf(this.adsSpeed));
        jsonObject.addProperty("recoilUp", (Number)Float.valueOf(this.recoilUp));
        jsonObject.addProperty("recoilRandom", (Number)Float.valueOf(this.recoilRandom));
        jsonObject.addProperty("recoilDec", (Number)Float.valueOf(this.recoilDec));
        jsonObject.addProperty("ammoPrice", (Number)this.ammoPrice);
        jsonObject.addProperty("isFreeBolt", Boolean.valueOf(this.isFreeBolt));
        jsonObject.addProperty("isSniper", Boolean.valueOf(this.isSniper));
        jsonObject.addProperty("isPistol", Boolean.valueOf(this.isPistol));
        jsonObject.addProperty("reloadLength", (Number)this.reloadLength);
        jsonObject.addProperty("fullReloadLength", (Number)this.fullReloadLength);
        jsonObject.addProperty("burstCount", (Number)this.burstCount);
        jsonObject.addProperty("weight", (Number)this.weight);
        jsonObject.addProperty("fireSoundVol", (Number)Float.valueOf(this.fireSoundVol));
        jsonObject.addProperty("fireSoundPitch", (Number)Float.valueOf(this.fireSoundPitch));
        JsonObject projectileJson = new JsonObject();
        if (this.projectileData != null) {
            this.projectileData.handleJsonObj(projectileJson);
        }
        jsonObject.add("projectileData", (JsonElement)projectileJson);
    }

    public String toString() {
        return "GunProperties{baseMagSize=" + this.baseMagSize + ", baseSpread=" + this.baseSpread + ", maxSpread=" + this.maxSpread + ", spreadPreShoot=" + this.spreadPreShoot + ", shootDelay=" + this.shootDelay + ", adsSpeed=" + this.adsSpeed + ", recoilUp=" + this.recoilUp + ", recoilRandom=" + this.recoilRandom + ", recoilDec=" + this.recoilDec + ", ammoPrice=" + this.ammoPrice + ", isFreeBolt=" + this.isFreeBolt + ", isSniper=" + this.isSniper + ", isPistol=" + this.isPistol + ", reloadLength=" + this.reloadLength + ", fullReloadLength=" + this.fullReloadLength + ", burstCount=" + this.burstCount + ", weight=" + this.weight + ", fireSoundVol=" + this.fireSoundVol + ", fireSoundPitch=" + this.fireSoundPitch + ", projectileData=" + this.projectileData + "}";
    }
}

