/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.data;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import sheridan.gunscraft.data.GunProperties;
import sheridan.gunscraft.items.guns.GenericGun;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.UpdateGunPropertiesPacket;

@Mod.EventBusSubscriber(modid="gunscraft")
public class GunPropertiesHandler
extends SimplePreparableReloadListener<Map<String, GunProperties>> {
    public static GunPropertiesHandler INSTANCE;
    public static final Gson GSON;
    public static Map<String, GunProperties> loadedProperties;
    public CompoundTag loadedData;

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        if (!loadedProperties.isEmpty() && INSTANCE != null) {
            if (event.getPlayer() == null) {
                INSTANCE.genTag();
                PacketHandler.simpleChannel.send(PacketDistributor.ALL.noArg(), (Object)new UpdateGunPropertiesPacket(GunPropertiesHandler.INSTANCE.loadedData));
            } else {
                INSTANCE.genTag();
                PacketHandler.simpleChannel.send(PacketDistributor.PLAYER.with(() -> ((OnDatapackSyncEvent)event).getPlayer()), (Object)new UpdateGunPropertiesPacket(GunPropertiesHandler.INSTANCE.loadedData));
            }
        }
    }

    private void genTag() {
        if (this.loadedData == null) {
            this.loadedData = new CompoundTag();
            for (Map.Entry<String, GunProperties> entry : loadedProperties.entrySet()) {
                String name = entry.getKey();
                CompoundTag data = entry.getValue().getNBT();
                this.loadedData.m_128365_(name, (Tag)data);
            }
        }
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        GunPropertiesHandler handler = new GunPropertiesHandler();
        event.addListener((PreparableReloadListener)handler);
        INSTANCE = handler;
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        INSTANCE = null;
    }

    protected Map<String, GunProperties> prepare(ResourceManager manager, ProfilerFiller filler) {
        HashMap<String, GunProperties> propertiesMap = new HashMap<String, GunProperties>();
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof IGenericGun).forEach(item -> {
            String fileName = item.m_5524_().split("\\.")[2];
            String name = "guns_properties/" + fileName + ".json";
            ResourceLocation location = new ResourceLocation("gunscraft", name);
            manager.m_213713_(location).ifPresent(res -> {
                try {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(res.m_215507_(), StandardCharsets.UTF_8));){
                        GunProperties properties = (GunProperties)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, GunProperties.class);
                        propertiesMap.put(fileName, properties);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        });
        return propertiesMap;
    }

    protected void apply(Map<String, GunProperties> map, ResourceManager manager, ProfilerFiller filler) {
        loadedProperties = map;
        if (!loadedProperties.isEmpty()) {
            for (Map.Entry<String, GunProperties> entry : map.entrySet()) {
                ResourceLocation location = new ResourceLocation("gunscraft", entry.getKey());
                Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
                if (!(item instanceof GenericGun)) continue;
                GenericGun gun = (GenericGun)item;
                gun.properties = entry.getValue();
            }
        }
    }

    static {
        GSON = new Gson();
        loadedProperties = new HashMap<String, GunProperties>();
    }
}

