/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.RegistryObject;
import sheridan.gunscraft.Commons;
import sheridan.gunscraft.data.GunProperties;
import sheridan.gunscraft.items.ModItems;
import sheridan.gunscraft.items.guns.GenericGun;

public class GunPropertiesProvider
implements DataProvider {
    public PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;
    protected final PackOutput.PathProvider pathProvider;

    public GunPropertiesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "guns_properties");
        this.registries = registries;
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        Commons.INSTANCE.registerProjectileData();
        for (RegistryObject<?> object : ModItems.guns) {
            GenericGun gun = (GenericGun)object.get();
            GunProperties properties = gun.properties;
            String name = gun.m_5524_().split("\\.")[2];
            ResourceLocation key = new ResourceLocation("gunscraft", name);
            Path path = this.pathProvider.m_245731_(key);
            JsonObject jsonObject = new JsonObject();
            properties.handleJsonObj(jsonObject);
            list.add(DataProvider.m_253162_((CachedOutput)output, (JsonElement)jsonObject, (Path)path));
        }
        JsonObject object = new JsonObject();
        this.genProtocol(object);
        list.add(DataProvider.m_253162_((CachedOutput)output, (JsonElement)object, (Path)this.pathProvider.m_245527_(new ResourceLocation("gunscraft", "readme"), "txt")));
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    private void genProtocol(JsonObject jsonObject) {
        JsonObject en = new JsonObject();
        jsonObject.addProperty("version", (Number)371);
        en.addProperty("#0", "Adding parameters for custom firearms can provide more fun. Reasonable data changes can better adapt mods to the game environment and personal preferences. However, before you start, Gunscraft needs to declare:");
        en.addProperty("#1", "These data will automatically send synchronization messages to players joining the server, which may incur network and performance costs.");
        en.addProperty("#2", "Data is almost never subject to security validation.");
        en.addProperty("#3", "Due to the lack of restrictions on data values, once you modify the data, Gunscraft will no longer guarantee the safety of runtime. Players are responsible for any resulting program vulnerabilities, errors, or crashes.");
        jsonObject.add("announcement", (JsonElement)en);
        JsonObject zh = new JsonObject();
        zh.addProperty("#0", "\u81ea\u5b9a\u4e49\u67aa\u68b0\u7684\u4e00\u4e9b\u53c2\u6570\u80fd\u63d0\u4f9b\u66f4\u591a\u8da3\u5473\uff0c\u5408\u7406\u7684\u66f4\u6539\u6570\u636e\u80fd\u591f\u4f7fmod\u66f4\u597d\u7684\u9002\u914d\u6e38\u620f\u73af\u5883\u548c\u4e2a\u4eba\u559c\u597d\uff0c\u4f46\u662f\u5728\u60a8\u52a8\u624b\u4e4b\u524dgunscraft\u9700\u8981\u5148\u5411\u60a8\u58f0\u660e\uff1a");
        zh.addProperty("#1", "\u8fd9\u4e9b\u6570\u636e\u4f1a\u81ea\u52a8\u5411\u52a0\u5165\u670d\u52a1\u5668\u7684\u73a9\u5bb6\u53d1\u9001\u540c\u6b65\u6d88\u606f\uff0c\u8fd9\u53ef\u80fd\u4f1a\u5e26\u6765\u7f51\u7edc\u6d88\u8017\u548c\u6027\u80fd\u6d88\u8017");
        zh.addProperty("#2", "\u6570\u636e\u51e0\u4e4e\u4e0d\u4f1a\u7ecf\u8fc7\u5b89\u5168\u9a8c\u8bc1");
        zh.addProperty("#3", "\u7531\u4e8e\u6570\u636e\u53d6\u503c\u51e0\u4e4e\u4e0d\u505a\u9650\u5236\uff0c\u4e00\u65e6\u60a8\u4fee\u6539\u6570\u636e\uff0cgunscraft\u5c06\u4e0d\u518d\u4fdd\u8bc1\u8fd0\u884c\u65f6\u7684\u5b89\u5168\uff0c\u7531\u6b64\u53ef\u80fd\u4ea7\u751f\u7684\u7a0b\u5e8f\u6f0f\u6d1e\uff0c\u9519\u8bef\u6216\u5d29\u6e83\u95ee\u9898\u7531\u73a9\u5bb6\u81ea\u884c\u627f\u62c5\u540e\u679c");
        jsonObject.addProperty("\u7248\u672c", (Number)371);
        jsonObject.add("\u58f0\u660e", (JsonElement)zh);
    }

    public String m_6055_() {
        return "gunscraft: guns_properties";
    }
}

