/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.data;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import sheridan.gunscraft.blocks.VendingMachine;
import sheridan.gunscraft.config.CommonConfig;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.updateVendingMachineProductsPacket;

@Mod.EventBusSubscriber(modid="gunscraft")
public class VendingMachineProductsHandler
extends SimplePreparableReloadListener<Map<String, List<ProductMapping>>> {
    public static VendingMachineProductsHandler INSTANCE;
    public static Map<String, List<ProductMapping>> loadedProducts;
    public CompoundTag loadedData;

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        if (CommonConfig.getEnableVendingMachine() && !loadedProducts.isEmpty() && INSTANCE != null) {
            if (event.getPlayer() == null) {
                INSTANCE.genTag();
                PacketHandler.simpleChannel.send(PacketDistributor.ALL.noArg(), (Object)new updateVendingMachineProductsPacket(VendingMachineProductsHandler.INSTANCE.loadedData));
            } else {
                INSTANCE.genTag();
                PacketHandler.simpleChannel.send(PacketDistributor.PLAYER.with(() -> ((OnDatapackSyncEvent)event).getPlayer()), (Object)new updateVendingMachineProductsPacket(VendingMachineProductsHandler.INSTANCE.loadedData));
            }
        }
    }

    private void genTag() {
        if (this.loadedData == null) {
            this.loadedData = new CompoundTag();
            for (Map.Entry<String, List<ProductMapping>> entry : loadedProducts.entrySet()) {
                ListTag listTag = new ListTag();
                for (ProductMapping product : entry.getValue()) {
                    CompoundTag tag = new CompoundTag();
                    tag.m_128359_("id", product.item);
                    tag.m_128405_("price", product.price);
                    listTag.add((Object)tag);
                }
                this.loadedData.m_128365_(entry.getKey(), (Tag)listTag);
            }
        }
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        if (CommonConfig.getEnableVendingMachine()) {
            VendingMachineProductsHandler handler = new VendingMachineProductsHandler();
            event.addListener((PreparableReloadListener)handler);
            INSTANCE = handler;
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        INSTANCE = null;
    }

    protected Map<String, List<ProductMapping>> prepare(ResourceManager manager, ProfilerFiller filler) {
        HashMap<String, List<ProductMapping>> loadedProducts = new HashMap<String, List<ProductMapping>>();
        if (CommonConfig.getEnableVendingMachine()) {
            ResourceLocation path = new ResourceLocation("gunscraft", "vending_machine_products/vending_machine_products_register.json");
            manager.m_213713_(path).ifPresent(res -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(res.m_215507_(), StandardCharsets.UTF_8));){
                    String jsonString = VendingMachineProductsHandler.readJsonFile(reader);
                    Type type = new TypeToken<HashMap<String, List<ProductMapping>>>(){}.getType();
                    HashMap map = (HashMap)new Gson().fromJson(jsonString, type);
                    int maxPrice = 2147483;
                    for (Map.Entry entry : map.entrySet()) {
                        String category = (String)entry.getKey();
                        ArrayList<ProductMapping> mappings = new ArrayList<ProductMapping>();
                        for (ProductMapping mapping : (List)entry.getValue()) {
                            if (mapping.price <= 0 || mapping.price >= maxPrice || !ForgeRegistries.ITEMS.containsKey(new ResourceLocation(mapping.item))) continue;
                            mappings.add(mapping);
                        }
                        loadedProducts.put(category, mappings);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        return loadedProducts;
    }

    private static String readJsonFile(BufferedReader reader) {
        StringBuilder contentBuilder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                contentBuilder.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }

    protected void apply(Map<String, List<ProductMapping>> map, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        loadedProducts = map;
        for (String key : map.keySet()) {
            List<ProductMapping> mappings = map.get(key);
            ArrayList<VendingMachine.Product> products = new ArrayList<VendingMachine.Product>();
            for (ProductMapping mapping : mappings) {
                VendingMachine.Product product = mapping.getProduct();
                if (product == null) continue;
                products.add(product);
            }
            VendingMachine.products.put(key, products);
        }
    }

    static {
        loadedProducts = new HashMap<String, List<ProductMapping>>();
    }

    public static class ProductMapping {
        public String item;
        public int price;

        public ProductMapping(String item, int price) {
            this.item = item;
            this.price = price;
        }

        public VendingMachine.Product getProduct() {
            Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.item));
            return i == null ? null : new VendingMachine.Product(i, this.price);
        }

        public String toString() {
            return "ProductMapping{item='" + this.item + "', price=" + this.price + "}";
        }
    }
}

