/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.entities.projectile;

import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import sheridan.gunscraft.DamageTypes;
import sheridan.gunscraft.config.CommonConfig;
import sheridan.gunscraft.entities.projectile.utils.GenericDamageSource;
import sheridan.gunscraft.entities.projectile.utils.HeadBox;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.HeadShotFeedBackPacket;
import sheridan.gunscraft.network.packets.ParticlePacket;

public class GenericProjectile
extends Entity {
    public static final float BASE_SPEED_INDEX = 1.3f;
    public static final float BASE_SPREAD_INDEX = 0.00812345f;
    public static final int MAX_AGE = 100;
    public LivingEntity shooter;
    public float speed;
    public float spread;
    public float damage;
    public float minDamage;
    public float progress;
    public int force;
    public IGenericGun gun;
    public int f_19847_;
    public boolean f_19803_;
    public static final Random RANDOM = new Random();
    public static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(GenericProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> EFFECTIVE_RANGE = SynchedEntityData.m_135353_(GenericProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Vector3f> INITIAL_POS = SynchedEntityData.m_135353_(GenericProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && !input.m_5833_() && !(input instanceof ItemEntity);
    private static final IntegerProperty OUTPUT_POWER = BlockStateProperties.f_61426_;

    protected void m_8097_() {
        this.f_19804_.m_135372_(TYPE, (Object)1);
        this.f_19804_.m_135372_(EFFECTIVE_RANGE, (Object)Float.valueOf(16.0f));
        this.f_19804_.m_135372_(INITIAL_POS, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public GenericProjectile(EntityType<? extends GenericProjectile> entityTypeIn, Level levelIn) {
        super(entityTypeIn, levelIn);
    }

    public GenericProjectile(EntityType<? extends GenericProjectile> entityTypeIn, Level levelIn, LivingEntity shooter, Vec3 lookAngle, float speed, float spread, float damage, float minDamage, int type, float effectiveRange, int force, IGenericGun gun) {
        this(entityTypeIn, levelIn);
        this.init(shooter, lookAngle, speed, spread, damage, minDamage);
        this.f_19847_ = type;
        this.force = force;
        this.f_19804_.m_135381_(TYPE, (Object)type);
        this.f_19804_.m_135381_(INITIAL_POS, (Object)new Vector3f((float)this.m_20185_(), (float)this.m_20186_(), (float)this.m_20189_()));
        this.f_19804_.m_135381_(EFFECTIVE_RANGE, (Object)Float.valueOf(effectiveRange));
        this.gun = gun;
    }

    public void init(LivingEntity shooter, Vec3 lookAngle, float speed, float spread, float damage, float minDamage) {
        this.shooter = shooter;
        Vec3 shooterPos = new Vec3(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20236_(shooter.m_20089_()), shooter.m_20189_());
        this.m_6034_(shooterPos.f_82479_, shooterPos.f_82480_, shooterPos.f_82481_);
        this.speed = speed * 1.3f;
        this.spread = spread * 0.00812345f;
        this.onShoot(lookAngle.f_82479_, lookAngle.f_82480_, lookAngle.f_82481_, this.speed, this.spread);
        this.damage = damage;
        this.minDamage = minDamage;
        this.f_19803_ = true;
    }

    public void onShoot(double vx, double vy, double vz, float speed, float spread) {
        Vec3 velocity = new Vec3(vx, vy, vz).m_82541_().m_82520_(RANDOM.nextGaussian() * (double)spread, RANDOM.nextGaussian() * (double)spread, RANDOM.nextGaussian() * (double)spread).m_82490_((double)speed);
        this.m_20256_(velocity);
        double horizontalDistance = velocity.m_165924_();
        this.m_146922_(-((float)(Mth.m_14136_((double)velocity.f_82479_, (double)velocity.f_82481_) * 57.2957763671875)));
        this.m_146926_(-((float)(Mth.m_14136_((double)velocity.f_82480_, (double)horizontalDistance) * 57.2957763671875)));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void m_8119_() {
        if (!this.checkAddUpdate()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            Vec3 prevPos = this.m_20182_();
            Vec3 nextPos = prevPos.m_82549_(this.m_20184_());
            HitResult result = this.getHitResultOnMoveVector(this, PROJECTILE_TARGETS);
            if (result.m_6662_() != HitResult.Type.MISS) {
                BlockHitResult blockHitResult;
                if (result.m_6662_() == HitResult.Type.ENTITY && this.hitEntity((EntityHitResult)result, prevPos, nextPos)) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                if (result.m_6662_() == HitResult.Type.BLOCK && this.hitBlock(blockHitResult = (BlockHitResult)result)) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            this.m_6034_(nextPos.f_82479_, nextPos.f_82480_, nextPos.f_82481_);
            this.f_19803_ = false;
        } else {
            this.f_19847_ = (Integer)this.f_19804_.m_135370_(TYPE);
        }
    }

    public HitResult getHitResultOnMoveVector(Entity entity, Predicate<Entity> predicate) {
        Vec3 vec3 = entity.m_20184_();
        Level level = entity.m_9236_();
        Vec3 vec31 = entity.m_20182_();
        return this.getHitResult(vec31, entity, predicate, vec3, level);
    }

    private HitResult getHitResult(Vec3 p_278237_, Entity p_278320_, Predicate<Entity> predicate, Vec3 p_278342_, Level level) {
        EntityHitResult entityHitResult;
        Vec3 vec3 = p_278237_.m_82549_(p_278342_);
        BlockHitResult hitresult = level.m_45547_(new ClipContext(p_278237_, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_278320_));
        if (hitresult.m_6662_() != HitResult.Type.MISS) {
            vec3 = hitresult.m_82450_();
        }
        if ((entityHitResult = this.getEntityHitResult(level, p_278320_, p_278237_, vec3, p_278320_.m_20191_().m_82369_(p_278342_).m_82400_(1.0), predicate)) != null) {
            hitresult = entityHitResult;
        }
        return hitresult;
    }

    public EntityHitResult getEntityHitResult(Level level, Entity entity, Vec3 vec3, Vec3 endVec, AABB entityAABB, Predicate<Entity> predicate) {
        double d0 = Double.MAX_VALUE;
        Entity result = null;
        for (Entity e : level.m_6249_(entity, entityAABB, predicate)) {
            double d1;
            if (e == this.shooter || e.m_19879_() == this.shooter.m_19879_() || e instanceof GenericProjectile) continue;
            AABB aabb = e.m_20191_().m_82400_((double)0.3f);
            Optional optional = aabb.m_82371_(vec3, endVec);
            if (optional.isPresent()) {
                double d12 = vec3.m_82557_((Vec3)optional.get());
                if (!(d12 < d0)) continue;
                result = e;
                d0 = d12;
                continue;
            }
            if (!this.f_19803_) continue;
            this.f_19803_ = false;
            Vec3 hitPos = GenericProjectile.intersect(vec3, endVec, e.m_20191_());
            if (hitPos == null || !(vec3.m_82557_(endVec) >= vec3.m_82557_(hitPos)) || !((d1 = vec3.m_82557_(hitPos)) < d0)) continue;
            result = e;
            d0 = d1;
        }
        return result == null ? null : new EntityHitResult(result);
    }

    public static Vec3 intersect(Vec3 startPos, Vec3 endPos, AABB box) {
        double t_max;
        double dx = endPos.f_82479_ - startPos.f_82479_;
        double dy = endPos.f_82480_ - startPos.f_82480_;
        double dz = endPos.f_82481_ - startPos.f_82481_;
        double tx_min = (box.f_82288_ - startPos.f_82479_) / dx;
        double tx_max = (box.f_82291_ - startPos.f_82479_) / dx;
        double ty_min = (box.f_82289_ - startPos.f_82480_) / dy;
        double ty_max = (box.f_82292_ - startPos.f_82480_) / dy;
        double tz_min = (box.f_82290_ - startPos.f_82481_) / dz;
        double tz_max = (box.f_82293_ - startPos.f_82481_) / dz;
        double t_min = Math.max(Math.max(Math.min(tx_min, tx_max), Math.min(ty_min, ty_max)), Math.min(tz_min, tz_max));
        if (t_min > (t_max = Math.min(Math.min(Math.max(tx_min, tx_max), Math.max(ty_min, ty_max)), Math.max(tz_min, tz_max))) || t_max < 0.0) {
            return null;
        }
        double x = startPos.f_82479_ + t_min * dx;
        double y = startPos.f_82480_ + t_min * dy;
        double z = startPos.f_82481_ + t_min * dz;
        if (x >= box.f_82288_ && x <= box.f_82291_ && y >= box.f_82289_ && y <= box.f_82292_ && z >= box.f_82290_ && z <= box.f_82293_) {
            return new Vec3(x, y, z);
        }
        return null;
    }

    protected void m_7378_(CompoundTag p_20052_) {
    }

    protected void m_7380_(CompoundTag p_20139_) {
    }

    private boolean checkAddUpdate() {
        if (this.f_19797_ >= CommonConfig.getMaxBulletLifeLength()) {
            return false;
        }
        Vec3 pos = this.m_20182_();
        Vector3f initialPos = (Vector3f)this.f_19804_.m_135370_(INITIAL_POS);
        float effectiveRange = ((Float)this.f_19804_.m_135370_(EFFECTIVE_RANGE)).floatValue();
        float disX = (float)(pos.f_82479_ - (double)initialPos.x);
        float disY = (float)(pos.f_82480_ - (double)initialPos.y);
        float disZ = (float)(pos.f_82481_ - (double)initialPos.z);
        this.progress = (disX * disX + disY * disY + disZ * disZ) / (effectiveRange * effectiveRange);
        return this.progress < 1.0f;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), 0, this.m_20184_(), (double)this.m_6080_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.f_19850_ = true;
        double d0 = packet.m_131500_();
        double d1 = packet.m_131501_();
        double d2 = packet.m_131502_();
        this.m_6034_(d0, d1, d2);
    }

    public boolean hitBlock(BlockHitResult result) {
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(result.m_82425_());
        boolean notThrough = !(state.m_60734_() instanceof LeavesBlock) && !(state.m_60734_() instanceof AirBlock);
        boolean flag = this.checkForHitSpecialBlock(pos, state, result);
        if (notThrough && flag) {
            PacketHandler.simpleChannel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_, 48.0, this.m_9236_().m_46472_())), (Object)new ParticlePacket(pos, result.m_82450_(), result.m_82434_(), this.force));
        }
        return notThrough;
    }

    private boolean checkForHitSpecialBlock(BlockPos pos, BlockState state, BlockHitResult result) {
        Block block = state.m_60734_();
        if (block instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            if (this.shooter instanceof Player) {
                return !bell.m_152188_((Entity)this, this.m_9236_(), pos, result.m_82434_());
            }
        }
        if (state.m_60734_() instanceof TargetBlock && this.shooter instanceof Player && CommonConfig.getShotActiveRedstone()) {
            this.handleTargetBlockSignal(this.m_9236_(), state, result, this);
        }
        if (state.m_60734_() instanceof AbstractGlassBlock && CommonConfig.getShotBreakGlass()) {
            this.m_9236_().m_46961_(pos, false);
            return false;
        }
        return true;
    }

    private void handleTargetBlockSignal(Level level, BlockState blockState, BlockHitResult result, Entity entity) {
        LivingEntity livingEntity;
        int j;
        int index = this.getRedStoneStrength(result, result.m_82450_());
        int n = j = entity instanceof AbstractArrow ? 20 : 8;
        if (!level.m_183326_().m_183582_(result.m_82425_(), (Object)blockState.m_60734_())) {
            GenericProjectile.setOutputPower((LevelAccessor)level, blockState, index, result.m_82425_(), j);
        }
        if ((livingEntity = this.shooter) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)livingEntity;
            serverplayer.m_36220_(Stats.f_12953_);
            CriteriaTriggers.f_10561_.m_70211_(serverplayer, (Entity)this, result.m_82450_(), index);
        }
    }

    private int getRedStoneStrength(BlockHitResult p_57409_, Vec3 p_57410_) {
        Direction direction = p_57409_.m_82434_();
        double d0 = Math.abs(Mth.m_14185_((double)p_57410_.f_82479_) - 0.5);
        double d1 = Math.abs(Mth.m_14185_((double)p_57410_.f_82480_) - 0.5);
        double d2 = Math.abs(Mth.m_14185_((double)p_57410_.f_82481_) - 0.5);
        Direction.Axis direction$axis = direction.m_122434_();
        double d3 = direction$axis == Direction.Axis.Y ? Math.max(d0, d2) : (direction$axis == Direction.Axis.Z ? Math.max(d0, d1) : Math.max(d1, d2));
        return Math.max(1, Mth.m_14165_((double)(15.0 * Mth.m_14008_((double)((0.5 - d3) / 0.5), (double)0.0, (double)1.0))));
    }

    private static void setOutputPower(LevelAccessor p_57386_, BlockState p_57387_, int p_57388_, BlockPos p_57389_, int p_57390_) {
        p_57386_.m_7731_(p_57389_, (BlockState)p_57387_.m_61124_((Property)OUTPUT_POWER, (Comparable)Integer.valueOf(p_57388_)), 3);
        p_57386_.m_186460_(p_57389_, p_57387_.m_60734_(), p_57390_);
    }

    public boolean hitEntity(EntityHitResult result, Vec3 prevPos, Vec3 nextPos) {
        HeadBox.HeadShotResult headShotResult;
        Entity entity = result.m_82443_();
        if (entity == this.shooter || entity instanceof GenericProjectile) {
            return false;
        }
        entity.f_19802_ = 0;
        GenericDamageSource damageSource = (GenericDamageSource)DamageTypes.getDamageSource(this.m_9236_(), DamageTypes.GENERIC_PROJECTILE, this, (Entity)this.shooter);
        damageSource.shooter = this.shooter;
        damageSource.gun = this.gun;
        float prevDamage = this.damage - (this.damage - this.minDamage) * this.progress;
        if (CommonConfig.getEnableHeadShot() && (headShotResult = HeadBox.getHeadShot(entity, prevPos, nextPos)).getIsHeadShot()) {
            prevDamage *= headShotResult.getDamageModify();
            if (!this.m_9236_().f_46443_ && this.shooter != null && this.shooter instanceof Player) {
                PacketHandler.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.shooter), (Object)new HeadShotFeedBackPacket());
            }
        }
        return entity.m_6469_((DamageSource)damageSource, prevDamage);
    }
}

