/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.entities.projectile.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class HeadBox {
    private static Map<EntityType<?>, HeadBox> headBoxMap = new HashMap();
    public static final HeadShotResult MISS = new HeadShotResult(1.0f, false);
    private float size;
    private float yPos;
    private float damageModify;

    public static void register(EntityType<?> type, HeadBox headBox) {
        if (!headBoxMap.containsKey(type)) {
            headBoxMap.put(type, headBox);
        }
    }

    public static HeadShotResult getHeadShot(Entity entity, Vec3 startPos, Vec3 endPos) {
        AABB headAABB;
        Optional hit;
        HeadBox headBox = headBoxMap.get(entity.m_6095_());
        if (headBox != null && (hit = (headAABB = headBox.createAABB(entity)).m_82371_(startPos, endPos)).isPresent()) {
            return new HeadShotResult(headBox.damageModify, true);
        }
        return MISS;
    }

    public static boolean contains(EntityType<?> entityType) {
        return headBoxMap.containsKey(entityType);
    }

    public static HeadBox getBox(EntityType<?> entityType) {
        return HeadBox.contains(entityType) ? headBoxMap.get(entityType) : null;
    }

    public AABB createAABB(Entity entity) {
        AABB entityAABB = entity.m_20191_().m_82377_(0.0, 0.3, 0.0);
        double sx = entityAABB.m_82362_();
        double sy = entityAABB.m_82376_();
        double len = sx * (double)this.size;
        Vec3 center = entityAABB.m_82399_();
        return new AABB(center.f_82479_ - len / 2.0, entityAABB.f_82289_ + (double)this.yPos * sy - len / 2.0, center.f_82481_ - len / 2.0, center.f_82479_ + len / 2.0, entityAABB.f_82289_ + (double)this.yPos * sy + len / 2.0, center.f_82481_ + len / 2.0);
    }

    public HeadBox(float damageModify, float size, float yPos) {
        this.size = size;
        this.yPos = yPos;
        this.damageModify = Math.max(damageModify, 1.0f);
    }

    public static HeadBox parseAndInit(String str) {
        try {
            String[] params;
            EntityType entityType;
            ResourceLocation resourceLocation;
            String[] strings = str.split("=");
            if (strings.length == 2 && ForgeRegistries.ENTITY_TYPES.containsKey(resourceLocation = new ResourceLocation(strings[0])) && (entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation)) != null && (params = strings[1].split(",")).length == 3) {
                float damageModify = Float.parseFloat(params[0]);
                damageModify = Math.abs(damageModify);
                damageModify = Math.max(damageModify, 1.0f);
                damageModify = Math.min(damageModify, 5.0f);
                float size = Float.parseFloat(params[1]);
                float yPos = Float.parseFloat(params[2]);
                HeadBox headBox = new HeadBox(damageModify, size, yPos);
                headBoxMap.put(entityType, headBox);
                return headBox;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "HeadBox{size=" + this.size + ", yPos=" + this.yPos + ", damageModify=" + this.damageModify + "}";
    }

    public static class HeadShotResult {
        private float damageModify;
        private boolean isHeadShot;

        public HeadShotResult(float damageModify, boolean isHeadShot) {
            this.damageModify = damageModify;
            this.isHeadShot = isHeadShot;
        }

        public float getDamageModify() {
            return this.isHeadShot ? this.damageModify : 1.0f;
        }

        public boolean getIsHeadShot() {
            return this.isHeadShot;
        }
    }
}

