/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.events.ReloadingHandler;
import sheridan.gunscraft.items.attachments.util.newSys.IAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.impl.GenericScope;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.items.guns.utils.ChamberTaskHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientTickEvents {
    private static long lastTick = 0L;
    public static float clientDelta = 0.05f;
    public static final float OFF_HAND_SPREAD_FACTOR = 1.35f;
    public static final float CROUCHING_SPREAD_FACTOR = 0.5f;
    private static boolean firstPersonModTested = false;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer != null) {
            Clients.clientPlayerId = clientPlayer.m_19879_();
        }
        if (Clients.equipDuration > 0 || Minecraft.m_91087_().m_91104_()) {
            Clients.mainHandStatus.aiming.set(false);
        }
        if (Clients.bulletSpread > Clients.maxBulletSpread) {
            Clients.bulletSpread = Clients.maxBulletSpread;
        } else if (Clients.bulletSpread < Clients.minBulletSpread) {
            Clients.bulletSpread = Clients.minBulletSpread;
        } else {
            Clients.addSpread(-0.1f);
        }
        if (clientPlayer != null) {
            ClientTickEvents.updateClientSpread((Player)clientPlayer, clientPlayer.m_21205_(), clientPlayer.m_21206_());
        }
        if (event.phase == TickEvent.Phase.END) {
            if (ReloadingHandler.INSTANCE != null) {
                ReloadingHandler.INSTANCE.tick();
            }
            if (Clients.headshotFeedBackDelay > 0) {
                --Clients.headshotFeedBackDelay;
            }
        }
        if (ChamberTaskHandler.INSTANCE != null && event.phase == TickEvent.Phase.END) {
            ChamberTaskHandler.INSTANCE.tick();
        }
        if (event.phase == TickEvent.Phase.END) {
            IAttachment attachment;
            ItemStack stack;
            if (lastTick == 0L) {
                lastTick = System.currentTimeMillis();
            } else {
                long now = System.currentTimeMillis();
                long dis = now - lastTick;
                lastTick = now;
                clientDelta = (float)dis * 0.001f;
            }
            if (clientPlayer != null && (stack = clientPlayer.m_21205_()).m_41720_() instanceof IGenericGun && (attachment = Clients.mainHandStatus.attachmentsManager.getSight()) instanceof GenericScope) {
                GenericScope scope = (GenericScope)attachment;
                scope.handleMouseSensitivity();
            }
        }
        boolean bl = Clients.shouldHandleAnimation = !Minecraft.m_91087_().m_91104_() && clientPlayer != null && !clientPlayer.m_5833_();
        if (!firstPersonModTested && event.phase == TickEvent.Phase.END) {
            ClientTickEvents.testIfFirstPersonModLoaded();
            firstPersonModTested = true;
        }
        if (event.phase == TickEvent.Phase.END) {
            try {
                if (Clients.lock.isLocked()) {
                    Clients.lock.unlock();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void testIfFirstPersonModLoaded() {
        String className = "dev.tr7zw.firstperson.FirstPersonModelMod";
        try {
            Class.forName(className);
            Clients.strictDisplayType.set(true);
            Clients.findFirstPersonMod.set(true);
        }
        catch (ClassNotFoundException e) {
            Clients.strictDisplayType.set(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateClientSpread(Player entity, ItemStack stackMain, ItemStack stackOff) {
        float fallFactor;
        IGenericGun gun;
        float minSpread = 0.0f;
        float maxSpread = 0.0f;
        Item item = stackMain.m_41720_();
        if (item instanceof IGenericGun) {
            gun = (IGenericGun)item;
            minSpread += gun.getMinSpread(stackMain);
            maxSpread += gun.getMaxSpread(stackMain);
        }
        if ((item = stackOff.m_41720_()) instanceof IGenericGun) {
            gun = (IGenericGun)item;
            minSpread += gun.getMinSpread(stackOff) * 1.35f;
            maxSpread += gun.getMaxSpread(stackOff) * 1.35f;
        }
        if (entity.m_6047_()) {
            minSpread *= 0.5f;
            maxSpread *= 0.5f;
        }
        if (entity.f_20900_ != 0.0f || entity.f_20901_ != 0.0f || entity.f_20902_ != 0.0f) {
            minSpread *= Clients.getSpreadMoveFactor();
            maxSpread *= Clients.getSpreadMoveFactor();
            minSpread += 0.1f;
            maxSpread += 0.1f;
        }
        float f = fallFactor = entity.f_19789_ < 10.0f ? entity.f_19789_ * 0.15f : 1.5f;
        if (entity.m_20142_()) {
            minSpread *= Clients.getSprintingMoveFactor();
            maxSpread *= Clients.getSprintingMoveFactor();
            minSpread += 0.1f;
            maxSpread += 0.1f;
        }
        Clients.minBulletSpread = minSpread += fallFactor;
        Clients.maxBulletSpread = maxSpread += fallFactor;
    }
}

