/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.events;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import sheridan.gunscraft.ClientWeaponStatus;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.animation.recoil.RecoilAnimationHandler;
import sheridan.gunscraft.animation.recoil.RecoilCameraHandler;
import sheridan.gunscraft.items.Cash;
import sheridan.gunscraft.items.ModItems;
import sheridan.gunscraft.items.NoRepair;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsHandler;
import sheridan.gunscraft.items.attachments.util.newSys.IAimingPosModifiable;
import sheridan.gunscraft.items.attachments.util.newSys.IAttachment;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.VendingMachineUpdateAssetPacket;
import sheridan.gunscraft.render.TransformData;

@Mod.EventBusSubscriber
public class PlayerEvents {
    public static final int TWO_HAND_PISTOL = 0;
    public static final int RIGHT_HAND_PISTOL = 1;
    public static final int LEFT_HAND_PISTOL = 2;
    public static final int DOUBLE_PISTOL = 3;
    public static final int RIFLE = 4;
    @Deprecated(forRemoval=true)
    static Map<Integer, Item> tempAttachmentsMap;

    @Deprecated(forRemoval=true)
    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (tempAttachmentsMap == null) {
            tempAttachmentsMap = new HashMap<Integer, Item>();
            tempAttachmentsMap.put(0, (Item)ModItems.AR_EXPANSION_MAG.get());
            tempAttachmentsMap.put(1, (Item)ModItems.SMG_EXPANSION_MAG.get());
            tempAttachmentsMap.put(2, (Item)ModItems.RED_DOT.get());
            tempAttachmentsMap.put(3, (Item)ModItems.SCOPE_X4.get());
            tempAttachmentsMap.put(4, (Item)ModItems.GRIP.get());
            tempAttachmentsMap.put(5, (Item)ModItems.SUPPRESSOR.get());
            tempAttachmentsMap.put(6, (Item)ModItems.SNIPER_SCOPE.get());
            tempAttachmentsMap.put(7, (Item)ModItems.SHOTGUN_LONG_MAG.get());
            tempAttachmentsMap.put(8, (Item)ModItems.PISTOL_EXP_MAG.get());
            tempAttachmentsMap.put(9, (Item)ModItems.COMPENSATOR.get());
            tempAttachmentsMap.put(10, (Item)ModItems.SNIPER_SUPPRESSOR.get());
            tempAttachmentsMap.put(11, (Item)ModItems.SHOT_GUN_SUPPRESSOR.get());
            tempAttachmentsMap.put(12, (Item)ModItems.DMR_SCOPE.get());
            tempAttachmentsMap.put(13, (Item)ModItems.RIFLE_EXP_MAG.get());
            tempAttachmentsMap.put(14, (Item)ModItems.HOLOGRAPHIC.get());
            tempAttachmentsMap.put(15, (Item)ModItems.AR_TACTICAL_STOCK.get());
            tempAttachmentsMap.put(16, (Item)ModItems.RIFLE_COMPENSATOR.get());
            tempAttachmentsMap.put(17, (Item)ModItems.LASER_SIGHT.get());
            tempAttachmentsMap.put(18, (Item)ModItems.FAST_SCOPE.get());
            tempAttachmentsMap.put(19, (Item)ModItems.TRIANGLE_GRIP.get());
        }
    }

    @Deprecated
    public static CompoundTag checkAndGet(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("attachments")) {
            return nbt.m_128469_("attachments");
        }
        return null;
    }

    @Deprecated
    private static void deprecateOldAttachmentSys(ItemStack stack, IGenericGun gun, Player player) {
        CompoundTag tag = PlayerEvents.checkAndGet(stack);
        if (tag != null) {
            for (String key : tag.m_128431_()) {
                int id;
                Item item;
                CompoundTag slot = tag.m_128469_(key);
                if (!slot.m_128441_("attachment_id") || (item = tempAttachmentsMap.get(id = slot.m_128451_("attachment_id"))) == null) continue;
                ItemStack itemStack = new ItemStack((ItemLike)item);
                ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), itemStack);
                player.m_9236_().m_7967_((Entity)itemEntity);
            }
        }
        int ammoLeft = gun.getAmmoLeft(stack);
        stack.m_41751_(new CompoundTag());
        gun.getGun().m_7836_(stack, player.m_9236_(), player);
        gun.setAmmoLeft(stack, ammoLeft);
    }

    @SubscribeEvent
    public static void onGunEquipped(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = event.getTo();
            Object2ObjectArrayMap map = new Object2ObjectArrayMap();
            Item item = stack.m_41720_();
            if (item instanceof IGenericGun) {
                IGenericGun gun = (IGenericGun)item;
                int version = gun.getInnerVersion(stack);
                if (version <= 340) {
                    PlayerEvents.deprecateOldAttachmentSys(stack, gun, player);
                } else if (version != 371) {
                    gun.getGun().m_7836_(stack, player.m_9236_(), player);
                    int v = gun.getInnerVersion(stack);
                    if (v != 371) {
                        AttachmentsHandler.INSTANCE.updateAttachmentMap(player, gun, stack);
                    }
                    gun.setInnerVersion(stack, 371);
                }
                AttachmentsHandler.INSTANCE.updateAttachmentModifiableData(stack, gun, player);
            }
        }
    }

    @SubscribeEvent
    public static void anvilChangeEvent(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof NoRepair || event.getRight().m_41720_() instanceof NoRepair) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void pickItemEvent(PlayerEvent.ItemPickupEvent event) {
        ItemStack stack;
        if (event.getStack().m_41720_() == ModItems.CASH.get() && (stack = event.getStack()).m_41768_()) {
            PlayerEvents.manageCash(event.getEntity());
        }
    }

    private static void manageCash(Player player) {
        Inventory inventory = player.m_150109_();
        int len = inventory.m_6643_();
        int totalFound = 0;
        for (int i = 0; i < len; ++i) {
            ItemStack prevStack = inventory.m_8020_(i);
            if (prevStack.m_41720_() != ModItems.CASH.get()) continue;
            totalFound += Cash.getLeft(prevStack);
        }
        if (totalFound > 0) {
            int totalSetter = totalFound;
            for (int i = 0; i < len; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41720_() != ModItems.CASH.get()) continue;
                if (totalFound <= 0) {
                    stack.m_41764_(0);
                    continue;
                }
                if (totalFound >= stack.m_41776_()) {
                    stack.m_41721_(0);
                    totalFound -= stack.m_41776_();
                    continue;
                }
                Cash.setLeft(stack, totalFound);
                totalFound = 0;
            }
            if (!player.m_9236_().f_46443_) {
                PacketHandler.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new VendingMachineUpdateAssetPacket(totalSetter));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_19879_() == Clients.getClientPlayerId()) {
            ItemStack stackMain = player.m_21205_();
            ItemStack stackOff = player.m_21206_();
            PlayerEvents.updateRecoilAnimationHandler(stackMain, stackOff);
            PlayerEvents.updateClientHoldingGun(stackMain, stackOff);
            PlayerEvents.updateClientArmPose(stackMain, stackOff);
            PlayerEvents.updateClientFireDelay(stackMain, stackOff);
            if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
                Clients.isInFirstPersonGunView = stackMain.m_41720_() instanceof IGenericGun || stackOff.m_41720_() instanceof IGenericGun;
            } else {
                Clients.isInFirstPersonGunView = false;
                Clients.mainHandStatus.aiming.set(false);
            }
        }
    }

    public static void updateRecoilAnimationHandler(ItemStack stackMain, ItemStack stackOff) {
        if (!(stackMain.m_41720_() instanceof IGenericGun)) {
            RecoilAnimationHandler.INSTANCE.clear(true, true);
        }
        if (!(stackOff.m_41720_() instanceof IGenericGun)) {
            RecoilAnimationHandler.INSTANCE.clear(false, true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void playerJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_19879_() == Clients.clientPlayerId) {
            Clients.addSpread(0.5f);
        }
    }

    public static void updateClientHoldingGun(ItemStack stackMain, ItemStack stackOff) {
        boolean isGunMain = stackMain.m_41720_() instanceof IGenericGun;
        boolean isGunOff = stackOff.m_41720_() instanceof IGenericGun;
        ClientWeaponStatus mainHandStatus = Clients.mainHandStatus;
        ClientWeaponStatus offHandStatus = Clients.offHandStatus;
        mainHandStatus.holdingGun.set(isGunMain);
        IGenericGun gunMain = null;
        IGenericGun gunOff = null;
        if (isGunMain) {
            gunMain = (IGenericGun)stackMain.m_41720_();
            mainHandStatus.shouldHandle.set(gunMain.shouldHandle(stackMain));
            mainHandStatus.aimingSpeed = gunMain.getAimingSpeed(stackMain);
            mainHandStatus.isPistol = gunMain.isPistol();
            mainHandStatus.moveSpreadFactor = gunMain.getMoveSpreadFactor(stackMain);
            mainHandStatus.sprintingSpreadFactor = gunMain.getSprintingSpreadFactor(stackMain);
            TransformData data = Clients.transformDataMap.get(stackMain.m_41720_());
            mainHandStatus.attachmentsManager.clearAndUpdate(stackMain, gunMain);
            if (data != null && data.aimingTrans != null) {
                IAttachment attachment = Clients.mainHandStatus.attachmentsManager.getSight();
                Clients.mainHandStatus.aimingTrans = attachment != null ? PlayerEvents.handleAimingTrans(stackMain.m_41720_(), data.aimingTrans, attachment) : data.aimingTrans;
            }
            mainHandStatus.stack = stackMain;
        } else {
            mainHandStatus.shouldHandle.set(false);
            mainHandStatus.aiming.set(false);
            mainHandStatus.aimingTrans = null;
            mainHandStatus.attachmentsManager.clear();
            mainHandStatus.stack = null;
            mainHandStatus.dryFired = false;
            mainHandStatus.moveSpreadFactor = -1.0f;
            mainHandStatus.sprintingSpreadFactor = -1.0f;
        }
        if (isGunOff && !(gunOff = (IGenericGun)stackOff.m_41720_()).canHoldInOneHand()) {
            isGunOff = false;
        }
        if (isGunOff && isGunMain && !(gunMain = (IGenericGun)stackMain.m_41720_()).canHoldInOneHand()) {
            isGunOff = false;
        }
        if (isGunOff) {
            gunOff = (IGenericGun)stackOff.m_41720_();
            offHandStatus.shouldHandle.set(gunOff.shouldHandle(stackOff));
            offHandStatus.isPistol = gunOff.isPistol();
            offHandStatus.attachmentsManager.clearAndUpdate(stackOff, gunOff);
            offHandStatus.stack = stackOff;
            offHandStatus.moveSpreadFactor = gunOff.getMoveSpreadFactor(stackOff);
            offHandStatus.sprintingSpreadFactor = gunOff.getSprintingSpreadFactor(stackOff);
        } else {
            offHandStatus.shouldHandle.set(false);
            offHandStatus.attachmentsManager.clear();
            offHandStatus.stack = null;
            offHandStatus.dryFired = false;
            offHandStatus.moveSpreadFactor = -1.0f;
            offHandStatus.sprintingSpreadFactor = -1.0f;
        }
        offHandStatus.holdingGun.set(isGunOff);
        PlayerEvents.updateRecoil(gunMain, gunOff, stackMain, stackOff, isGunMain, isGunOff);
    }

    private static float[] handleAimingTrans(Item item, float[] aimingTrans, IAttachment attachment) {
        float[] trans = Arrays.copyOf(aimingTrans, aimingTrans.length);
        if (attachment instanceof IAimingPosModifiable) {
            IAimingPosModifiable aimingPosModifiable = (IAimingPosModifiable)((Object)attachment);
            aimingPosModifiable.handleAimingTrans(item, trans);
        }
        return trans;
    }

    private static void updateRecoil(IGenericGun gun, IGenericGun gunOff, ItemStack stack, ItemStack stackOff, boolean holdingGunMain, boolean holdingGunOff) {
        if (holdingGunMain || holdingGunOff) {
            RecoilCameraHandler.INSTANCE.speedDec = holdingGunMain ? gun.getRecoilDec(stack) : gunOff.getRecoilDec(stackOff);
            return;
        }
        RecoilCameraHandler.INSTANCE.clear();
    }

    private static void updateClientFireDelay(ItemStack stackMain, ItemStack stackOff) {
        Item fireDelayMain2;
        Item item = stackMain.m_41720_();
        if (item instanceof IGenericGun) {
            IGenericGun gunMain = (IGenericGun)item;
            int fireDelayMain2 = gunMain.getShootDelay();
            Clients.mainHandStatus.shootDelay.set(fireDelayMain2);
        }
        if ((fireDelayMain2 = stackOff.m_41720_()) instanceof IGenericGun) {
            IGenericGun gunOff = (IGenericGun)fireDelayMain2;
            int fireDelayOff = gunOff.getShootDelay();
            Clients.offHandStatus.shootDelay.set(fireDelayOff);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void updateClientArmPose(ItemStack stackMain, ItemStack stackOff) {
        int prevArmPose;
        int tempPose;
        block6: {
            IGenericGun gunOff;
            Item item;
            block7: {
                block5: {
                    IGenericGun gunOff2;
                    tempPose = 0;
                    prevArmPose = Clients.armPose;
                    item = stackMain.m_41720_();
                    if (!(item instanceof IGenericGun)) break block5;
                    IGenericGun gunMain = (IGenericGun)item;
                    if (!(stackOff.m_41720_() instanceof IGenericGun)) break block5;
                    tempPose = !gunMain.canHoldInOneHand() ? 4 : ((gunOff2 = (IGenericGun)stackOff.m_41720_()).canHoldInOneHand() ? 3 : 1);
                    break block6;
                }
                if (!((item = stackMain.m_41720_()) instanceof IGenericGun)) break block7;
                IGenericGun gunMain = (IGenericGun)item;
                if (stackOff.m_41720_() instanceof IGenericGun) break block7;
                if (!gunMain.canHoldInOneHand()) {
                    tempPose = 4;
                    break block6;
                } else if (stackOff.m_41720_() != Items.f_41852_) {
                    tempPose = 1;
                }
                break block6;
            }
            if (!(stackMain.m_41720_() instanceof IGenericGun) && (item = stackOff.m_41720_()) instanceof IGenericGun && (gunOff = (IGenericGun)item).canHoldInOneHand()) {
                tempPose = 2;
            }
        }
        if (tempPose != prevArmPose) {
            Clients.armPose = tempPose;
        }
    }
}

