/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.events;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.animation.keyFrame.FrameAnimation;
import sheridan.gunscraft.events.IReloadingTask;
import sheridan.gunscraft.items.guns.IBreakableReloading;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.ReloadGunPacket;

@OnlyIn(value=Dist.CLIENT)
public class ReloadingHandler {
    public static ReloadingHandler INSTANCE = new ReloadingHandler();
    public IReloadingTask taskMain;
    public IReloadingTask taskOff;
    private long lastStartReloadMain;
    private long lastStartReloadOff;
    private long lastEndReloadMain;
    private long lastEndReloadOff;
    private boolean usingGenericReload = false;
    private int exceptedReloadCountMain;
    private int exceptedReloadCountOff;
    int tempCustomStatusMain = 0;
    int tempCustomStatusOff = 0;

    public int getExceptedReloadCountMain() {
        return this.exceptedReloadCountMain;
    }

    public int getExceptedReloadCountOff() {
        return this.exceptedReloadCountOff;
    }

    public void setExceptedReloadCountMain(int exceptedReloadCountMain) {
        this.exceptedReloadCountMain = exceptedReloadCountMain;
    }

    public void setExceptedReloadCountOff(int exceptedReloadCountOff) {
        this.exceptedReloadCountOff = exceptedReloadCountOff;
    }

    public void setUsingGenericReload(boolean usingGenericReload) {
        this.usingGenericReload = usingGenericReload;
    }

    public boolean getGenericReloadFlag() {
        return this.usingGenericReload && this.isReloading();
    }

    public long getLastStartReloadTime(boolean mainHand) {
        return mainHand ? this.lastStartReloadMain : this.lastStartReloadOff;
    }

    public long getLastEndReloadTime(boolean mainHand) {
        return mainHand ? this.lastEndReloadMain : this.lastEndReloadOff;
    }

    public boolean isReloading() {
        return this.taskMain != null || this.taskOff != null;
    }

    public void breakTask(boolean mainHand) {
        if (mainHand) {
            IReloadingTask iReloadingTask;
            if (this.taskMain != null && !this.taskMain.isCompleted() && (iReloadingTask = this.taskMain) instanceof IBreakableReloading) {
                IBreakableReloading reloading = (IBreakableReloading)((Object)iReloadingTask);
                reloading.end();
                this.taskMain.tick((Player)Minecraft.m_91087_().f_91074_, 0);
            }
            this.taskMain = null;
            this.lastStartReloadMain = 0L;
        } else {
            IReloadingTask iReloadingTask;
            if (this.taskOff != null && !this.taskOff.isCompleted() && (iReloadingTask = this.taskOff) instanceof IBreakableReloading) {
                IBreakableReloading reloading = (IBreakableReloading)((Object)iReloadingTask);
                reloading.end();
                this.taskOff.tick((Player)Minecraft.m_91087_().f_91074_, 0);
            }
            this.taskOff = null;
            this.lastStartReloadOff = 0L;
        }
    }

    public int getCustomStatusMain() {
        return this.getCustomStatus(true);
    }

    public int getCustomStatusOff() {
        return this.getCustomStatus(false);
    }

    public int getCustomStatus(boolean mainHand) {
        if (mainHand) {
            if (this.taskMain != null) {
                this.tempCustomStatusMain = this.taskMain.getCustomStatus();
            }
            return this.tempCustomStatusMain;
        }
        if (this.taskOff != null) {
            this.tempCustomStatusOff = this.taskOff.getCustomStatus();
        }
        return this.tempCustomStatusOff;
    }

    public boolean setTask(IReloadingTask task) {
        if (!(task.getStack().m_41720_() instanceof IGenericGun)) {
            return false;
        }
        if (task.isMainHand()) {
            if (this.taskMain == null) {
                this.taskMain = task;
                this.lastStartReloadMain = System.currentTimeMillis();
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)this.taskMain.getStack(), (ItemStack)task.getStack())) {
                this.taskMain = task;
                this.lastStartReloadMain = System.currentTimeMillis();
                return true;
            }
        } else {
            if (this.taskOff == null) {
                this.taskOff = task;
                this.lastStartReloadOff = System.currentTimeMillis();
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)this.taskOff.getStack(), (ItemStack)task.getStack())) {
                this.taskOff = task;
                this.lastStartReloadOff = System.currentTimeMillis();
                return true;
            }
        }
        return false;
    }

    public void tick() {
        if (!Minecraft.m_91087_().m_91104_()) {
            if (this.taskMain == null && this.taskOff == null) {
                this.usingGenericReload = false;
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && player.m_19879_() == Clients.clientPlayerId && !player.m_5833_()) {
                int point = 1;
                if (this.taskMain != null) {
                    this.taskMain.tick((Player)player, point);
                    if (this.taskMain.isCompleted()) {
                        this.taskMain = null;
                        this.lastStartReloadMain = 0L;
                        this.lastEndReloadMain = System.currentTimeMillis();
                    } else {
                        --point;
                    }
                }
                if (this.taskOff != null) {
                    this.taskOff.tick((Player)player, point);
                    if (this.taskOff.isCompleted()) {
                        this.taskOff = null;
                        this.lastStartReloadOff = 0L;
                        this.lastEndReloadOff = System.currentTimeMillis();
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GenericReloadTask
    implements IReloadingTask {
        public ItemStack stack;
        public int reloadLength;
        public int tick;
        public boolean mainHand;
        public boolean completed;
        public boolean isFullReload;
        public List<FrameAnimation.SoundPoint> soundPoints;
        private int prevSoundIndex;
        private boolean firstTick;

        public GenericReloadTask(ItemStack stack, int reloadLength, boolean mainHand, boolean isFullReload) {
            this.stack = stack;
            this.reloadLength = reloadLength;
            this.tick = 0;
            this.mainHand = mainHand;
            this.isFullReload = isFullReload;
            this.prevSoundIndex = -1;
            this.soundPoints = Clients.getClientReloadSoundList(stack.m_41720_(), isFullReload);
            this.firstTick = true;
        }

        @Override
        public boolean isCompleted() {
            return this.completed;
        }

        @Override
        public void tick(Player clientPlayer, int point) {
            ItemStack heldStack;
            ItemStack itemStack = heldStack = this.mainHand ? clientPlayer.m_21205_() : clientPlayer.m_21206_();
            if (ItemStack.m_150942_((ItemStack)heldStack, (ItemStack)this.stack)) {
                this.tick += point;
                if (this.firstTick) {
                    PacketHandler.simpleChannel.sendToServer((Object)new ReloadGunPacket(this.mainHand, false, true));
                    this.firstTick = false;
                }
                Clients.mainHandStatus.aiming.set(false);
            } else {
                this.completed = true;
                PacketHandler.simpleChannel.sendToServer((Object)new ReloadGunPacket(this.mainHand, false, false));
            }
            this.handleSound();
            if (this.reloadLength - this.tick == 2) {
                this.finishReload(false);
            }
            if (this.tick >= this.reloadLength) {
                this.finishReload(true);
            }
        }

        @Override
        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        public boolean isMainHand() {
            return this.mainHand;
        }

        @Override
        public int getCustomStatus() {
            return 0;
        }

        private void handleSound() {
            if (this.soundPoints == null || this.soundPoints.size() <= 0) {
                return;
            }
            int soundIndex = Math.max(0, Mth.m_14049_((int)0, (int)this.soundPoints.size(), index -> this.tick < this.soundPoints.get((int)index).tick) - 1);
            if (soundIndex != this.prevSoundIndex) {
                this.soundPoints.get(soundIndex).playSound();
                this.prevSoundIndex = soundIndex;
            }
        }

        public void finishReload(boolean clear) {
            if (clear) {
                this.completed = true;
            } else {
                PacketHandler.simpleChannel.sendToServer((Object)new ReloadGunPacket(this.mainHand, true, false));
                if (this.mainHand) {
                    Clients.mainHandStatus.dryFired = false;
                } else {
                    Clients.offHandStatus.dryFired = false;
                }
            }
        }
    }
}

