/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.events;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL30;
import sheridan.gunscraft.ClientGlobalWeaponTranslator;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.items.attachments.grips.Flashlight;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsHandler;
import sheridan.gunscraft.items.attachments.util.newSys.IAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.impl.GenericScope;
import sheridan.gunscraft.items.guns.GenericGun;
import sheridan.gunscraft.items.guns.IChamberStatus;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.render.GunRenderer;
import sheridan.gunscraft.render.crosshair.BasicCrossHairRenderer;
import sheridan.gunscraft.utilsForShitOptifine.PostChain;
import sheridan.gunscraft.utilsForShitOptifine.PostPass;
import sheridan.gunscraft.utilsForShitOptifine.ShitOptifineHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderEvents {
    public static float delta = 0.0f;
    public static float originalFov = 70.0f;
    public static float currentFov = 70.0f;
    private static final BasicCrossHairRenderer renderer = new BasicCrossHairRenderer();
    static long l1;
    static long l2;
    public static PostChain flashlight;
    static int lastWidth;
    static int lastHeight;
    static boolean exceptionHappens;
    static long lastHoldingGun;
    private static final ResourceLocation CHAMBER_FILLED;
    private static final ResourceLocation CHAMBER_EMPTY;

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            l1 = System.currentTimeMillis();
            delta = (float)(l1 - l2) * 0.001f;
            l2 = l1;
        }
    }

    public static void checkStencilSetUp() {
        try {
            RenderTarget target = Clients.prevTarget;
            if (!target.isStencilEnabled()) {
                target.enableStencil();
            }
            if (!RenderEvents.isStencilEnabled()) {
                ShitOptifineHelper.setUpStencilAndTest();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isStencilEnabled() {
        int result = GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)36128, (int)36048);
        return result != 0;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderHand(RenderHandEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_21205_().m_41720_() instanceof IGenericGun || player.m_21206_().m_41720_() instanceof IGenericGun) {
            Clients.firstPersonHandRendered = true;
            if (((Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_()).booleanValue()) {
                ClientGlobalWeaponTranslator.INSTANCE.update((Player)player, event.getPartialTick(), event.getEquipProgress());
            } else {
                ClientGlobalWeaponTranslator.INSTANCE.clear();
            }
        }
    }

    @SubscribeEvent
    public static void renderFlashlight(RenderLevelStageEvent event) {
        LocalPlayer player;
        if (exceptionHappens) {
            return;
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL && Clients.isInFirstPersonGunView && (player = Minecraft.m_91087_().f_91074_) != null) {
            float sprinting;
            boolean isPistol;
            Object attachmentsMain;
            IGenericGun gun;
            Item item;
            ItemStack mainStack = player.m_21205_();
            ItemStack offStack = player.m_21206_();
            float maxDistanceMain = 12.0f;
            float strengthMain = 3.0f;
            float maxDistanceOff = 12.0f;
            float strengthOff = 3.0f;
            float offsetMainX = 0.0f;
            float offsetMainY = 0.0f;
            float offsetOffX = 0.0f;
            float offsetOffY = 0.0f;
            boolean doFlashlightMain = false;
            boolean doFlashlightOff = false;
            if (Clients.mainHandStatus.holdingGun.get() && (item = mainStack.m_41720_()) instanceof IGenericGun) {
                gun = (IGenericGun)item;
                attachmentsMain = Clients.mainHandStatus.attachmentsManager.getByFilter(attachment -> attachment instanceof Flashlight);
                boolean bl = doFlashlightMain = attachmentsMain.size() > 0 && gun.getFlashlightOn(mainStack);
                if (doFlashlightMain) {
                    isPistol = gun.isPistol();
                    maxDistanceMain += isPistol ? 8.0f : 10.0f;
                    strengthMain += isPistol ? 1.0f : 1.5f;
                    sprinting = ClientGlobalWeaponTranslator.INSTANCE.getSprintingProgress(true);
                    if (isPistol) {
                        offsetMainY = sprinting * 0.4f;
                    } else {
                        offsetMainY = sprinting;
                        offsetMainX = sprinting;
                    }
                }
            }
            if (Clients.offHandStatus.holdingGun.get() && (attachmentsMain = offStack.m_41720_()) instanceof IGenericGun) {
                gun = (IGenericGun)attachmentsMain;
                List<IAttachment> attachmentsOff = Clients.offHandStatus.attachmentsManager.getByFilter(attachment -> attachment instanceof Flashlight);
                boolean bl = doFlashlightOff = attachmentsOff.size() > 0 && gun.getFlashlightOn(offStack);
                if (doFlashlightOff) {
                    isPistol = gun.isPistol();
                    maxDistanceOff += isPistol ? 8.0f : 10.0f;
                    strengthOff += isPistol ? 1.0f : 1.5f;
                    sprinting = ClientGlobalWeaponTranslator.INSTANCE.getSprintingProgress(false);
                    if (isPistol) {
                        offsetOffY = sprinting * 0.4f;
                    }
                }
            }
            if (doFlashlightMain || doFlashlightOff) {
                if (flashlight == null) {
                    try {
                        PostChain postChain = ShitOptifineHelper.getPostChain(Minecraft.m_91087_().f_90987_, Minecraft.m_91087_().m_91098_(), Minecraft.m_91087_().m_91385_(), new ResourceLocation("gunscraft", "shaders/post/flashlight.json"));
                        lastWidth = Minecraft.m_91087_().m_91268_().m_85441_();
                        lastHeight = Minecraft.m_91087_().m_91268_().m_85442_();
                        postChain.resize(lastWidth, lastHeight);
                        flashlight = postChain;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        exceptionHappens = true;
                        player.m_213846_((Component)Component.m_237115_((String)"screen_info.gunscraft.flashlight_loading_exception").m_6270_(Style.f_131099_.m_178520_(0xFF0000)));
                        return;
                    }
                } else {
                    int width = Minecraft.m_91087_().m_91268_().m_85441_();
                    int height = Minecraft.m_91087_().m_91268_().m_85442_();
                    if (width != lastWidth || height != lastHeight) {
                        lastHeight = height;
                        lastWidth = width;
                        flashlight.resize(width, height);
                    }
                }
                if (Clients.isInFirstPersonGunView && flashlight != null) {
                    List<PostPass> passes = RenderEvents.flashlight.passes;
                    for (PostPass pass : passes) {
                        pass.getEffect().safeGetUniform("MaxDistance").m_5985_(maxDistanceMain);
                        pass.getEffect().safeGetUniform("Strength").m_5985_(strengthMain);
                        pass.getEffect().safeGetUniform("MaxDistanceOff").m_5985_(maxDistanceOff);
                        pass.getEffect().safeGetUniform("StrengthOff").m_5985_(strengthOff);
                        pass.getEffect().safeGetUniform("fov").m_5985_(originalFov);
                        pass.getEffect().safeGetUniform("currentFov").m_5985_(currentFov);
                        pass.getEffect().safeGetUniform("minDepth").m_5985_(0.65f);
                        pass.getEffect().safeGetUniform("aspectRatio").m_5985_((float)lastHeight / (float)lastWidth);
                        pass.getEffect().safeGetUniform("offsetX").m_5985_(offsetMainX);
                        pass.getEffect().safeGetUniform("offsetY").m_5985_(offsetMainY);
                        pass.getEffect().safeGetUniform("offsetXOff").m_5985_(offsetOffX);
                        pass.getEffect().safeGetUniform("offsetYOff").m_5985_(offsetOffY);
                        pass.getEffect().safeGetUniform("mainHandLight").m_142617_(doFlashlightMain ? 1 : 0);
                        pass.getEffect().safeGetUniform("offHandLight").m_142617_(doFlashlightOff ? 1 : 0);
                    }
                    flashlight.process(event.getPartialTick());
                    Minecraft.m_91087_().m_91385_().m_83947_(false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void fovEvent(ViewportEvent.ComputeFov event) {
        if (!event.usedConfiguredFov()) {
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            if (!Clients.findFirstPersonMod.get() && localPlayer != null) {
                ItemStack stack = localPlayer.m_21205_();
                if (Clients.holdingGun()) {
                    if (Clients.mainHandStatus.aiming.get()) {
                        float adsProgress = Clients.mainHandStatus.aimingProgress;
                        if (adsProgress > 0.75f) {
                            GenericScope scope;
                            IAttachment attachment = AttachmentsHandler.INSTANCE.getSight(stack);
                            if (attachment instanceof GenericScope && (scope = (GenericScope)attachment).modifyModelFovWhenAiming()) {
                                float fovLerpProgress = (adsProgress - 0.75f) * 4.0f;
                                float fov = RenderEvents.isStencilEnabled() ? scope.getModelFovWhenAiming() : 5.0f;
                                event.setFOV((double)Mth.m_14179_((float)fovLerpProgress, (float)60.0f, (float)fov));
                                GunRenderer.muzzleFlashScaleFP = Mth.m_14179_((float)fovLerpProgress, (float)1.0f, (float)0.3f);
                            } else {
                                event.setFOV(60.0);
                                GunRenderer.muzzleFlashScaleFP = 1.0f;
                            }
                        } else {
                            event.setFOV(60.0);
                            GunRenderer.muzzleFlashScaleFP = 1.0f;
                        }
                    } else {
                        event.setFOV(60.0);
                        GunRenderer.muzzleFlashScaleFP = 1.0f;
                    }
                    lastHoldingGun = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - lastHoldingGun <= 200L) {
                    event.setFOV(60.0);
                    GunRenderer.muzzleFlashScaleFP = 1.0f;
                }
            }
        } else {
            try {
                ItemStack stack;
                Item adsProgress;
                currentFov = originalFov = (float)event.getFOV();
                if (Clients.mainHandStatus.aiming.get() && Clients.mainHandStatus.holdingGun.get() && (adsProgress = (stack = Clients.mainHandStatus.stack).m_41720_()) instanceof IGenericGun) {
                    IGenericGun gun = (IGenericGun)adsProgress;
                    IAttachment attachment = AttachmentsHandler.INSTANCE.getSight(stack);
                    if (attachment instanceof GenericScope) {
                        GenericScope scope = (GenericScope)attachment;
                        currentFov = scope.onFovModify(stack, gun, originalFov);
                        event.setFOV((double)currentFov);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void renderCrossHair(RenderGuiOverlayEvent.Pre event) {
        if (Clients.findFirstPersonMod.get()) {
            return;
        }
        if ("minecraft:crosshair".equals(event.getOverlay().id().toString()) && (Clients.mainHandStatus.holdingGun.get() || Clients.offHandStatus.holdingGun.get())) {
            event.setCanceled(true);
            if (Clients.mainHandStatus.aiming.get()) {
                return;
            }
            Window window = Minecraft.m_91087_().m_91268_();
            PoseStack poseStack = event.getGuiGraphics().m_280168_();
            renderer.render(poseStack, Clients.bulletSpread, window, Clients.headshotFeedBackDelay == 0 ? 0 : 2);
        }
    }

    @SubscribeEvent
    public static void renderGunInfo(RenderGuiOverlayEvent event) {
        if (event.isCancelable() && "minecraft:experience_bar".equals(event.getOverlay().id().toString())) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            Font font = Minecraft.m_91087_().f_91062_;
            Window window = Minecraft.m_91087_().m_91268_();
            if (Clients.headshotFeedBackDelay > 0) {
                String info = Component.m_237115_((String)"screen_info.gunscraft.headshot").getString();
                float alpha = (float)Clients.headshotFeedBackDelay / 20.0f;
                event.getGuiGraphics().m_280246_(1.0f, 0.0f, 0.0f, alpha);
                event.getGuiGraphics().drawString(font, info, 0.5f * (float)window.m_85445_() - (float)font.m_92895_(info) * 0.5f, 0.75f * (float)window.m_85446_(), -1, true);
                event.getGuiGraphics().m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (player != null) {
                Object chamberStatus;
                ItemStack stackMain = player.m_21205_();
                ItemStack stackOff = player.m_21206_();
                String info1 = Component.m_237115_((String)"screen_info.gunscraft.ammo").getString();
                Item item = stackMain.m_41720_();
                if (item instanceof IGenericGun) {
                    IGenericGun gunMain = (IGenericGun)item;
                    RenderSystem.enableDepthTest();
                    event.getGuiGraphics().drawString(font, info1 + gunMain.getAmmoLeft(stackMain), 0.8f * (float)window.m_85445_(), 0.8f * (float)window.m_85446_(), -1, true);
                    event.getGuiGraphics().drawString(font, GenericGun.getFireModeStr(gunMain.getFireMode(stackMain)).getString(), 0.8f * (float)window.m_85445_(), 0.85f * (float)window.m_85446_(), -1, true);
                    Item item2 = stackMain.m_41720_();
                    if (item2 instanceof IChamberStatus && (chamberStatus = (IChamberStatus)item2).active(stackMain)) {
                        event.getGuiGraphics().m_280262_();
                        ResourceLocation texture = chamberStatus.getNeedChamber(stackMain) ? CHAMBER_EMPTY : CHAMBER_FILLED;
                        RenderSystem.enableBlend();
                        event.getGuiGraphics().m_280163_(texture, (int)(0.8f * (float)window.m_85445_()), (int)(0.9f * (float)window.m_85446_()), 0.0f, 0.0f, 8, 8, 8, 8);
                        RenderSystem.disableBlend();
                    }
                }
                if ((chamberStatus = stackOff.m_41720_()) instanceof IGenericGun) {
                    IGenericGun gunOff = (IGenericGun)chamberStatus;
                    if (Clients.offHandStatus.holdingGun.get()) {
                        event.getGuiGraphics().m_280246_(1.0f, 1.0f, 0.5f, 1.0f);
                        String s1 = info1 + gunOff.getAmmoLeft(stackOff);
                        String s2 = GenericGun.getFireModeStr(gunOff.getFireMode(stackOff)).getString();
                        RenderSystem.enableDepthTest();
                        event.getGuiGraphics().drawString(font, s1, 0.2f * (float)window.m_85445_() - (float)font.m_92895_(s1), 0.8f * (float)window.m_85446_(), -1, true);
                        event.getGuiGraphics().drawString(font, s2, 0.2f * (float)window.m_85445_() - (float)font.m_92895_(s2), 0.85f * (float)window.m_85446_(), -1, true);
                    } else {
                        event.getGuiGraphics().m_280246_(1.0f, 0.0f, 0.0f, 1.0f);
                        event.getGuiGraphics().drawString(font, Component.m_237115_((String)"screen_info.gunscraft.not_allowed_off_hand").getString(), 0.18f * (float)window.m_85445_(), 0.8f * (float)window.m_85446_(), -1, true);
                    }
                }
                event.getGuiGraphics().m_280262_();
            }
        }
    }

    static {
        exceptionHappens = false;
        lastHoldingGun = 0L;
        CHAMBER_FILLED = new ResourceLocation("gunscraft", "textures/fx/chamber_filled.png");
        CHAMBER_EMPTY = new ResourceLocation("gunscraft", "textures/fx/chamber_empty.png");
    }
}

