/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items;

import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import sheridan.gunscraft.items.BaseItem;
import sheridan.gunscraft.items.ModItems;
import sheridan.gunscraft.items.NoRepair;
import sheridan.gunscraft.sounds.SoundEvents;

public class Cash
extends BaseItem
implements NoRepair {
    public Cash() {
        super(new Item.Properties().m_41487_(1).m_41499_(5000).setNoRepair());
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"introduction.gunscraft.cash"));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.cash"));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.cash2"));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.cash_value").m_130946_(" " + (stack.m_41776_() - stack.m_41773_())));
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        return EMPTY_ENCHANTMENT_MAP;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return 0;
    }

    public int m_6473_() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    public static void setLeft(ItemStack stack, int val) {
        stack.m_41721_(stack.m_41776_() - val);
    }

    public static int getLeft(ItemStack stack) {
        return stack.m_41776_() - stack.m_41773_();
    }

    public static int getEmptyVal(ItemStack stack) {
        return stack.m_41773_();
    }

    public static int exchange(int exchangeVal, Player player, int minExchangeVal, int itemId) {
        if (exchangeVal % minExchangeVal != 0) {
            return 0;
        }
        Inventory inventory = player.m_150109_();
        int len = inventory.m_6643_();
        int val = 0;
        int finalVal = 0;
        int decCount = exchangeVal / minExchangeVal;
        Item exchangeItem = Item.m_41445_((int)itemId);
        System.out.println(exchangeItem + " " + decCount + " " + exchangeVal + " " + minExchangeVal);
        for (int i = 0; i < len; ++i) {
            if (inventory.m_8020_(i).m_41720_() != exchangeItem) continue;
            if ((val += minExchangeVal * inventory.m_8020_(i).m_41613_()) > exchangeVal) {
                int cost = exchangeVal / minExchangeVal;
                inventory.m_8020_(i).m_41764_(inventory.m_8020_(i).m_41613_() - cost);
                finalVal += exchangeVal;
                break;
            }
            inventory.m_8020_(i).m_41764_(0);
            exchangeVal -= val;
            finalVal += val;
            val = 0;
        }
        if (finalVal == 0) {
            return 0;
        }
        if (finalVal < 5000) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.CASH.get());
            Cash.setLeft(stack, finalVal);
            ItemEntity item = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
            player.m_9236_().m_7967_((Entity)item);
        } else {
            ItemEntity item;
            ItemStack stack;
            int count = finalVal / 5000;
            for (int i = 0; i < count; ++i) {
                stack = new ItemStack((ItemLike)ModItems.CASH.get());
                item = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                player.m_9236_().m_7967_((Entity)item);
            }
            int lastVal = finalVal % 5000;
            if (lastVal != 0) {
                stack = new ItemStack((ItemLike)ModItems.CASH.get());
                Cash.setLeft(stack, lastVal);
                item = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                player.m_9236_().m_7967_((Entity)item);
            }
        }
        if (finalVal > 0) {
            SoundEvents.playSound("item.vending_machine.deal_done", (LivingEntity)player, 1.0f, 1.0f);
        }
        return finalVal;
    }

    public static void costCash(Player player, int cost) {
        Inventory inventory = player.m_150109_();
        int len = inventory.m_6643_();
        for (int i = 0; i < len; ++i) {
            ItemStack prevStack = inventory.m_8020_(i);
            if (prevStack.m_41720_() != ModItems.CASH.get() || cost <= 0) continue;
            int val = Cash.getLeft(prevStack);
            if (val > cost) {
                Cash.setLeft(prevStack, val - cost);
                return;
            }
            cost -= val;
            prevStack.m_41764_(0);
        }
    }

    public static int getTotalAsset(Player player) {
        Inventory inventory = player.m_150109_();
        int len = inventory.m_6643_();
        int totalFound = 0;
        for (int i = 0; i < len; ++i) {
            ItemStack prevStack = inventory.m_8020_(i);
            if (prevStack.m_41720_() != ModItems.CASH.get()) continue;
            totalFound += Cash.getLeft(prevStack);
        }
        return totalFound;
    }
}

