/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.ammos;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import sheridan.gunscraft.events.IReloadingTask;
import sheridan.gunscraft.events.ReloadingHandler;
import sheridan.gunscraft.items.BaseItem;
import sheridan.gunscraft.items.NoRepair;
import sheridan.gunscraft.items.ammos.IGenericAmmo;
import sheridan.gunscraft.items.guns.IBreakableReloading;
import sheridan.gunscraft.items.guns.IGenericGun;

public class GenericAmmo
extends BaseItem
implements IGenericAmmo,
NoRepair {
    public GenericAmmo(int maxProvideCount) {
        super(new Item.Properties().m_41499_(maxProvideCount).setNoRepair());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        return EMPTY_ENCHANTMENT_MAP;
    }

    public int m_6473_() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    public void m_7836_(ItemStack p_41447_, Level p_41448_, Player p_41449_) {
        super.m_7836_(p_41447_, p_41448_, p_41449_);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    @Override
    public void onShoot(LivingEntity shooter, IGenericGun gun) {
    }

    @Override
    public void onShoot(LivingEntity shooter, IGenericGun gun, Vector3f aimRay) {
    }

    @Override
    public GenericAmmo getAmmo() {
        return this;
    }

    @Override
    public int getAmmoLeft(ItemStack stack) {
        return stack.m_41776_() - stack.m_41773_();
    }

    @Override
    public void setAmmoLeft(ItemStack stack, int count) {
        stack.m_41721_(stack.m_41776_() - count);
    }

    public static void manageAmmo(Player player) {
        if (player != null) {
            Inventory inventory = player.m_150109_();
            NonNullList itemStacks = inventory.f_35974_;
            HashMap<GenericAmmo, Integer> ammoCountMap = new HashMap<GenericAmmo, Integer>();
            for (ItemStack itemStack : itemStacks) {
                Item item = itemStack.m_41720_();
                if (!(item instanceof GenericAmmo)) continue;
                GenericAmmo ammo = (GenericAmmo)item;
                if (!ammoCountMap.containsKey(ammo)) {
                    ammoCountMap.put(ammo, ammo.getAmmoLeft(itemStack));
                    continue;
                }
                ammoCountMap.put(ammo, ammo.getAmmoLeft(itemStack) + (Integer)ammoCountMap.get(ammo));
            }
            if (!ammoCountMap.keySet().isEmpty()) {
                for (GenericAmmo ammo : ammoCountMap.keySet()) {
                    int count = (Integer)ammoCountMap.get(ammo);
                    GenericAmmo.mergeAmmo(ammo, count, inventory, player);
                }
            }
        }
    }

    public static void mergeAmmo(GenericAmmo ammo, int count, Inventory inventory, Player player) {
        ItemEntity item;
        ItemStack stack;
        int maxAmmoCount = ammo.m_41462_();
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            GenericAmmo ammo1;
            ItemStack stack2 = inventory.m_8020_(i);
            Item item2 = stack2.m_41720_();
            if (!(item2 instanceof GenericAmmo) || (ammo1 = (GenericAmmo)item2) != ammo) continue;
            inventory.m_8020_(i).m_41764_(0);
        }
        int stackCount = count / maxAmmoCount;
        for (int i = 0; i < stackCount; ++i) {
            stack = new ItemStack((ItemLike)ammo);
            if (inventory.m_36054_(stack)) continue;
            item = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
            player.m_9236_().m_7967_((Entity)item);
        }
        int finalLeft = count % maxAmmoCount;
        if (finalLeft != 0) {
            stack = new ItemStack((ItemLike)ammo);
            ammo.setAmmoLeft(stack, finalLeft);
            if (!inventory.m_36054_(stack)) {
                item = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                player.m_9236_().m_7967_((Entity)item);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int preReload(IGenericAmmo ammoSelector, IGenericGun gun, Player player) {
        int findAmmo = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            IGenericAmmo ammo;
            Item item = stack.m_41720_();
            if (!(item instanceof IGenericAmmo) || (ammo = (IGenericAmmo)item).getAmmo() != ammoSelector.getAmmo()) continue;
            findAmmo += ammo.getAmmoLeft(stack);
        }
        return findAmmo / gun.getAmmoPrice();
    }

    public static void onReload(IGenericAmmo ammoSelector, Player player, ItemStack heldStack, IGenericGun gun) {
        int ammoLeft;
        int maxCount = gun.getMagSize(heldStack);
        int ammoToReload = (maxCount - (ammoLeft = gun.getAmmoLeft(heldStack))) * gun.getAmmoPrice();
        if (ammoToReload > 0) {
            int findAmmo = 0;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                IGenericAmmo ammo;
                Item item = stack.m_41720_();
                if (!(item instanceof IGenericAmmo) || (ammo = (IGenericAmmo)item).getAmmo() != ammoSelector.getAmmo()) continue;
                int ammoCount = ammo.getAmmoLeft(stack);
                if (ammoCount >= ammoToReload - findAmmo) {
                    int ammoDec = ammoToReload - findAmmo;
                    findAmmo += ammoDec;
                    stack.m_41721_(stack.m_41773_() + ammoDec);
                    if (stack.m_41773_() != stack.m_41776_()) continue;
                    stack.m_41764_(0);
                    continue;
                }
                if (ammoCount < gun.getAmmoPrice()) continue;
                stack.m_41721_(stack.m_41776_());
                if (stack.m_41773_() == stack.m_41776_()) {
                    stack.m_41764_(0);
                }
                findAmmo += ammoCount;
            }
            gun.setAmmoLeft(heldStack, ammoLeft + findAmmo / gun.getAmmoPrice());
        }
    }

    public static void onSingleReload(IGenericAmmo ammoSelector, Player player, ItemStack heldStack, IGenericGun gun) {
        int ammoLeft = gun.getAmmoLeft(heldStack);
        if (ammoLeft >= gun.getMagSize(heldStack)) {
            return;
        }
        int ammoToReload = gun.getAmmoPrice();
        boolean increaseAmmo = false;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            int ammoCount;
            IGenericAmmo ammo;
            Item item = stack.m_41720_();
            if (!(item instanceof IGenericAmmo) || (ammo = (IGenericAmmo)item).getAmmo() != ammoSelector.getAmmo() || (ammoCount = ammo.getAmmoLeft(stack)) < ammoToReload) continue;
            stack.m_41721_(stack.m_41773_() + ammoToReload);
            if (stack.m_41773_() == stack.m_41776_()) {
                stack.m_41764_(0);
            }
            increaseAmmo = true;
            break;
        }
        if (increaseAmmo) {
            gun.setAmmoLeft(heldStack, ammoLeft + 1);
        } else {
            IReloadingTask iReloadingTask = ReloadingHandler.INSTANCE.taskMain;
            if (iReloadingTask instanceof IBreakableReloading) {
                IBreakableReloading task = (IBreakableReloading)((Object)iReloadingTask);
                task.end();
            }
        }
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        return 0;
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.ammo_point"));
        tooltip.add((Component)Component.m_237119_().m_130946_(stack.m_41776_() - this.getDamage(stack) + " / " + stack.m_41776_()));
    }
}

