/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.attachments.others;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsHandler;
import sheridan.gunscraft.items.attachments.util.newSys.GenericAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.IAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.IAttachmentMapModifiable;
import sheridan.gunscraft.items.attachments.util.newSys.Result;
import sheridan.gunscraft.items.attachments.util.newSys.SlotTag;
import sheridan.gunscraft.items.guns.IGenericGun;

public class SightBracket
extends GenericAttachment
implements IAttachmentMapModifiable {
    public SightBracket() {
        super("sight_bracket");
    }

    @Override
    public void onAttach(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, SlotTag slotTag, Player player) {
        SlotTag sightSlot = AttachmentsHandler.INSTANCE.searchUniqueSlot(stack, "SIGHT");
        if (sightSlot.isPresent()) {
            AttachmentsHandler.INSTANCE.unlockSlot(sightSlot.getTag(), this.getKey());
        }
    }

    @Override
    public void onOff(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, SlotTag slotTag, Player player) {
        SlotTag sightSlot = AttachmentsHandler.INSTANCE.searchUniqueSlot(stack, "SIGHT");
        if (sightSlot.isPresent()) {
            AttachmentsHandler.INSTANCE.lockSlot(sightSlot.getTag(), this.getKey());
        }
    }

    @Override
    public Result canOff(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, SlotTag slotTag, Player player) {
        IAttachment attachment = AttachmentsHandler.INSTANCE.getSight(stack);
        if (attachment != null) {
            return new Result(false, "label.gunscraft.child_slot_prevent_uninstall");
        }
        return super.canOff(gun, stack, modifiableData, slotTag, player);
    }

    @Override
    public String getKey() {
        return "sight_bracket";
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, levelIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"introduction.gunscraft.ar_railed_handguard"));
    }
}

