/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.attachments.util.newSys;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentRenderEntry;
import sheridan.gunscraft.model.modelPartCopy.ModelPart;
import sheridan.gunscraft.render.GunRenderContext;

public class AttachmentRenderContext {
    public Map<String, AttachmentRenderEntry> entryMap = new Object2ObjectArrayMap();
    public AttachmentRenderEntry sightEntry = null;

    public boolean hasMuzzle() {
        return this.entryMap.containsKey("MUZZLE");
    }

    public boolean hasSight() {
        return this.sightEntry != null || this.entryMap.containsKey("SIGHT");
    }

    public boolean hasStock() {
        return this.entryMap.containsKey("STOCK");
    }

    public boolean hasMag() {
        return this.entryMap.containsKey("MAG");
    }

    public boolean hasHandguard() {
        return this.entryMap.containsKey("HAND_GUARD");
    }

    public boolean has(String slotName) {
        return this.entryMap.containsKey(slotName);
    }

    public void onFinished() {
        AttachmentRenderEntry renderEntry = this.entryMap.get("SIGHT");
        if (renderEntry != null) {
            this.sightEntry = renderEntry;
            this.entryMap.remove("SIGHT");
        }
    }

    public void renderAhead(String slotName, GunRenderContext context) {
        AttachmentRenderEntry entry = this.entryMap.get(slotName);
        if (entry != null) {
            entry.render(context);
            this.entryMap.remove(slotName);
        }
    }

    public void renderSight(GunRenderContext context, ModelPart posePart) {
        if (this.sightEntry != null) {
            this.sightEntry.render(context, posePart);
            return;
        }
        AttachmentRenderEntry entry = this.entryMap.get("SIGHT");
        if (entry != null) {
            entry.render(context, posePart);
            this.entryMap.remove("SIGHT");
        }
    }

    public void renderAhead(String slotName, GunRenderContext context, ModelPart posePart) {
        AttachmentRenderEntry entry = this.entryMap.get(slotName);
        if (entry != null) {
            entry.render(context, posePart);
            this.entryMap.remove(slotName);
        }
    }

    public void cancel(String slotName) {
        this.entryMap.remove(slotName);
    }

    public void renderAll(GunRenderContext context) {
        for (AttachmentRenderEntry entry : this.entryMap.values()) {
            entry.render(context);
        }
        if (this.sightEntry != null) {
            this.sightEntry.render(context);
        }
    }

    public void renderAllIgnoredSight(GunRenderContext context) {
        for (AttachmentRenderEntry entry : this.entryMap.values()) {
            entry.render(context);
        }
    }
}

