/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.attachments.util.newSys;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import sheridan.gunscraft.items.attachments.util.newSys.GuiSlot;

public class AttachmentsGuiContext {
    public Map<String, GuiSlot> category = new HashMap<String, GuiSlot>();
    private List<GuiSlot> categorySequence;
    public GuiSlot selectGuiSlot;
    public int categoryNum;
    private double tempMinDis = 9999.0;
    private GuiSlot tempSelected = null;
    private final float minSelectDis = 3.0f;

    public void onConstructFinish() {
        this.categorySequence = new ArrayList<GuiSlot>();
        for (Map.Entry<String, GuiSlot> entry : this.category.entrySet()) {
            this.categorySequence.add(entry.getValue());
        }
        this.sortCategoryByZDepth();
        this.categoryNum = this.categorySequence.size();
        if (!this.categorySequence.isEmpty()) {
            for (GuiSlot guiSlot : this.categorySequence) {
                if (!guiSlot.slotTag.selectable()) continue;
                this.selectGuiSlot = guiSlot;
                break;
            }
        }
    }

    private void sortCategoryByZDepth() {
        this.categorySequence.sort((o1, o2) -> Float.compare(o1.zDepth(), o2.zDepth()));
    }

    public void renderIcons(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        for (GuiSlot slot : this.category.values()) {
            this.render(poseStack, slot);
        }
        poseStack.m_85849_();
    }

    private void render(PoseStack stack, GuiSlot slot) {
        slot.renderIcon(stack);
        if (slot.children != null) {
            for (GuiSlot child : slot.children.values()) {
                this.render(stack, child);
            }
        }
    }

    public boolean selectByMouse(double mx, double my, boolean byDepth) {
        for (GuiSlot slot : this.category.values()) {
            this.selectByMouse(slot, mx, my, byDepth);
        }
        if (this.tempSelected != null && this.tempMinDis <= 3.0) {
            this.selectGuiSlot.selected = false;
            this.selectGuiSlot = this.tempSelected;
            this.selectGuiSlot.selected = true;
            this.tempMinDis = 9999.0;
            this.tempSelected = null;
            return true;
        }
        this.tempMinDis = 9999.0;
        this.tempSelected = null;
        return false;
    }

    private void selectByMouse(GuiSlot slot, double mx, double my, boolean byDepth) {
        double dis = Math.sqrt((slot.screenX - mx) * (slot.screenX - mx) + (slot.screenY - my) * (slot.screenY - my));
        if ((dis < this.tempMinDis || dis < 3.0) && slot.slotTag.selectable()) {
            if (byDepth) {
                if (this.tempSelected != null) {
                    if (slot.screenDepth < this.tempSelected.screenDepth) {
                        this.tempMinDis = dis;
                        this.tempSelected = slot;
                    }
                } else {
                    this.tempMinDis = dis;
                    this.tempSelected = slot;
                }
            } else if (dis < this.tempMinDis) {
                this.tempMinDis = dis;
                this.tempSelected = slot;
            }
        }
        if (slot.children != null) {
            for (GuiSlot child : slot.children.values()) {
                this.selectByMouse(child, mx, my, byDepth);
            }
        }
    }

    public void selectBySlotName(String name) {
        if (this.selectGuiSlot != null) {
            this.selectGuiSlot.selected = false;
            this.selectGuiSlot = null;
        }
        this.selectBySlotName(this.category, name);
    }

    private void selectBySlotName(Map<String, GuiSlot> slots, String name) {
        for (GuiSlot guiSlot : slots.values()) {
            if (name.equals(guiSlot.slotTag.getSlotName()) && guiSlot.slotTag.selectable()) {
                guiSlot.selected = true;
                this.selectGuiSlot = guiSlot;
                return;
            }
            if (guiSlot.children == null) continue;
            this.selectBySlotName(guiSlot.children, name);
        }
    }
}

