/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.attachments.util.newSys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sheridan.gunscraft.data.GunProperties;
import sheridan.gunscraft.events.ServerEvents;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentRegistry;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentRenderContext;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentRenderEntry;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsGuiContext;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsMapGenerator;
import sheridan.gunscraft.items.attachments.util.newSys.GenericAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.GuiSlot;
import sheridan.gunscraft.items.attachments.util.newSys.IAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.Result;
import sheridan.gunscraft.items.attachments.util.newSys.SlotTag;
import sheridan.gunscraft.items.guns.IGenericGun;

public class AttachmentsHandler {
    public static final String EMPTY_ID = new ResourceLocation("gunscraft", "none").toString();
    public static final String ROOT = "ROOT";
    public static AttachmentsHandler INSTANCE = new AttachmentsHandler();
    private final DepthComparator depthComparator = new DepthComparator();

    @Deprecated
    public AttachmentsMapBuilder putAttachmentsMap(ItemStack stack) {
        if (!(stack.m_41720_() instanceof IGenericGun)) {
            throw new RuntimeException("Attachments map only for guns!");
        }
        AttachmentsMapBuilder builder = new AttachmentsMapBuilder();
        builder.setStack(stack);
        return builder;
    }

    public void putAttachmentsMap(ItemStack stack, AttachmentsMapBuilder builder) {
        if (!(stack.m_41720_() instanceof IGenericGun)) {
            throw new RuntimeException("Attachments map only for guns!");
        }
        builder.setStack(stack).build();
    }

    public CompoundTag emptySlot(String name, byte depth, String parent, String type, String key, boolean selectable, Set<String> acceptedAttachments, float ... translation) {
        return this.createSlot(name, depth, parent, type, key, true, null, selectable, EMPTY_ID, acceptedAttachments, translation);
    }

    public CompoundTag defaultSlot(String name, byte depth, String parent, String type, String key, String id, Set<String> acceptedAttachments, float ... translation) {
        return this.createSlot(name, depth, parent, type, key, false, null, true, id, acceptedAttachments, translation);
    }

    protected CompoundTag createSlot(String name, byte depth, String parent, String type, String key, boolean empty, CompoundTag child, boolean selectable, String id, Set<String> acceptedAttachments, float ... translation) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", type);
        tag.m_128379_("empty", empty);
        tag.m_128359_("attachment_id", id);
        tag.m_128359_("slot_name", name);
        tag.m_128359_("parent", parent);
        tag.m_128359_("key", key);
        tag.m_128344_("depth", depth);
        if (child != null) {
            tag.m_128365_("child", (Tag)child);
        }
        tag.m_128379_("selectable", selectable);
        ListTag pos = new ListTag();
        pos.add((Object)FloatTag.m_128566_((float)(-translation[0])));
        pos.add((Object)FloatTag.m_128566_((float)(-translation[1])));
        pos.add((Object)FloatTag.m_128566_((float)translation[2]));
        pos.add((Object)FloatTag.m_128566_((float)((float)Math.toRadians(translation[3]))));
        pos.add((Object)FloatTag.m_128566_((float)((float)Math.toRadians(translation[4]))));
        pos.add((Object)FloatTag.m_128566_((float)((float)Math.toRadians(translation[5]))));
        pos.add((Object)FloatTag.m_128566_((float)translation[6]));
        pos.add((Object)FloatTag.m_128566_((float)translation[7]));
        pos.add((Object)FloatTag.m_128566_((float)translation[8]));
        tag.m_128365_("pos", (Tag)pos);
        ListTag accepted = new ListTag();
        for (String acceptedId : acceptedAttachments) {
            accepted.add((Object)StringTag.m_129297_((String)acceptedId));
        }
        tag.m_128365_("accepted_attachments", (Tag)accepted);
        return tag;
    }

    @Deprecated
    public void removeChild(CompoundTag slot, String slotName) {
        if (slot.m_128441_("child")) {
            CompoundTag child = slot.m_128469_("child");
            child.m_128473_(slotName);
        }
    }

    @Deprecated
    public void removeChildren(CompoundTag slot, String ... slotNames) {
        if (slot.m_128441_("child")) {
            CompoundTag child = slot.m_128469_("child");
            for (String name : slotNames) {
                child.m_128473_(name);
            }
        }
    }

    @Deprecated
    public CompoundTag appendChild(CompoundTag slot, CompoundTag ... children) {
        CompoundTag tag = new CompoundTag();
        for (CompoundTag child : children) {
            tag.m_128365_(child.m_128461_("slot_name"), (Tag)child);
        }
        if (!slot.m_128441_("child")) {
            slot.m_128365_("child", (Tag)tag);
        } else {
            CompoundTag childTag = slot.m_128469_("child");
            childTag.m_128391_(tag);
        }
        return slot;
    }

    public IAttachment getMuzzle(ItemStack stack) {
        return this.getUnique(stack, "MUZZLE");
    }

    public IAttachment getSight(ItemStack stack) {
        return this.getUnique(stack, "SIGHT");
    }

    public IAttachment getStock(ItemStack stack) {
        return this.getUnique(stack, "STOCK");
    }

    public IAttachment getMag(ItemStack stack) {
        return this.getUnique(stack, "MAG");
    }

    public IAttachment getHandguard(ItemStack stack) {
        return this.getUnique(stack, "HAND_GUARD");
    }

    public IAttachment getBySlotName(ItemStack stack, String name) {
        return this.getUnique(stack, name);
    }

    public IAttachment get(CompoundTag tag) {
        if (tag != null && tag.m_128471_("selectable") && !tag.m_128471_("empty")) {
            return AttachmentRegistry.get(tag.m_128461_("attachment_id"));
        }
        return null;
    }

    public boolean unlockSlot(CompoundTag tag, String key) {
        String slotKey;
        if (!tag.m_128471_("selectable") && (slotKey = tag.m_128461_("key")).equals(key)) {
            tag.m_128379_("selectable", true);
            return true;
        }
        return false;
    }

    public boolean canLockSlot(CompoundTag tag, String key) {
        String slotKey = tag.m_128461_("key");
        return slotKey.equals(key) && tag.m_128471_("empty");
    }

    public boolean lockSlot(CompoundTag tag, String key) {
        if (this.canLockSlot(tag, key)) {
            tag.m_128379_("selectable", false);
            return true;
        }
        return false;
    }

    public AttachmentsGuiContext getGuiContext(ItemStack stack) {
        if (stack == null || stack == ItemStack.f_41583_) {
            return new AttachmentsGuiContext();
        }
        CompoundTag tag = this.checkAndGet(stack);
        return this.getGuiContext(tag);
    }

    public AttachmentsGuiContext getGuiContext(CompoundTag tag) {
        AttachmentsGuiContext attachmentsGuiContext = new AttachmentsGuiContext();
        for (String key : tag.m_128431_()) {
            if ("occupied_slots".equals(key)) continue;
            CompoundTag slot = tag.m_128469_(key);
            GuiSlot guiSlot = new GuiSlot(new SlotTag(slot));
            attachmentsGuiContext.category.put(key, guiSlot);
            this.loadChildTree(guiSlot, slot);
        }
        attachmentsGuiContext.onConstructFinish();
        return attachmentsGuiContext;
    }

    private void loadChildTree(GuiSlot guiSlot, CompoundTag tag) {
        if (tag.m_128441_("child")) {
            CompoundTag children = tag.m_128469_("child");
            for (String key : children.m_128431_()) {
                CompoundTag child = children.m_128469_(key);
                GuiSlot childSlot = new GuiSlot(new SlotTag(child));
                guiSlot.addChild(key, childSlot);
                if (!child.m_128441_("child")) continue;
                this.loadChildTree(childSlot, child);
            }
        }
    }

    public AttachmentRenderContext getContextWhenRender(ItemStack stack) {
        AttachmentRenderContext context = new AttachmentRenderContext();
        CompoundTag tag = this.checkAndGet(stack);
        if (tag != null && tag.m_128441_("occupied_slots")) {
            ListTag occupiedSlots = tag.m_128437_("occupied_slots", 10);
            for (Tag slot : occupiedSlots) {
                CompoundTag slotTag = (CompoundTag)slot;
                AttachmentRenderEntry entry = AttachmentRenderEntry.create(slotTag);
                if (entry == null) continue;
                context.entryMap.put(slotTag.m_128461_("slot_name"), entry);
            }
            context.onFinished();
        }
        return context;
    }

    public List<IAttachment> getByFilter(ItemStack stack, Filter filter) {
        ArrayList<IAttachment> list = new ArrayList<IAttachment>();
        CompoundTag tag = this.checkAndGet(stack);
        if (tag != null && tag.m_128441_("occupied_slots")) {
            ListTag occupiedSlots = tag.m_128437_("occupied_slots", 10);
            for (Tag slot : occupiedSlots) {
                CompoundTag slotTag = (CompoundTag)slot;
                IAttachment attachment = AttachmentRegistry.get(slotTag.m_128461_("attachment_id"));
                if (!filter.pass(attachment)) continue;
                list.add(attachment);
            }
        }
        return list;
    }

    public List<IAttachment> getByAttachmentType(ItemStack stack, Set<String> types) {
        ArrayList<IAttachment> list = new ArrayList<IAttachment>();
        CompoundTag tag = this.checkAndGet(stack);
        if (tag != null && tag.m_128441_("occupied_slots")) {
            ListTag occupiedSlots = tag.m_128437_("occupied_slots", 10);
            for (Tag slot : occupiedSlots) {
                CompoundTag slotTag = (CompoundTag)slot;
                IAttachment attachment = AttachmentRegistry.get(slotTag.m_128461_("attachment_id"));
                if (attachment == null || !types.contains(attachment.getType())) continue;
                list.add(attachment);
            }
        }
        return list;
    }

    public List<IAttachment> getBySlotType(ItemStack stack, Set<String> types) {
        ArrayList<IAttachment> list = new ArrayList<IAttachment>();
        CompoundTag tag = this.checkAndGet(stack);
        if (tag != null && tag.m_128441_("occupied_slots")) {
            ListTag occupiedSlots = tag.m_128437_("occupied_slots", 10);
            for (Tag slot : occupiedSlots) {
                IAttachment attachment;
                CompoundTag slotTag = (CompoundTag)slot;
                if (!types.contains(slotTag.m_128461_("type")) || (attachment = AttachmentRegistry.get(slotTag.m_128461_("attachment_id"))) == null) continue;
                list.add(attachment);
            }
        }
        return list;
    }

    public SlotTag searchUniqueSlot(ItemStack stack, String name) {
        if ("occupied_slots".equals(name)) {
            return new SlotTag(null);
        }
        CompoundTag tag = this.checkAndGet(stack);
        if (tag != null) {
            return new SlotTag(this.search(tag, name));
        }
        return new SlotTag(null);
    }

    public SlotTag findUniqueSlot(ItemStack stack, String ... path) {
        CompoundTag tag = this.checkAndGet(stack);
        CompoundTag slot = null;
        if (tag != null) {
            slot = this.find(tag, path);
        }
        return new SlotTag(slot);
    }

    public IAttachment findUnique(ItemStack stack, String ... path) {
        CompoundTag slot;
        CompoundTag tag = this.checkAndGet(stack);
        if (tag != null && (slot = this.find(tag, path)) != null && slot.m_128471_("selectable") && !slot.m_128471_("empty")) {
            return AttachmentRegistry.get(slot.m_128461_("attachment_id"));
        }
        return null;
    }

    public IAttachment searchUnique(ItemStack stack, String name) {
        CompoundTag slot;
        CompoundTag tag = this.checkAndGet(stack);
        if (tag != null && (slot = this.search(tag, name)) != null && slot.m_128471_("selectable") && !slot.m_128471_("empty")) {
            return AttachmentRegistry.get(slot.m_128461_("attachment_id"));
        }
        return null;
    }

    private CompoundTag find(CompoundTag tag, String ... path) {
        CompoundTag node = tag;
        for (String key : path) {
            if (!node.m_128441_(key)) {
                return null;
            }
            node = node.m_128469_(key);
        }
        return node;
    }

    private CompoundTag search(CompoundTag tag, String name) {
        if ("occupied_slots".equals(name)) {
            return null;
        }
        if (tag.m_128441_(name)) {
            return tag.m_128469_(name);
        }
        for (String key : tag.m_128431_()) {
            CompoundTag result;
            CompoundTag slot = tag.m_128469_(key);
            if (!slot.m_128441_("child") || (result = this.search(slot.m_128469_("child"), name)) == null) continue;
            return result;
        }
        return null;
    }

    private IAttachment getUnique(ItemStack stack, String name) {
        CompoundTag tag = this.checkAndGet(stack, name);
        if (tag != null && tag.m_128471_("selectable") && !tag.m_128471_("empty")) {
            return AttachmentRegistry.get(tag.m_128461_("attachment_id"));
        }
        return null;
    }

    private CompoundTag checkAndGet(ItemStack stack, String slot) {
        CompoundTag tag = this.checkAndGet(stack);
        if (tag != null && tag.m_128441_(slot)) {
            return tag.m_128469_(slot);
        }
        return null;
    }

    public CompoundTag getChild(CompoundTag tag, String slotName) {
        if (tag.m_128441_("child")) {
            return tag.m_128469_("child").m_128469_(slotName);
        }
        return null;
    }

    public CompoundTag checkAndGet(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("attachments_newSys")) {
            return tag.m_128469_("attachments_newSys");
        }
        return null;
    }

    public Result checkAndSet(Player player, ItemStack stack, IGenericGun gun, SlotTag slot, String attachmentId) {
        if (slot.getTag() == null) {
            return Result.FAILED;
        }
        CompoundTag tag = this.checkAndGet(stack);
        if (tag != null && tag.m_128441_("occupied_slots")) {
            ListTag occupiedSlots = tag.m_128437_("occupied_slots", 10);
            CompoundTag modifiableData = gun.getModifiableData(stack);
            Result allow = this._checkAndSet(gun, stack, player, slot.getTag(), modifiableData, attachmentId);
            if (allow.success) {
                CompoundTag mark = this.mark(slot.getTag());
                occupiedSlots.add((Object)mark);
            }
            return allow;
        }
        return Result.FAILED;
    }

    public Result checkAndRemove(Player player, ItemStack stack, IGenericGun gun, SlotTag slot) {
        CompoundTag slotTag = slot.getTag();
        if (slotTag != null) {
            CompoundTag modifiableData = gun.getModifiableData(stack);
            Result result = this._checkAndRemove(gun, stack, player, slotTag, modifiableData);
            if (result.success) {
                CompoundTag tag = this.checkAndGet(stack);
                if (tag != null && tag.m_128441_("occupied_slots")) {
                    ListTag occupiedSlots = tag.m_128437_("occupied_slots", 10);
                    occupiedSlots.removeIf(mark -> {
                        CompoundTag markTag = (CompoundTag)mark;
                        return slotTag.m_128461_("slot_name").equals(markTag.m_128461_("slot_name"));
                    });
                }
                return result;
            }
        }
        return Result.FAILED;
    }

    private Result _checkAndRemove(IGenericGun gun, ItemStack stack, Player player, CompoundTag slot, CompoundTag modifiableData) {
        IAttachment attachment;
        if (!slot.m_128471_("empty") && (attachment = AttachmentRegistry.get(slot.m_128461_("attachment_id"))) != null) {
            SlotTag slotTag = new SlotTag(slot);
            Result canTakeOff = attachment.canOff(gun, stack, modifiableData, slotTag, player);
            canTakeOff.attachment = attachment;
            if (canTakeOff.success) {
                attachment.onOff(gun, stack, modifiableData, slotTag, player);
                slot.m_128359_("attachment_id", EMPTY_ID);
                slot.m_128379_("empty", true);
                return canTakeOff;
            }
        }
        return Result.FAILED;
    }

    private Result _checkAndSet(IGenericGun gun, ItemStack stack, Player player, CompoundTag slot, CompoundTag modifiableData, String attachmentId) {
        if (!slot.m_128471_("empty")) {
            return Result.FAILED;
        }
        ListTag accepted = slot.m_128437_("accepted_attachments", 8);
        if (!accepted.contains((Object)StringTag.m_129297_((String)attachmentId))) {
            return Result.NOT_SUITABLE;
        }
        IAttachment attachment = AttachmentRegistry.get(attachmentId);
        if (attachment != null) {
            SlotTag slotTag = new SlotTag(slot);
            Result canAttach = attachment.canAttach(gun, stack, modifiableData, slotTag, player);
            canAttach.attachment = attachment;
            if (canAttach.success) {
                attachment.onAttach(gun, stack, modifiableData, slotTag, player);
                slot.m_128379_("empty", false);
                slot.m_128379_("selectable", true);
                slot.m_128359_("attachment_id", attachmentId);
                return Result.SUCCESS;
            }
            return canAttach;
        }
        return Result.FAILED;
    }

    private ListTag mergeAndSortByDepth(ListTag oldOccupiedSlots, ListTag newOccupiedSlots) {
        String slotName;
        CompoundTag slot;
        ListTag listTag = new ListTag();
        if (oldOccupiedSlots.isEmpty() && newOccupiedSlots.isEmpty()) {
            return listTag;
        }
        HashSet<String> slots = new HashSet<String>();
        for (Tag tag : oldOccupiedSlots) {
            slot = (CompoundTag)tag;
            slotName = slot.m_128461_("slot_name");
            if (slots.contains(slotName)) continue;
            listTag.add((Object)slot);
            slots.add(slotName);
        }
        for (Tag tag : newOccupiedSlots) {
            slot = (CompoundTag)tag;
            slotName = slot.m_128461_("slot_name");
            if (slots.contains(slotName)) continue;
            listTag.add((Object)slot);
            slots.add(slotName);
        }
        listTag.sort((Comparator)this.depthComparator);
        return listTag;
    }

    public void updateAttachmentMap(Player player, IGenericGun gun, ItemStack stack) {
        ListTag newOccupiedSlots;
        AttachmentsMapGenerator generator = gun.getGun().attachmentsMapGenerator;
        if (generator == null || generator.builder == null) {
            return;
        }
        CompoundTag prev = this.checkAndGet(stack);
        CompoundTag base = generator.builder.buildTag();
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag == null) {
            return;
        }
        ListTag oldOccupiedSlots = prev.m_128437_("occupied_slots", 10);
        ListTag occupiedSlots = this.mergeAndSortByDepth(oldOccupiedSlots, newOccupiedSlots = base.m_128437_("occupied_slots", 10));
        if (occupiedSlots.isEmpty()) {
            stackTag.m_128365_("attachments_newSys", (Tag)base);
            return;
        }
        this.flush(base);
        ArrayList<GenericAttachment> giveBackAttachments = new ArrayList<GenericAttachment>();
        ArrayList<CompoundTag> occupiedSlotList = new ArrayList<CompoundTag>();
        newOccupiedSlots.clear();
        CompoundTag modifiableData = gun.getGun().properties.getInitialAttachmentModifiableTag();
        for (Tag tag : occupiedSlots) {
            CompoundTag slot = (CompoundTag)tag;
            String id = slot.m_128461_("attachment_id");
            CompoundTag newSlot = this.search(base, slot.m_128461_("slot_name"));
            if (newSlot == null || !this._checkAndSet((IGenericGun)gun, (ItemStack)stack, (Player)player, (CompoundTag)newSlot, (CompoundTag)modifiableData, (String)id).success) {
                IAttachment attachment = AttachmentRegistry.get(id);
                if (attachment == null) continue;
                giveBackAttachments.add(attachment.getAttachment());
                continue;
            }
            occupiedSlotList.add(newSlot);
        }
        modifiableData.m_128356_("date", ServerEvents.latestRun);
        gun.setModifiableData(stack, modifiableData);
        if (!occupiedSlotList.isEmpty()) {
            for (CompoundTag compoundTag : occupiedSlotList) {
                CompoundTag mark = this.mark(compoundTag);
                newOccupiedSlots.add((Object)mark);
            }
        }
        if (!giveBackAttachments.isEmpty()) {
            for (Item item : giveBackAttachments) {
                ItemStack itemStack = new ItemStack((ItemLike)item);
                ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), itemStack);
                player.m_9236_().m_7967_((Entity)itemEntity);
            }
        }
        gun.setModifiableData(stack, modifiableData);
        stackTag.m_128365_("attachments_newSys", (Tag)base);
    }

    private void flush(CompoundTag tag) {
        for (String key : tag.m_128431_()) {
            CompoundTag slot = tag.m_128469_(key);
            if (slot.m_128456_()) continue;
            slot.m_128359_("attachment_id", EMPTY_ID);
            slot.m_128379_("empty", true);
            if (!slot.m_128441_("child")) continue;
            this.flush(slot.m_128469_("child"));
        }
    }

    public void updateAttachmentModifiableData(ItemStack stack, IGenericGun gun, Player player) {
        CompoundTag gunTag = stack.m_41783_();
        if (gunTag == null) {
            return;
        }
        if (gunTag.m_128441_("attachment_modifiable_data") && gunTag.m_128469_("attachment_modifiable_data").m_128454_("date") == ServerEvents.latestRun) {
            return;
        }
        GunProperties properties = gun.getGun().properties;
        if (properties != null) {
            CompoundTag tag = properties.getInitialAttachmentModifiableTag();
            CompoundTag attachments = this.checkAndGet(stack);
            this.handleUpdate(gun, stack, tag, attachments, player);
            tag.m_128356_("date", ServerEvents.latestRun);
            gunTag.m_128365_("attachment_modifiable_data", (Tag)tag);
        }
    }

    public CompoundTag mark(CompoundTag tag) {
        CompoundTag mark = new CompoundTag();
        mark.m_128359_("slot_name", tag.m_128461_("slot_name"));
        mark.m_128359_("type", tag.m_128461_("type"));
        mark.m_128359_("attachment_id", tag.m_128461_("attachment_id"));
        mark.m_128365_("pos", Objects.requireNonNull(tag.m_128423_("pos")));
        mark.m_128359_("parent", tag.m_128461_("parent"));
        mark.m_128344_("depth", tag.m_128445_("depth"));
        return mark;
    }

    private void handleUpdate(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, CompoundTag attachments, Player player) {
        if (attachments == null) {
            return;
        }
        for (String key : attachments.m_128431_()) {
            CompoundTag slot = attachments.m_128469_(key);
            IAttachment attachment = this.get(slot);
            if (attachment != null) {
                attachment.onAttach(gun, stack, modifiableData, new SlotTag(slot), player);
            }
            if (!slot.m_128441_("child")) continue;
            CompoundTag child = slot.m_128469_("child");
            this.handleUpdate(gun, stack, modifiableData, child, player);
        }
    }

    static class DepthComparator
    implements Comparator<Tag> {
        DepthComparator() {
        }

        @Override
        public int compare(Tag slot1, Tag slot2) {
            return Byte.compare(((CompoundTag)slot1).m_128445_("depth"), ((CompoundTag)slot2).m_128445_("depth"));
        }
    }

    public static class AttachmentsMapBuilder {
        private ItemStack stack;
        private final Map<String, Slot> attachmentSlotMap;
        private final CompoundTag tag;
        private final ListTag defaults = new ListTag();
        private final Set<String> slotNames = new HashSet<String>();
        private boolean built = false;

        public AttachmentsMapBuilder() {
            this.attachmentSlotMap = new HashMap<String, Slot>();
            this.tag = new CompoundTag();
        }

        public AttachmentsMapBuilder setStack(ItemStack stack) {
            this.stack = stack;
            return this;
        }

        private void put(Slot slot) {
            this.attachmentSlotMap.put(slot.slotName, slot);
        }

        public AttachmentsMapBuilder addSlot(Slot slot) {
            slot.setDepth((byte)0);
            this.put(slot);
            return this;
        }

        public AttachmentsMapBuilder addSlot(String slotName, String type, String key, boolean selectable, Set<String> acceptedAttachments) {
            Slot slot = new Slot(slotName, type, key, selectable, acceptedAttachments).setDepth((byte)0);
            this.put(slot);
            return this;
        }

        public AttachmentsMapBuilder addSlot(String slotName, String type, String key, Set<String> acceptedAttachments, String defaultId) {
            Slot slot = new Slot(slotName, type, key, acceptedAttachments, defaultId).setDepth((byte)0);
            this.put(slot);
            return this;
        }

        public static Slot muzzle(String key, boolean selectable, Set<String> acceptedAttachments) {
            return new Slot("MUZZLE", "MUZZLE", key, selectable, acceptedAttachments).setDepth((byte)0);
        }

        public static Slot sight(String key, boolean selectable, Set<String> acceptedAttachments) {
            return new Slot("SIGHT", "SIGHT", key, selectable, acceptedAttachments).setDepth((byte)0);
        }

        public static Slot stock(String key, boolean selectable, Set<String> acceptedAttachments) {
            return new Slot("STOCK", "STOCK", key, selectable, acceptedAttachments).setDepth((byte)0);
        }

        public static Slot mag(String key, boolean selectable, Set<String> acceptedAttachments) {
            return new Slot("MAG", "MAG", key, selectable, acceptedAttachments).setDepth((byte)0);
        }

        public static Slot handguard(String key, boolean selectable, Set<String> acceptedAttachments) {
            return new Slot("HAND_GUARD", "HAND_GUARD", key, selectable, acceptedAttachments).setDepth((byte)0);
        }

        private void translate() {
            for (Map.Entry<String, Slot> entry : this.attachmentSlotMap.entrySet()) {
                this.tag.m_128365_(entry.getKey(), (Tag)entry.getValue().toNBT(entry.getKey(), this.defaults, this.slotNames));
            }
            this.tag.m_128365_("occupied_slots", (Tag)this.defaults);
            this.built = true;
        }

        public CompoundTag buildTag() {
            if (!this.built) {
                this.translate();
            }
            return this.tag.m_6426_();
        }

        public void build() {
            CompoundTag stackTag;
            if (!this.built) {
                this.translate();
            }
            if ((stackTag = this.stack.m_41783_()) != null) {
                stackTag.m_128365_("attachments_newSys", (Tag)this.tag.m_6426_());
            }
        }
    }

    public static interface Filter {
        public boolean pass(IAttachment var1);
    }

    public static class Slot {
        private final String type;
        private boolean empty = true;
        private String attachmentId = EMPTY_ID;
        private final String key;
        private final String slotName;
        private Map<String, Slot> child;
        private boolean selectable;
        private final float[] translation = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        private final Set<String> acceptedAttachments;
        private boolean fromParent = false;
        private byte depth;

        public Slot(String slotName, String type, String key, boolean selectable, Set<String> acceptedAttachments) {
            this.type = type;
            this.key = key;
            this.slotName = slotName;
            this.selectable = selectable;
            this.acceptedAttachments = acceptedAttachments;
        }

        public Slot(String slotName, String type, String key, Set<String> acceptedAttachments, String defaultId) {
            this.type = type;
            this.key = key;
            this.slotName = slotName;
            this.selectable = true;
            this.empty = false;
            this.attachmentId = defaultId;
            this.acceptedAttachments = acceptedAttachments;
        }

        public Slot setDefault(String id) {
            this.selectable = true;
            this.empty = false;
            this.attachmentId = id;
            return this;
        }

        public Slot setDepth(byte depth) {
            this.depth = depth;
            return this;
        }

        public Slot pos(float x, float y, float z) {
            this.translation[0] = x;
            this.translation[1] = y;
            this.translation[2] = z;
            return this;
        }

        public Slot rot(float x, float y, float z) {
            this.translation[3] = x;
            this.translation[4] = y;
            this.translation[5] = z;
            return this;
        }

        public Slot scale(float x, float y, float z) {
            this.translation[6] = x;
            this.translation[7] = y;
            this.translation[8] = z;
            return this;
        }

        public Slot fromParent() {
            this.fromParent = true;
            return this;
        }

        protected float[] getTranslation() {
            return this.translation;
        }

        public Slot addChild(Slot slot) {
            if (this.child == null) {
                this.child = new HashMap<String, Slot>();
            }
            slot.setDepth((byte)(this.depth + 1));
            this.child.put(slot.slotName, slot);
            if (slot.fromParent) {
                float[] trans = slot.getTranslation();
                slot.pos(trans[0] + this.translation[0], trans[1] + this.translation[1], trans[2] + this.translation[2]);
                slot.rot(trans[3] + this.translation[3], trans[4] + this.translation[4], trans[5] + this.translation[5]);
            }
            return this;
        }

        public void loadChild(CompoundTag parent, Map<String, Slot> childMap, ListTag defaults, Set<String> slotNames) {
            CompoundTag children = new CompoundTag();
            for (Map.Entry<String, Slot> entry : childMap.entrySet()) {
                CompoundTag tag;
                String slotName = entry.getKey();
                Slot slot = entry.getValue();
                if (slot.depth > 126) {
                    throw new RuntimeException("the max depth of an attachment tree is 127!");
                }
                if (!slot.empty) {
                    tag = INSTANCE.defaultSlot(slotName, slot.depth, this.slotName, slot.type, slot.key, slot.attachmentId, slot.acceptedAttachments, slot.translation);
                    defaults.add((Object)INSTANCE.mark(tag));
                } else {
                    tag = INSTANCE.emptySlot(slotName, slot.depth, this.slotName, slot.type, slot.key, slot.selectable, slot.acceptedAttachments, slot.translation);
                }
                if (slotNames.contains(slotName)) {
                    throw new RuntimeException("the slot name: " + slotName + " has been used!");
                }
                slotNames.add(slotName);
                children.m_128365_(slotName, (Tag)tag);
                if (slot.child == null) continue;
                this.loadChild(tag, slot.child, defaults, slotNames);
            }
            parent.m_128365_("child", (Tag)children);
        }

        public CompoundTag toNBT(String name, ListTag defaults, Set<String> slotNames) {
            CompoundTag root;
            CompoundTag compoundTag = root = this.empty ? INSTANCE.emptySlot(name, this.depth, AttachmentsHandler.ROOT, this.type, this.key, this.selectable, this.acceptedAttachments, this.translation) : INSTANCE.defaultSlot(name, this.depth, AttachmentsHandler.ROOT, this.type, this.key, this.attachmentId, this.acceptedAttachments, this.translation);
            if (slotNames.contains(name)) {
                throw new RuntimeException("the slot name: " + name + " has been used!");
            }
            slotNames.add(name);
            if (!this.empty) {
                defaults.add((Object)INSTANCE.mark(root));
            }
            if (this.child != null) {
                this.loadChild(root, this.child, defaults, slotNames);
            }
            return root;
        }

        public String toString() {
            return "Slot{type='" + this.type + "', empty=" + this.empty + ", attachmentId='" + this.attachmentId + "', key='" + this.key + "', slotName='" + this.slotName + "', child=" + this.child + ", selectable=" + this.selectable + ", translation=" + Arrays.toString(this.translation) + ", acceptedAttachments=" + this.acceptedAttachments + "}";
        }
    }
}

