/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.attachments.util.newSys;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import sheridan.gunscraft.items.attachments.util.newSys.SlotTag;

public class GuiSlot {
    public static final ResourceLocation EMPTY = new ResourceLocation("gunscraft", "textures/gui/icon/attachment_empty_new.png");
    public static final ResourceLocation EMPTY_SELECTED = new ResourceLocation("gunscraft", "textures/gui/icon/attachment_empty_selected_new.png");
    public static final ResourceLocation OCCUPIED = new ResourceLocation("gunscraft", "textures/gui/icon/attachment_occupied_new.png");
    public static final ResourceLocation OCCUPIED_SELECTED = new ResourceLocation("gunscraft", "textures/gui/icon/attachment_occupied_selected_new.png");
    public static final float BASE_ICON_SCALE = 6.0f;
    public static final float Z_FACTOR = 5.0f;
    public SlotTag slotTag;
    public Map<String, GuiSlot> children;
    public boolean selected;
    public double screenX;
    public double screenY;
    public double screenDepth;

    public GuiSlot(SlotTag slotTag) {
        this.slotTag = slotTag;
    }

    public void addChild(String key, GuiSlot slot) {
        if (this.children == null) {
            this.children = new HashMap<String, GuiSlot>();
        }
        this.children.put(key, slot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderIcon(PoseStack poseStack) {
        if (this.slotTag.isPresent()) {
            if (!this.slotTag.selectable()) {
                return;
            }
            boolean occupied = !this.slotTag.isEmpty();
            poseStack.m_85836_();
            this.applyTrans(poseStack);
            ResourceLocation texture = this.chooseTexture(this.selected, occupied);
            float scale = 6.0f;
            if (this.selected) {
                scale = 7.5f;
            } else if (occupied) {
                scale *= 0.6f;
            }
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            matrix4f.m00(scale);
            matrix4f.m10(0.0f);
            matrix4f.m20(0.0f);
            matrix4f.m01(0.0f);
            matrix4f.m11(scale);
            matrix4f.m21(0.0f);
            matrix4f.m02(0.0f);
            matrix4f.m12(0.0f);
            matrix4f.m22(scale);
            this.updateScreenPosWhenRender(matrix4f);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172820_);
            if (occupied) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                if (this.selected) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            buffer.m_252986_(matrix4f, -0.5f, 0.5f, 5.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, 0.5f, 0.5f, 5.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, 0.5f, -0.5f, 5.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, -0.5f, -0.5f, 5.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
    }

    private void updateScreenPosWhenRender(Matrix4f matrix4f) {
        Matrix4f m0 = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        Matrix4f m1 = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f m2 = new Matrix4f((Matrix4fc)matrix4f);
        Vector4f vector4f = m2.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        Vector4f v = vector4f.mul((Matrix4fc)m0).mul((Matrix4fc)m1);
        float w = Minecraft.m_91087_().m_91268_().m_85445_();
        float h = Minecraft.m_91087_().m_91268_().m_85446_();
        this.screenX = (v.x / v.w * w + w) * 0.5f;
        this.screenY = (-(v.y / v.w) * h + h) * 0.5f;
        this.screenDepth = v.z;
    }

    private ResourceLocation chooseTexture(boolean selected, boolean occupied) {
        if (selected) {
            return occupied ? OCCUPIED_SELECTED : EMPTY_SELECTED;
        }
        return occupied ? OCCUPIED : EMPTY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyTrans(PoseStack poseStack) {
        if (this.slotTag != null) {
            this.slotTag.applyTrans(poseStack);
        }
    }

    public String toString() {
        return "GuiSlot{slotTag=" + this.slotTag + "}";
    }

    public float zDepth() {
        return this.slotTag.getZDepth();
    }
}

