/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.attachments.util.newSys;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Set;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import sheridan.gunscraft.render.utils.Quaternions;

public class GunAttachmentSlot {
    public static final ResourceLocation EMPTY = new ResourceLocation("gunscraft", "textures/gui/icon/attachment_empty.png");
    public static final ResourceLocation EMPTY_SELECTED = new ResourceLocation("gunscraft", "textures/gui/icon/attachment_empty_selected.png");
    public static final ResourceLocation OCCUPIED = new ResourceLocation("gunscraft", "textures/gui/icon/attachment_occupied.png");
    public static final ResourceLocation OCCUPIED_SELECTED = new ResourceLocation("gunscraft", "textures/gui/icon/attachment_occupied_selected.png");
    public String name;
    public static final float BASE_ICON_SCALE = 5.0f;
    public static final float Z_FACTOR = 5.0f;
    public int order;
    public Set<ResourceLocation> acceptAttachments;
    public float[][] trans;

    public boolean accept(ResourceLocation resourceLocation) {
        return this.acceptAttachments.contains(resourceLocation);
    }

    public GunAttachmentSlot(String name, Set<ResourceLocation> acceptAttachments) {
        this.name = name;
        this.acceptAttachments = acceptAttachments;
    }

    public GunAttachmentSlot setTrans(float x, float y, float z, float rx, float ry, float rz, float sx, float sy, float sz) {
        this.trans = new float[][]{{x / 16.0f, y / 16.0f, z / 16.0f}, {rx, ry, rz}, {sx, sy, sz}};
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public GunAttachmentSlot setOrder(int order) {
        this.order = order;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderIcon(PoseStack poseStack, boolean selected, boolean occupied) {
        if (this.trans != null) {
            poseStack.m_85836_();
            this.applyTrans(poseStack);
            ResourceLocation texture = this.chooseTexture(selected, occupied);
            float scale = selected ? 6.0f : 5.0f;
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            matrix4f.m00(scale);
            matrix4f.m10(0.0f);
            matrix4f.m20(0.0f);
            matrix4f.m01(0.0f);
            matrix4f.m11(scale);
            matrix4f.m21(0.0f);
            matrix4f.m02(0.0f);
            matrix4f.m12(0.0f);
            matrix4f.m22(scale);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            buffer.m_252986_(matrix4f, -0.5f, 0.5f, 5.0f).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, 0.5f, 0.5f, 5.0f).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, 0.5f, -0.5f, 5.0f).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            buffer.m_252986_(matrix4f, -0.5f, -0.5f, 5.0f).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
    }

    private ResourceLocation chooseTexture(boolean selected, boolean occupied) {
        if (selected) {
            return occupied ? OCCUPIED_SELECTED : EMPTY_SELECTED;
        }
        return occupied ? OCCUPIED : EMPTY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyTrans(PoseStack poseStack) {
        poseStack.m_252880_(this.trans[0][0], this.trans[0][1], this.trans[0][2]);
        poseStack.m_252781_(Quaternions.rotateDeg(this.trans[1][0], this.trans[1][1], this.trans[1][2]));
        poseStack.m_85841_(this.trans[2][0], this.trans[2][1], this.trans[2][2]);
    }
}

