/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.attachments.util.newSys;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentRegistry;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsHandler;
import sheridan.gunscraft.items.attachments.util.newSys.IAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.Result;
import sheridan.gunscraft.items.guns.IGenericGun;

public class SlotTag {
    private CompoundTag tag;

    public SlotTag(CompoundTag tag) {
        this.tag = tag;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public boolean isPresent() {
        return this.tag != null;
    }

    public SlotTag setTag(CompoundTag tag) {
        this.tag = tag;
        return this;
    }

    public void ifPresent(Handler handler) {
        if (this.isPresent()) {
            handler.handle(this.tag);
        }
    }

    public IAttachment getAttachment() {
        if (!this.isEmpty()) {
            return AttachmentRegistry.get(this.tag.m_128461_("attachment_id"));
        }
        return null;
    }

    public Set<String> getAcceptableAttachmentId() {
        HashSet<String> idSet = new HashSet<String>();
        if (this.isPresent()) {
            ListTag listTag = this.tag.m_128437_("accepted_attachments", 8);
            for (Tag tag : listTag) {
                String id = tag.m_7916_();
                idSet.add(id);
            }
        }
        return idSet;
    }

    public Result canUnInstall(Player player, ItemStack stack) {
        IAttachment attachment;
        if (this.isPresent() && (attachment = this.getAttachment()) != null) {
            IGenericGun gun = (IGenericGun)stack.m_41720_();
            return attachment.canOff(gun, stack, gun.getModifiableData(stack), this, player);
        }
        return Result.FAILED;
    }

    public Result canInstall(Player player, ItemStack stack, String attachmentId) {
        IAttachment attachment;
        if (this.isPresent() && this.isEmpty() && (attachment = AttachmentRegistry.get(attachmentId)) != null) {
            IGenericGun gun = (IGenericGun)stack.m_41720_();
            return attachment.canAttach(gun, stack, gun.getModifiableData(stack), this, player);
        }
        return Result.FAILED;
    }

    public Result install(Player player, ItemStack stack, String attachmentId) {
        return AttachmentsHandler.INSTANCE.checkAndSet(player, stack, (IGenericGun)stack.m_41720_(), this, attachmentId);
    }

    public Result unInstall(Player player, ItemStack stack) {
        return AttachmentsHandler.INSTANCE.checkAndRemove(player, stack, (IGenericGun)stack.m_41720_(), this);
    }

    public void unlockChildren(String key) {
        if (this.hasChild()) {
            CompoundTag children = this.tag.m_128469_("child");
            for (String slotName : children.m_128431_()) {
                CompoundTag child = children.m_128469_(slotName);
                AttachmentsHandler.INSTANCE.unlockSlot(child, key);
            }
        }
    }

    public boolean canLockChildren(String key) {
        if (this.hasChild()) {
            CompoundTag children = this.tag.m_128469_("child");
            for (String slotName : children.m_128431_()) {
                CompoundTag child = children.m_128469_(slotName);
                System.out.println(child);
                if (AttachmentsHandler.INSTANCE.canLockSlot(child, key)) continue;
                return false;
            }
        }
        return true;
    }

    public void lockChildren(String key) {
        CompoundTag children = this.tag.m_128469_("child");
        for (String slotName : children.m_128431_()) {
            CompoundTag child = children.m_128469_(slotName);
            AttachmentsHandler.INSTANCE.lockSlot(child, key);
        }
    }

    public boolean hasChild() {
        return this.isPresent() && this.tag.m_128441_("child");
    }

    public boolean isEmpty() {
        return this.tag != null && this.tag.m_128471_("empty");
    }

    public boolean selectable() {
        return this.tag != null && this.tag.m_128471_("selectable");
    }

    public String getSlotName() {
        return this.tag == null ? null : this.tag.m_128461_("slot_name");
    }

    public SlotTag getChild(String slotName) {
        if (this.tag != null) {
            return new SlotTag(AttachmentsHandler.INSTANCE.getChild(this.tag, slotName));
        }
        return new SlotTag(null);
    }

    public void applyTrans(PoseStack poseStack) {
        if (this.isPresent()) {
            ListTag listTag = this.tag.m_128437_("pos", 5);
            poseStack.m_252880_(listTag.m_128775_(0) / 16.0f, listTag.m_128775_(1) / 16.0f, listTag.m_128775_(2) / 16.0f);
        }
    }

    public float getZDepth() {
        if (this.isPresent()) {
            ListTag trans = this.tag.m_128437_("pos", 5);
            return trans.m_128775_(2);
        }
        return Float.MAX_VALUE;
    }

    public String toString() {
        return "SlotTag{tag=" + this.tag + "}";
    }

    public static interface Handler {
        public void handle(CompoundTag var1);
    }
}

