/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.attachments.util.newSys.impl;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.items.attachments.util.newSys.GenericAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.IRecoilModifiable;
import sheridan.gunscraft.items.attachments.util.newSys.SlotTag;
import sheridan.gunscraft.items.guns.IGenericGun;

public class GenericGrip
extends GenericAttachment
implements IRecoilModifiable {
    private final float recoilDecBonusRate;
    private final float aimingSpeedIncRate;
    private final float recoilAniDecX;
    private final float recoilAniDecY;
    private final float recoilAniDecZ;
    private final float recoilAniRandomDecX;
    private final float recoilAniRandomDecY;

    public GenericGrip(float recoilDecBonusRate, float aimingSpeedIncRate, float recoilAniDecX, float recoilAniDecY, float recoilAniDecZ, float recoilAniRandomDecX, float recoilAniRandomDecY) {
        super("grip");
        this.recoilDecBonusRate = recoilDecBonusRate;
        this.aimingSpeedIncRate = aimingSpeedIncRate;
        this.recoilAniDecX = recoilAniDecX;
        this.recoilAniDecY = recoilAniDecY;
        this.recoilAniDecZ = recoilAniDecZ;
        this.recoilAniRandomDecX = recoilAniRandomDecX;
        this.recoilAniRandomDecY = recoilAniRandomDecY;
    }

    @Override
    public void onAttach(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, SlotTag slotTag, Player player) {
        modifiableData.m_128350_("recoil_dec_rate", modifiableData.m_128457_("recoil_dec_rate") + this.recoilDecBonusRate);
        modifiableData.m_128350_("ads_speed_rate", modifiableData.m_128457_("ads_speed_rate") + this.aimingSpeedIncRate);
    }

    @Override
    public void onOff(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, SlotTag slotTag, Player player) {
        modifiableData.m_128350_("recoil_dec_rate", modifiableData.m_128457_("recoil_dec_rate") - this.recoilDecBonusRate);
        modifiableData.m_128350_("ads_speed_rate", modifiableData.m_128457_("ads_speed_rate") - this.aimingSpeedIncRate);
    }

    @Override
    public float[] onComputeRecoilAniScale(float[] args) {
        float scale = this.getScale();
        args[0] = Math.max(0.0f, args[0] - this.recoilAniDecX * scale);
        args[1] = Math.max(0.0f, args[1] - this.recoilAniDecY * scale);
        args[2] = Math.max(0.2f, args[2] - this.recoilAniDecZ * scale);
        return args;
    }

    @Override
    public float[] onSetRecoilAniRandomScale(float[] args) {
        float scale = this.getScale();
        args[0] = Math.max(0.5f, args[0] - this.recoilAniRandomDecX * scale);
        args[1] = Math.max(0.5f, args[1] - this.recoilAniRandomDecY * scale);
        return args;
    }

    private float getScale() {
        return Clients.mainHandStatus.aiming.get() ? 1.0f : 0.15f;
    }
}

