/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.attachments.util.newSys.impl;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import sheridan.gunscraft.items.ammos.GenericAmmo;
import sheridan.gunscraft.items.attachments.util.newSys.GenericAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.SlotTag;
import sheridan.gunscraft.items.guns.IGenericGun;

public class GenericMag
extends GenericAttachment {
    private final Map<Item, Integer> expCountMap = new HashMap<Item, Integer>();
    private final int defaultExpCount;

    public GenericMag(int defaultExpCount) {
        super("MAG");
        this.defaultExpCount = defaultExpCount;
    }

    protected void registerExpCount(Item item, int expCount) {
        this.expCountMap.put(item, expCount);
    }

    @Override
    public void onAttach(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, SlotTag slotTag, Player player) {
        if (!this.expCountMap.containsKey(stack.m_41720_())) {
            modifiableData.m_128405_("mag_size", modifiableData.m_128451_("mag_size") + this.defaultExpCount);
        } else {
            int count = this.expCountMap.get(stack.m_41720_());
            modifiableData.m_128405_("mag_size", modifiableData.m_128451_("mag_size") + count);
        }
    }

    @Override
    public void onOff(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, SlotTag slotTag, Player player) {
        GenericAmmo item;
        int count = gun.getMagSize(stack);
        int returnCount = gun.getAmmoLeft(stack) - (count -= this.expCountMap.getOrDefault(stack.m_41720_(), this.defaultExpCount).intValue());
        if (player != null && returnCount > 0 && !player.m_9236_().f_46443_ && (item = gun.getGun().ammoSelector.getAmmo()) != null) {
            ItemStack returnAmmo = new ItemStack((ItemLike)item);
            returnAmmo.m_41721_(item.m_41462_() - returnCount);
            ItemEntity entity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), returnAmmo);
            player.m_9236_().m_7967_((Entity)entity);
        }
        gun.setMagSize(stack, count);
    }
}

