/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.attachments.util.newSys.impl;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.items.attachments.util.newSys.GenericAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.IRecoilModifiable;
import sheridan.gunscraft.items.attachments.util.newSys.SlotTag;
import sheridan.gunscraft.items.guns.IGenericGun;

public class GenericMuzzle
extends GenericAttachment
implements IRecoilModifiable {
    private final String muzzleFlashState;
    private final float recoilUpDecRate;
    private final float recoilRandomDecRate;
    private final float recoilAniDecX;
    private final float recoilAniDecY;
    private final float recoilAniDecZ;
    private final float recoilAniRandomDecX;
    private final float recoilAniRandomDecY;
    private final float normalRate;

    public GenericMuzzle(float recoilUpDecRate, float recoilRandomDecRate, float recoilAniDecX, float recoilAniDecY, float recoilAniDecZ, float recoilAniRandomDecX, float recoilAniRandomDecY, float normalRate, String muzzleFlashState) {
        super("MUZZLE");
        this.recoilUpDecRate = recoilUpDecRate;
        this.recoilRandomDecRate = recoilRandomDecRate;
        this.recoilAniDecX = recoilAniDecX;
        this.recoilAniDecY = recoilAniDecY;
        this.recoilAniDecZ = recoilAniDecZ;
        this.recoilAniRandomDecX = recoilAniRandomDecX;
        this.recoilAniRandomDecY = recoilAniRandomDecY;
        this.normalRate = normalRate;
        this.muzzleFlashState = muzzleFlashState;
    }

    @Override
    public float[] onComputeRecoilAniScale(float[] args) {
        float scale = this.getScale();
        args[0] = Math.max(0.0f, args[0] - this.recoilAniDecX * scale);
        args[1] = Math.max(0.0f, args[1] - this.recoilAniDecY * scale);
        args[2] = Math.max(0.2f, args[2] - this.recoilAniDecZ * scale);
        return args;
    }

    @Override
    public float[] onSetRecoilAniRandomScale(float[] args) {
        float scale = this.getScale();
        args[0] = Math.max(0.5f, args[0] - this.recoilAniRandomDecX * scale);
        args[1] = Math.max(0.5f, args[1] - this.recoilAniRandomDecY * scale);
        return args;
    }

    private float getScale() {
        return Clients.mainHandStatus.aiming.get() ? 1.0f : this.normalRate;
    }

    @Override
    public void onAttach(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, SlotTag slotTag, Player player) {
        modifiableData.m_128350_("recoil_up_rate", modifiableData.m_128457_("recoil_up_rate") - this.recoilUpDecRate);
        modifiableData.m_128350_("recoil_random_rate", modifiableData.m_128457_("recoil_random_rate") - this.recoilRandomDecRate);
        modifiableData.m_128359_("muzzle_flash_state", this.muzzleFlashState);
    }

    @Override
    public void onOff(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, SlotTag slotTag, Player player) {
        modifiableData.m_128350_("recoil_up_rate", modifiableData.m_128457_("recoil_up_rate") + this.recoilUpDecRate);
        modifiableData.m_128350_("recoil_random_rate", modifiableData.m_128457_("recoil_random_rate") + this.recoilRandomDecRate);
        modifiableData.m_128359_("muzzle_flash_state", "normal");
    }
}

