/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.attachments.util.newSys.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.items.attachments.util.newSys.GenericAttachment;
import sheridan.gunscraft.items.attachments.util.newSys.IAimingPosModifiable;
import sheridan.gunscraft.items.attachments.util.newSys.SlotTag;
import sheridan.gunscraft.items.guns.IGenericGun;

public class GenericScope
extends GenericAttachment
implements IAimingPosModifiable {
    public float rate;
    protected float tempFov = -1.0f;
    protected static float tempNormalField = -1.0f;
    protected Map<Item, float[]> aimingPosTransMap = new HashMap<Item, float[]>();
    private double tempMouseSensitivity = -1.0;
    protected float globalZ = 0.0f;

    public GenericScope(float rate) {
        super("SIGHT");
        this.rate = rate;
    }

    public float onFovModify(ItemStack stack, IGenericGun gun, float prevFov) {
        float aimingProgress = Clients.mainHandStatus.aimingProgress;
        return Mth.m_14179_((float)aimingProgress, (float)prevFov, (float)this.getFov());
    }

    @Override
    public float[] handleAimingTrans(Item item, float[] aimingTrans) {
        float[] trans = this.aimingPosTransMap.get(item);
        if (trans != null) {
            aimingTrans[0] = aimingTrans[0] + trans[0];
            aimingTrans[1] = aimingTrans[1] + trans[1];
            aimingTrans[2] = aimingTrans[2] + (trans[2] + this.globalZ);
        }
        return aimingTrans;
    }

    public float getFov() {
        if (this.tempFov != -1.0f) {
            return this.tempFov;
        }
        if (tempNormalField == -1.0f) {
            tempNormalField = this.getNormalField();
        }
        this.tempFov = (float)(Math.atan(tempNormalField / this.rate) * 180.0 / Math.PI * 2.0);
        return this.tempFov;
    }

    protected float getNormalField() {
        GameRenderer renderer = Minecraft.m_91087_().f_91063_;
        return (float)(renderer.m_172715_() ? Math.tan(Math.toRadians(45.0)) : Math.tan(Math.toRadians(35.0)));
    }

    protected void registerTrans(Item item, float ... trans) {
        this.aimingPosTransMap.put(item, trans);
    }

    public void handleMouseSensitivity() {
        float aimingProgress = Clients.mainHandStatus.getLerpAimingProgress();
        if (Clients.mainHandStatus.aiming.get()) {
            Clients.cameraRecoilShakeAnimationScale = Mth.m_14179_((float)aimingProgress, (float)1.0f, (float)(1.0f / this.rate));
            if (this.tempMouseSensitivity == -1.0) {
                this.tempMouseSensitivity = (Double)Minecraft.m_91087_().f_91066_.m_231964_().m_231551_();
            } else {
                double prevMouseSensitivity = Mth.m_14139_((double)aimingProgress, (double)this.tempMouseSensitivity, (double)(this.tempMouseSensitivity * (double)(1.0f / this.rate)));
                Minecraft.m_91087_().f_91066_.m_231964_().m_231514_((Object)prevMouseSensitivity);
            }
        } else {
            if (this.tempMouseSensitivity != -1.0) {
                Minecraft.m_91087_().f_91066_.m_231964_().m_231514_((Object)this.tempMouseSensitivity);
            }
            this.tempMouseSensitivity = -1.0;
            Clients.cameraRecoilShakeAnimationScale = 1.0f;
        }
    }

    public boolean modifyModelFovWhenAiming() {
        return true;
    }

    public float getModelFovWhenAiming() {
        return 12.5f;
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, levelIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.scope_rate").m_130946_(String.valueOf(this.rate)));
    }

    @Override
    public void onAttach(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, SlotTag slotTag, Player player) {
    }

    @Override
    public void onOff(IGenericGun gun, ItemStack stack, CompoundTag modifiableData, SlotTag slotTag, Player player) {
    }
}

