/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.guns;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.data.GunProperties;
import sheridan.gunscraft.events.IReloadingTask;
import sheridan.gunscraft.events.ReloadingHandler;
import sheridan.gunscraft.items.guns.GenericGun;
import sheridan.gunscraft.items.guns.IChamberStatus;
import sheridan.gunscraft.items.guns.utils.ChamberTaskHandler;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.ChamberGunPacket;
import sheridan.gunscraft.render.TransformData;
import sheridan.gunscraft.render.bulletShell.BulletShellRenderer;
import sheridan.gunscraft.sounds.SoundEvents;

public class BoltActionGun
extends GenericGun
implements IChamberStatus {
    public int chamberActionStartDelay;
    public int chamberActionDelay;
    public int chamberBulletShellThrowDelay;
    public String chamberSound;
    public long shotBreakAimingDelay;

    public BoltActionGun(Item.Properties properties, int[] fireModes, String normalFireSound, String normalReloadSound, int chamberCount, String seriesName, String bulletType, String type, ResourceLocation[] textures, int chamberActionStartDuration, int chamberActionDelay, int chamberBulletShellThrowDelay, long shotBreakAimingDelay, String chamberSound, GunProperties gunProperties) {
        super(properties, false, fireModes, normalFireSound, normalReloadSound, chamberCount, seriesName, bulletType, type, textures, gunProperties);
        this.chamberActionStartDelay = chamberActionStartDuration;
        this.chamberActionDelay = chamberActionDelay;
        this.chamberBulletShellThrowDelay = chamberBulletShellThrowDelay;
        this.shotBreakAimingDelay = shotBreakAimingDelay;
        this.chamberSound = chamberSound;
    }

    @Override
    public boolean preShoot(ItemStack stack, LivingEntity entity, boolean mainHand) {
        if (this.getAmmoLeft(stack) <= 0) {
            return false;
        }
        if (this.getNeedChamber(stack)) {
            ChamberTaskHandler.INSTANCE.setChamberTask(this.getChamberTask(false, stack));
            return false;
        }
        boolean shot = super.preShoot(stack, entity, mainHand);
        if (shot) {
            this.setNeedChamber(stack, true);
            ChamberTaskHandler.INSTANCE.onShoot(this.getChamberTask(true, stack));
        }
        return shot;
    }

    public ChamberTask getChamberTask(boolean afterShoot, ItemStack stack) {
        boolean timeFlag;
        boolean bl = timeFlag = System.currentTimeMillis() - Clients.mainHandStatus.lastShoot > this.shotBreakAimingDelay;
        if (!afterShoot) {
            if (timeFlag) {
                return new ChamberTask(stack, this, 2, this.chamberActionDelay - this.chamberActionStartDelay + 2, this.chamberBulletShellThrowDelay);
            }
        } else {
            return new ChamberTask(stack, this, this.chamberActionStartDelay, this.chamberActionDelay, this.chamberBulletShellThrowDelay);
        }
        return null;
    }

    @Override
    public void shoot(ItemStack stack, LivingEntity entity, boolean mainHand, float spread) {
        int ammoLeft = this.getAmmoLeft(stack);
        if (ammoLeft > 0) {
            this.setNeedChamber(stack, true);
        }
        super.shoot(stack, entity, mainHand, spread);
    }

    @Override
    public boolean shootCreateBulletShell() {
        return false;
    }

    public void doChamber(ItemStack stack, Player player, BoltActionGun gun, boolean startChamber) {
        if (startChamber) {
            SoundEvents.playSound(gun.chamberSound, (LivingEntity)player, 1.0f, 1.0f);
            player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                cap.lastChamber = System.currentTimeMillis();
                cap.dataChanged = true;
            });
        } else {
            this.setNeedChamber(stack, false);
        }
    }

    @Override
    public void reload(ItemStack stack, LivingEntity entity, boolean mainHand) {
        super.reload(stack, entity, mainHand);
        this.setNeedChamber(stack, false);
    }

    @Override
    public int getReloadLength(ItemStack stack) {
        return this.getAmmoLeft(stack) > 0 && !this.getNeedChamber(stack) ? this.getBaseReloadLength(stack) : this.getFullReloadLength(stack);
    }

    @Override
    public IReloadingTask getReloadTask(ItemStack stack, boolean mainHand) {
        return new ReloadingHandler.GenericReloadTask(stack, this.getReloadLength(stack), mainHand, this.getAmmoLeft(stack) == 0 || this.getNeedChamber(stack));
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return this.getAmmoLeft(stack) - 1 >= 0;
    }

    @Override
    public boolean active(ItemStack stack) {
        return true;
    }

    @Override
    public boolean getNeedChamber(ItemStack stack) {
        CompoundTag tag = this.checkAndGet(stack);
        return tag.m_128441_("need_chamber") && tag.m_128471_("need_chamber");
    }

    public void setNeedChamber(ItemStack stack, boolean needChamber) {
        CompoundTag tag = this.checkAndGet(stack);
        tag.m_128379_("need_chamber", needChamber);
    }

    @Override
    public void m_7836_(ItemStack stack, Level levelIn, Player playerIn) {
        super.m_7836_(stack, levelIn, playerIn);
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            nbt.m_128379_("need_chamber", false);
        }
    }

    @Override
    public boolean shouldHandleAiming(ItemStack stack) {
        boolean timeFlag;
        boolean bl = timeFlag = System.currentTimeMillis() - Clients.mainHandStatus.lastShoot > this.shotBreakAimingDelay;
        boolean shouldHandle = !timeFlag ? true : !this.getNeedChamber(stack);
        return shouldHandle;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ChamberTask {
        public ItemStack stack;
        public BoltActionGun gun;
        public int chamberActionStartDuration;
        public int bulletThrowDelay;
        public int chamberActionDelay;
        public boolean completed = false;
        private boolean chamberHandled = false;
        private boolean bulletShellThrew = false;
        private int tick = 0;
        public boolean restrictNBT = true;

        public ChamberTask(ItemStack stack, BoltActionGun gun, int chamberActionStartDuration, int chamberActionDelay, int chamberBulletShellThrowDelay) {
            this.stack = stack;
            this.gun = gun;
            this.chamberActionStartDuration = chamberActionStartDuration;
            this.chamberActionDelay = chamberActionDelay;
            this.bulletThrowDelay = chamberBulletShellThrowDelay;
        }

        public void tick() {
            if (this.completed) {
                return;
            }
            if (this.tick >= this.chamberActionStartDuration && !this.chamberHandled) {
                this.chamberHandled = true;
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    SoundEvents.playSound(this.gun.chamberSound, (LivingEntity)player, 1.0f, 1.0f);
                }
                PacketHandler.simpleChannel.sendToServer((Object)new ChamberGunPacket(true));
                Clients.mainHandStatus.lastChamber = System.currentTimeMillis();
            }
            if (this.chamberHandled && this.tick >= this.chamberActionStartDuration + this.bulletThrowDelay && !this.bulletShellThrew) {
                Minecraft.m_91087_().m_6937_(() -> {
                    TransformData.BulletShellAniData bulletShellAniData;
                    TransformData transformData = Clients.transformDataMap.get(this.gun);
                    if (transformData != null && (bulletShellAniData = transformData.bulletShellAniData) != null) {
                        BulletShellRenderer.push(bulletShellAniData.xSpeed, bulletShellAniData.ySpeed, bulletShellAniData.zSpeed, bulletShellAniData.rSpeed, bulletShellAniData.drop, bulletShellAniData.random, bulletShellAniData.length, this.gun.getBulletType(), true);
                    }
                });
                this.bulletShellThrew = true;
            }
            if (this.tick >= this.chamberActionDelay) {
                this.completed = true;
                if (this.gun.getAmmoLeft(this.stack) > 0) {
                    PacketHandler.simpleChannel.sendToServer((Object)new ChamberGunPacket(false));
                    this.gun.setNeedChamber(this.stack, false);
                }
            }
            ++this.tick;
        }
    }
}

