/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.guns;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import sheridan.gunscraft.ClientGlobalWeaponTranslator;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.animation.recoil.RecoilAnimationHandler;
import sheridan.gunscraft.animation.recoil.RecoilCameraHandler;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.config.CommonConfig;
import sheridan.gunscraft.data.GunProperties;
import sheridan.gunscraft.events.IReloadingTask;
import sheridan.gunscraft.events.ReloadingHandler;
import sheridan.gunscraft.items.BaseItem;
import sheridan.gunscraft.items.ammos.GenericAmmo;
import sheridan.gunscraft.items.ammos.IGenericAmmo;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsHandler;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentsMapGenerator;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.items.guns.utils.ChamberTaskHandler;
import sheridan.gunscraft.items.guns.utils.ProjectileData;
import sheridan.gunscraft.render.TransformData;
import sheridan.gunscraft.render.bulletShell.BulletShellRenderer;
import sheridan.gunscraft.sounds.SoundEvents;

public class GenericGun
extends BaseItem
implements IGenericGun {
    public static final int SEMI = 0;
    public static final int BURST = 1;
    public static final int AUTO = 2;
    public static final int CHARGE = 3;
    public static final int VOLLEY = 4;
    public static final String PISTOL = "pistol";
    public static final String AR = "ar";
    public static final String AK = "ak";
    public static final String LMG = "lmg";
    public static final String RIFLE = "rifle";
    public static final String MG = "mg";
    public static final String REVOLVER = "revolver";
    public static final String CAL_50_RIFLE = "cal_50_rifle";
    public static final String SMG = "smg";
    public static final String SHOTGUN = "shotgun";
    public static final String DMR = "DMR";
    private static final Map<Integer, MutableComponent> FIRE_MODE_NAME_MAP = new HashMap<Integer, MutableComponent>();
    public ResourceLocation[] textures;
    public boolean canHoldInOneHand;
    public int[] fireModes;
    public String normalFireSound;
    public String normalReloadSound;
    public int chamberCount;
    protected String seriesName;
    public String bulletType;
    public String type;
    public IGenericAmmo ammoSelector;
    public GunProperties properties;
    public AttachmentsMapGenerator attachmentsMapGenerator;

    public GenericGun(Item.Properties properties, boolean canHoldInOneHand, int[] fireModes, String normalFireSound, String normalReloadSound, int chamberCount, String seriesName, String bulletType, String type, ResourceLocation[] textures, GunProperties gunProperties) {
        super(properties);
        this.canHoldInOneHand = canHoldInOneHand;
        this.fireModes = fireModes;
        this.normalFireSound = normalFireSound;
        this.normalReloadSound = normalReloadSound;
        this.chamberCount = chamberCount;
        this.bulletType = bulletType;
        this.type = type;
        this.seriesName = seriesName;
        this.textures = textures;
        this.properties = gunProperties;
    }

    @Override
    public void setAmmoSelector(IGenericAmmo ammoSelector) {
        this.ammoSelector = ammoSelector;
    }

    public void setProjectileData(ProjectileData data) {
        if (this.properties != null) {
            this.properties.projectileData = data;
        }
    }

    public GenericGun setAttachmentsMapGenerator(AttachmentsMapGenerator generator) {
        this.attachmentsMapGenerator = generator;
        return this;
    }

    @Override
    public int getAmmoPrice() {
        return this.properties.ammoPrice;
    }

    public static MutableComponent getFireModeStr(int key) {
        if (FIRE_MODE_NAME_MAP.containsKey(key)) {
            return FIRE_MODE_NAME_MAP.get(key);
        }
        return Component.m_237115_((String)"screen_info.gunscraft.unknown");
    }

    @Override
    public ResourceLocation getTexture(int index) {
        return this.textures[index % this.textures.length];
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean f1;
        boolean reloadFlag;
        ItemStack mainHandStack;
        ItemStack itemStack = mainHandStack = Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_.m_21205_() : null;
        if (oldStack.m_41720_() != newStack.m_41720_() || slotChanged && mainHandStack == newStack) {
            Clients.equipDuration = 5;
        }
        if (Clients.equipDuration > 0) {
            --Clients.equipDuration;
        }
        if (slotChanged) {
            ReloadingHandler.INSTANCE.breakTask(true);
            ReloadingHandler.INSTANCE.breakTask(false);
            Clients.mainHandStatus.dryFired = false;
            Clients.mainHandStatus.lastInspect = 0L;
            ChamberTaskHandler.INSTANCE.clear();
        }
        if (reloadFlag = ReloadingHandler.INSTANCE.getGenericReloadFlag()) {
            return true;
        }
        if (mainHandStack == newStack) {
            return Clients.equipDuration > 0;
        }
        boolean bl = f1 = oldStack.m_41720_() != newStack.m_41720_() || slotChanged;
        if (f1) {
            BulletShellRenderer.clear();
        }
        return f1;
    }

    @Override
    public int getCurrentTextureIndex(ItemStack stack) {
        return 0;
    }

    protected int randomIndex() {
        return Math.random() <= 0.5 ? 1 : -1;
    }

    protected float getSprintingBreakDelay() {
        return 1.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean preShoot(ItemStack stack, LivingEntity entity, boolean mainHand) {
        int ammoLeft = this.getAmmoLeft(stack);
        boolean canPass = ammoLeft > 0;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (canPass && player != null) {
            float shootSpread;
            long now = System.currentTimeMillis();
            TransformData transformData = Clients.transformDataMap.get(stack.m_41720_());
            if (mainHand) {
                Clients.mainHandStatus.lastShoot = now;
                Clients.mainHandStatus.lastInspect = 0L;
            } else {
                Clients.offHandStatus.lastShoot = now;
            }
            player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                if (mainHand) {
                    cap.lastShootRight = now;
                } else {
                    cap.lastShootLeft = now;
                }
            });
            int fireMode = this.getFireMode(stack);
            ClientGlobalWeaponTranslator.INSTANCE.disableSprintingTrans(this.getSprintingBreakDelay(), mainHand);
            int directionX = this.randomIndex();
            int directionY = this.randomIndex();
            float recoilUp = this.getRecoilUp(stack);
            float recoilRandom = this.getRecoilRandom(stack);
            if (transformData.recoilAniData != null) {
                if (player.m_6047_()) {
                    recoilUp *= 0.75f;
                    recoilRandom *= 0.75f;
                }
                if (fireMode == 4 && this.chamberCount > 1) {
                    float recoil = 1.0f;
                    recoil = this.chamberCount <= ammoLeft ? (recoil *= (float)this.chamberCount * 0.7f) : (recoil *= Math.max(1.0f, (float)ammoLeft * 0.7f));
                    recoilUp *= recoil;
                    recoilRandom *= recoil;
                }
                RecoilAnimationHandler.INSTANCE.onShoot(transformData.recoilAniData, mainHand, directionX, directionY);
                RecoilCameraHandler.INSTANCE.onShoot(recoilUp, recoilRandom, this.getRecoilDec(stack), directionX);
            }
            if (fireMode == 0 || fireMode == 3 || fireMode == 4) {
                if (mainHand) {
                    Clients.mainHandStatus.buttonDown.set(false);
                    Clients.mainHandStatus.fireCount = 0;
                } else {
                    Clients.offHandStatus.buttonDown.set(false);
                    Clients.offHandStatus.fireCount = 0;
                }
            } else if (fireMode == 1) {
                if (mainHand) {
                    if (Clients.mainHandStatus.fireCount + 1 >= this.properties.burstCount) {
                        Clients.mainHandStatus.fireCount = 0;
                        Clients.mainHandStatus.buttonDown.set(false);
                    }
                } else if (Clients.offHandStatus.fireCount + 1 >= this.properties.burstCount) {
                    Clients.offHandStatus.fireCount = 0;
                    Clients.offHandStatus.buttonDown.set(false);
                }
            }
            float f = shootSpread = entity.m_6047_() ? this.properties.spreadPreShoot * 0.7f : this.properties.spreadPreShoot;
            if (Clients.mainHandStatus.aiming.get()) {
                shootSpread *= 0.7f;
            }
            if (mainHand) {
                Clients.mainHandStatus.dryFired = false;
            } else {
                Clients.offHandStatus.dryFired = false;
            }
            Clients.bulletSpread += shootSpread;
            float[] soundArgs = this.getSoundArgs(stack, (IGenericGun)stack.m_41720_());
            SoundEvents.playSound(this.normalFireSound, entity, soundArgs[0], (float)((double)soundArgs[1] + Math.random() * (double)0.1f));
        }
        if (!canPass) {
            boolean dryFired = Clients.getDryFired(mainHand);
            if (!dryFired) {
                SoundEvents.playSound("item.gun.dry_fire", entity, 1.0f, 1.0f);
            }
            Clients.dryFired(mainHand);
        }
        return canPass;
    }

    @Override
    public float[] getSoundArgs(ItemStack stack, IGenericGun gun) {
        float[] soundArgs = new float[]{1.0f, 1.0f};
        CompoundTag tag = this.getModifiableData(stack);
        soundArgs[0] = tag.m_128457_("fire_sound_vol_rate") * this.properties.fireSoundVol;
        soundArgs[1] = tag.m_128457_("fire_sound_pitch_rate") * this.properties.fireSoundPitch;
        return soundArgs;
    }

    @Override
    public void setFireSoundArgsRate(float pitch, float vol, ItemStack stack) {
        CompoundTag nbt = this.getModifiableData(stack);
        nbt.m_128350_("fire_sound_pitch_rate", pitch);
        nbt.m_128350_("fire_sound_vol_rate", vol);
    }

    @Override
    public boolean shouldHandleWhileReloading(ItemStack stack) {
        return false;
    }

    @Override
    public void shoot(ItemStack stack, LivingEntity entity, boolean mainHand, float spread) {
        int ammoLeft = this.getAmmoLeft(stack);
        if (ammoLeft > 0 && entity instanceof Player) {
            boolean useAmmo;
            Player player = (Player)entity;
            long now = System.currentTimeMillis();
            player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                if (mainHand) {
                    cap.lastShootRight = now;
                } else {
                    cap.lastShootLeft = now;
                }
                cap.dataChanged = true;
            });
            boolean bl = useAmmo = !player.m_7500_() || CommonConfig.getCreativeModeUseAmmo();
            if (useAmmo) {
                this.setAmmoLeft(stack, ammoLeft - 1);
            }
            if (!entity.m_9236_().m_5776_() && this.properties.projectileData != null) {
                this.properties.projectileData.spawnProjectile((Player)entity, entity.m_20154_(), spread, this);
            }
        }
    }

    @Override
    public void reload(ItemStack stack, LivingEntity entity, boolean mainHand) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.ammoSelector != null) {
                GenericAmmo.onReload(this.ammoSelector, player, stack, this);
            } else {
                this.setAmmoLeft(stack, this.getMagSize(stack));
            }
            player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                cap.reloading = false;
                cap.dataChanged = true;
            });
        }
    }

    @Override
    public boolean canHoldInOneHand() {
        return this.canHoldInOneHand;
    }

    @Override
    public int getMagSize(ItemStack stack) {
        return this.getModifiableData(stack).m_128451_("mag_size");
    }

    @Override
    public void setMagSize(ItemStack stack, int magSize) {
        CompoundTag nbt = this.getModifiableData(stack);
        nbt.m_128405_("mag_size", magSize);
    }

    @Override
    public int getAmmoLeft(ItemStack stack) {
        CompoundTag nbt = this.checkAndGet(stack);
        return nbt.m_128441_("ammo_left") ? nbt.m_128451_("ammo_left") : 0;
    }

    @Override
    public void setAmmoLeft(ItemStack stack, int count) {
        CompoundTag nbt = this.checkAndGet(stack);
        nbt.m_128405_("ammo_left", count);
    }

    @Override
    public int getFireMode(ItemStack stack) {
        return this.checkAndGet(stack).m_128451_("fire_mode");
    }

    @Override
    public void setFireMode(ItemStack stack, int mode) {
        CompoundTag nbt = this.checkAndGet(stack);
        nbt.m_128405_("fire_mode", mode);
    }

    @Override
    public void switchFireMode(ItemStack stack) {
        if (this.fireModes.length > 1) {
            int prevMode = this.getFireMode(stack);
            int index = 0;
            for (int i = 0; i < this.fireModes.length; ++i) {
                if (prevMode != this.fireModes[i]) continue;
                index = i;
            }
            ++index;
            this.setFireMode(stack, this.fireModes[index %= this.fireModes.length]);
        }
    }

    @Override
    public int getShootDelay() {
        return this.properties.shootDelay;
    }

    @Override
    public float getMinSpread(ItemStack stack) {
        CompoundTag nbt = this.getModifiableData(stack);
        float spread = this.properties.baseSpread;
        return nbt.m_128457_("min_spread_rate") * spread;
    }

    @Override
    public float getMaxSpread(ItemStack stack) {
        CompoundTag nbt = this.getModifiableData(stack);
        return nbt.m_128457_("max_spread_rate") * this.properties.maxSpread;
    }

    @Override
    public boolean isFreeBlot() {
        return this.properties.isFreeBolt;
    }

    @Override
    public boolean isPistol() {
        return this.properties.isPistol;
    }

    @Override
    public int getReloadLength(ItemStack stack) {
        return this.getAmmoLeft(stack) > 0 ? this.getBaseReloadLength(stack) : this.getFullReloadLength(stack);
    }

    @Override
    public String getMuzzleFlashState(ItemStack stack) {
        CompoundTag nbt = this.getModifiableData(stack);
        return nbt.m_128461_("muzzle_flash_state");
    }

    @Override
    public int getBurstCount() {
        return this.properties.burstCount;
    }

    @Override
    public float getAimingSpeed(ItemStack stack) {
        CompoundTag nbt = this.getModifiableData(stack);
        return nbt.m_128457_("ads_speed_rate") * this.properties.adsSpeed;
    }

    @Override
    public float getRecoilUp(ItemStack stack) {
        CompoundTag nbt = this.getModifiableData(stack);
        return nbt.m_128457_("recoil_up_rate") * this.properties.recoilUp;
    }

    @Override
    public float getRecoilRandom(ItemStack stack) {
        CompoundTag nbt = this.getModifiableData(stack);
        return nbt.m_128457_("recoil_random_rate") * this.properties.recoilRandom;
    }

    @Override
    public float getRecoilDec(ItemStack stack) {
        CompoundTag nbt = this.getModifiableData(stack);
        return nbt.m_128457_("recoil_dec_rate") * this.properties.recoilDec;
    }

    @Override
    public float getMoveSpreadFactor(ItemStack stack) {
        CompoundTag nbt = this.getModifiableData(stack);
        return nbt.m_128457_("move_spread_factor_rate") * 1.2f;
    }

    @Override
    public float getSprintingSpreadFactor(ItemStack stack) {
        CompoundTag nbt = this.getModifiableData(stack);
        return nbt.m_128457_("sprinting_spread_factor_rate") * 1.4f;
    }

    @Override
    public void setAimingSpeedRate(ItemStack stack, float rate) {
        CompoundTag nbt = this.getModifiableData(stack);
        nbt.m_128350_("ads_speed_rate", rate);
    }

    @Override
    public void setRecoilUpRate(ItemStack stack, float rate) {
        CompoundTag nbt = this.getModifiableData(stack);
        nbt.m_128350_("recoil_up_rate", rate);
    }

    @Override
    public void setRecoilRandomRate(ItemStack stack, float rate) {
        CompoundTag nbt = this.getModifiableData(stack);
        nbt.m_128350_("recoil_random_rate", rate);
    }

    @Override
    public void setRecoilDecRate(ItemStack stack, float rate) {
        CompoundTag nbt = this.getModifiableData(stack);
        nbt.m_128350_("recoil_dec_rate", rate);
    }

    @Override
    public float getBaseAimingSpeed() {
        return this.properties.adsSpeed;
    }

    @Override
    public float getBaseRecoilUp() {
        return this.properties.recoilUp;
    }

    @Override
    public float getBaseRecoilRandom() {
        return this.properties.recoilRandom;
    }

    @Override
    public float getBaseRecoilDec() {
        return this.properties.recoilDec;
    }

    @Override
    public String getSeriesName() {
        return this.seriesName;
    }

    @Override
    public String getBulletType() {
        return this.bulletType;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setMuzzleFlashState(ItemStack stack, String state) {
        CompoundTag tag = this.getModifiableData(stack);
        tag.m_128359_("muzzle_flash_state", state);
    }

    @Override
    public void setMoveSpreadFactorRate(ItemStack stack, float rate) {
        CompoundTag tag = this.getModifiableData(stack);
        tag.m_128350_("move_spread_factor_rate", rate);
    }

    @Override
    public void setSprintingSpreadFactorRate(ItemStack stack, float rate) {
        CompoundTag tag = this.getModifiableData(stack);
        tag.m_128350_("sprinting_spread_factor_rate", rate);
    }

    @Override
    public GenericGun getGun() {
        return this;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return true;
    }

    @Override
    public boolean shouldHandleAiming(ItemStack stack) {
        return true;
    }

    @Override
    public boolean shootCreateBulletShell() {
        return true;
    }

    @Override
    public boolean isSniper() {
        return this.properties.isSniper;
    }

    @Override
    public int getInnerVersion(ItemStack stack) {
        CompoundTag tag = this.checkAndGet(stack);
        return tag.m_128441_("inner_version") ? tag.m_128451_("inner_version") : -1;
    }

    @Override
    public void setInnerVersion(ItemStack stack, int version) {
        CompoundTag nbt = this.checkAndGet(stack);
        nbt.m_128405_("inner_version", version);
    }

    @Override
    public boolean preReload(ItemStack stack, LivingEntity entity, boolean mainHand) {
        boolean allow = false;
        if (this.ammoSelector != null) {
            int exceptedReloadCount = GenericAmmo.preReload(this.ammoSelector, this, (Player)entity);
            boolean bl = allow = exceptedReloadCount > 0;
            if (allow) {
                allow = ReloadingHandler.INSTANCE.setTask(this.getReloadTask(stack, mainHand));
                if (mainHand) {
                    ReloadingHandler.INSTANCE.setExceptedReloadCountMain(exceptedReloadCount);
                } else {
                    ReloadingHandler.INSTANCE.setExceptedReloadCountOff(exceptedReloadCount);
                }
            }
        }
        return allow;
    }

    @Override
    public IReloadingTask getReloadTask(ItemStack stack, boolean mainHand) {
        return new ReloadingHandler.GenericReloadTask(stack, this.getReloadLength(stack), mainHand, this.getAmmoLeft(stack) == 0);
    }

    @Override
    public int getFullReloadLength(ItemStack stack) {
        return this.properties.fullReloadLength;
    }

    @Override
    public int getBaseReloadLength(ItemStack stack) {
        return this.properties.reloadLength;
    }

    @Override
    public CompoundTag getModifiableData(ItemStack stack) {
        CompoundTag tag = this.checkAndGet(stack);
        return tag.m_128469_("attachment_modifiable_data");
    }

    @Override
    public void setModifiableData(ItemStack stack, CompoundTag modifiableData) {
        CompoundTag tag = this.checkAndGet(stack);
        tag.m_128365_("attachment_modifiable_data", (Tag)modifiableData);
    }

    @Override
    public void setFlashlightOn(ItemStack stack, boolean on) {
        CompoundTag tag = this.checkAndGet(stack);
        tag.m_128379_("flashlight_on", on);
    }

    @Override
    public boolean getFlashlightOn(ItemStack stack) {
        CompoundTag tag = this.checkAndGet(stack);
        return tag.m_128441_("flashlight_on") && tag.m_128471_("flashlight_on");
    }

    protected CompoundTag checkAndGet(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            this.m_7836_(stack, null, null);
            nbt = stack.m_41783_();
        }
        return nbt;
    }

    public void m_7836_(ItemStack stack, Level levelIn, Player playerIn) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        if (!nbt.m_128441_("inner_version")) {
            nbt.m_128405_("inner_version", 371);
        }
        if (!nbt.m_128441_("ammo_left")) {
            nbt.m_128405_("ammo_left", this.properties.baseMagSize);
        }
        if (!nbt.m_128441_("flashlight_on")) {
            nbt.m_128379_("flashlight_on", false);
        }
        if (!nbt.m_128441_("fire_mode")) {
            nbt.m_128405_("fire_mode", this.fireModes[0]);
        }
        nbt.m_128405_("reload_length", this.properties.reloadLength);
        nbt.m_128405_("full_reload_length", this.properties.fullReloadLength);
        stack.m_41751_(nbt);
        if (this.attachmentsMapGenerator != null && !this.attachmentsMapGenerator.isPresent(stack)) {
            this.attachmentsMapGenerator.gen(stack);
            AttachmentsHandler.INSTANCE.updateAttachmentModifiableData(stack, this, playerIn);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, levelIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.damage").m_130946_(" " + this.properties.projectileData.getBaseDamage(this)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.max_spread").m_130946_(" " + this.getMaxSpread(stack)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.min_spread").m_130946_(" " + this.getMinSpread(stack)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.speed").m_130946_(" " + this.properties.projectileData.getSpeed(this)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.reload_len").m_130946_(" " + (float)this.getBaseReloadLength(stack) / 20.0f + " / " + (float)this.getFullReloadLength(stack) / 20.0f + " s"));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.recoil").m_130946_(" " + this.getRecoilUp(stack)));
        tooltip.add((Component)Component.m_237119_().m_130946_(Component.m_237115_((String)"tooltip.gunscraft.ammo_price").getString().replace("$", "" + this.getAmmoPrice())));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.ammo_use").m_130946_(" " + Component.m_237115_((String)this.ammoSelector.getAmmo().m_5524_()).getString()));
        tooltip.add((Component)Component.m_237119_().m_130946_(Component.m_237115_((String)"tooltip.gunscraft.effective_range").getString().replace("$", "" + this.properties.projectileData.getEffectiveRange(this))));
    }

    static {
        FIRE_MODE_NAME_MAP.put(0, Component.m_237115_((String)"screen_info.gunscraft.semi"));
        FIRE_MODE_NAME_MAP.put(1, Component.m_237115_((String)"screen_info.gunscraft.burst"));
        FIRE_MODE_NAME_MAP.put(2, Component.m_237115_((String)"screen_info.gunscraft.auto"));
        FIRE_MODE_NAME_MAP.put(3, Component.m_237115_((String)"screen_info.gunscraft.hand_action"));
        FIRE_MODE_NAME_MAP.put(4, Component.m_237115_((String)"screen_info.gunscraft.volley"));
    }
}

