/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.guns;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.config.CommonConfig;
import sheridan.gunscraft.data.GunProperties;
import sheridan.gunscraft.items.guns.GenericGun;
import sheridan.gunscraft.items.guns.PumpActionShotGun;

public class MagShotGun
extends GenericGun {
    public int bulletPreShot;
    public float gunSpread;

    public MagShotGun(Item.Properties properties, boolean canHoldInOneHand, int[] fireModes, String normalFireSound, String normalReloadSound, int chamberCount, String seriesName, String bulletType, String type, ResourceLocation[] textures, int bulletPreShot, float gunSpread, GunProperties gunProperties) {
        super(properties, canHoldInOneHand, fireModes, normalFireSound, normalReloadSound, chamberCount, seriesName, bulletType, type, textures, gunProperties);
        this.bulletPreShot = bulletPreShot;
        this.gunSpread = gunSpread;
    }

    @Override
    public void shoot(ItemStack stack, LivingEntity entity, boolean mainHand, float spread) {
        int ammoLeft = this.getAmmoLeft(stack);
        if (ammoLeft > 0 && entity instanceof Player) {
            boolean useAmmo;
            Player player = (Player)entity;
            long now = System.currentTimeMillis();
            player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                if (mainHand) {
                    cap.lastShootRight = now;
                } else {
                    cap.lastShootLeft = now;
                }
                cap.dataChanged = true;
            });
            boolean bl = useAmmo = !player.m_7500_() || CommonConfig.getCreativeModeUseAmmo();
            if (useAmmo) {
                this.setAmmoLeft(stack, ammoLeft - 1);
            }
            if (!entity.m_9236_().m_5776_() && this.properties.projectileData != null) {
                PumpActionShotGun.shotGunShoot(8, 1, spread, this.gunSpread, entity, this.properties.projectileData, this);
            }
        }
    }
}

