/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.guns;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.config.CommonConfig;
import sheridan.gunscraft.data.GunProperties;
import sheridan.gunscraft.entities.projectile.GenericProjectile;
import sheridan.gunscraft.events.IReloadingTask;
import sheridan.gunscraft.events.ReloadingHandler;
import sheridan.gunscraft.items.ammos.GenericAmmo;
import sheridan.gunscraft.items.guns.BoltActionGun;
import sheridan.gunscraft.items.guns.IBreakableReloading;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.items.guns.utils.ChamberTaskHandler;
import sheridan.gunscraft.items.guns.utils.ProjectileData;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.ShotGunReloadPacket;
import sheridan.gunscraft.sounds.SoundEvents;

public class PumpActionShotGun
extends BoltActionGun {
    public int bulletPreShot;
    public float gunSpread;
    public String bulletInsertSound;
    public int insertBulletSoundDelay;
    public int enterReloadDelay;

    public PumpActionShotGun(Item.Properties properties, int[] fireModes, String normalFireSound, String normalReloadSound, int chamberCount, String seriesName, String bulletType, String type, ResourceLocation[] textures, int chamberActionStartDuration, int chamberActionDelay, int chamberBulletShellThrowDelay, long shotBreakAimingDelay, String chamberSound, int bulletPreShot, float gunSpread, String bulletInsertSound, int insertBulletSoundDelay, int enterReloadDelay, GunProperties gunProperties) {
        super(properties, fireModes, normalFireSound, normalReloadSound, chamberCount, seriesName, bulletType, type, textures, chamberActionStartDuration, chamberActionDelay, chamberBulletShellThrowDelay, shotBreakAimingDelay, chamberSound, gunProperties);
        this.bulletPreShot = bulletPreShot;
        this.gunSpread = gunSpread;
        this.bulletInsertSound = bulletInsertSound;
        this.insertBulletSoundDelay = insertBulletSoundDelay;
        this.enterReloadDelay = enterReloadDelay;
    }

    @Override
    public void shoot(ItemStack stack, LivingEntity entity, boolean mainHand, float spread) {
        int ammoLeft = this.getAmmoLeft(stack);
        if (ammoLeft > 0) {
            this.setNeedChamber(stack, true);
        }
        if (ammoLeft > 0 && entity instanceof Player) {
            boolean useAmmo;
            Player player = (Player)entity;
            long now = System.currentTimeMillis();
            player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                if (mainHand) {
                    cap.lastShootRight = now;
                } else {
                    cap.lastShootLeft = now;
                }
                cap.dataChanged = true;
            });
            boolean bl = useAmmo = !player.m_7500_() || CommonConfig.getCreativeModeUseAmmo();
            if (useAmmo) {
                this.setAmmoLeft(stack, ammoLeft - 1);
            }
            if (!entity.m_9236_().m_5776_() && this.properties.projectileData != null) {
                PumpActionShotGun.shotGunShoot(this.bulletPreShot, 1, spread, this.gunSpread, entity, this.properties.projectileData, this);
            }
        }
    }

    @Override
    public boolean preReload(ItemStack stack, LivingEntity entity, boolean mainHand) {
        if (ReloadingHandler.INSTANCE.isReloading() || ReloadingHandler.INSTANCE.getGenericReloadFlag()) {
            return false;
        }
        boolean allow = super.preReload(stack, entity, mainHand);
        if (allow) {
            ChamberTaskHandler.INSTANCE.clear();
        }
        return allow;
    }

    public static void shotGunShoot(int count, int shootCount, float spread, float baseSpread, LivingEntity entity, ProjectileData projectileData, IGenericGun gun) {
        Vec3 aimRay = entity.m_20154_();
        float aimRaySpread = spread * 0.00812345f;
        Vec3 shootRay = new Vec3(aimRay.f_82479_, aimRay.f_82480_, aimRay.f_82481_).m_82541_().m_82520_(GenericProjectile.RANDOM.nextGaussian() * (double)aimRaySpread, GenericProjectile.RANDOM.nextGaussian() * (double)aimRaySpread, GenericProjectile.RANDOM.nextGaussian() * (double)aimRaySpread);
        for (int j = 0; j < shootCount; ++j) {
            for (int i = 0; i < count; ++i) {
                projectileData.spawnProjectile((Player)entity, shootRay, baseSpread, gun);
            }
        }
    }

    @Override
    public boolean preShoot(ItemStack stack, LivingEntity entity, boolean mainHand) {
        boolean allow = super.preShoot(stack, entity, mainHand);
        if (this.getAmmoLeft(stack) > 0) {
            ReloadingHandler.INSTANCE.breakTask(mainHand);
        }
        return allow;
    }

    @Override
    public IReloadingTask getReloadTask(ItemStack stack, boolean mainHand) {
        return new ReloadingTask(stack, this.properties.reloadLength, this.enterReloadDelay, this.getMagSize(stack) - this.getAmmoLeft(stack), mainHand, this.bulletInsertSound, this.insertBulletSoundDelay, this);
    }

    @Override
    public void reload(ItemStack stack, LivingEntity entity, boolean mainHand) {
        if (this.ammoSelector != null) {
            GenericAmmo.onSingleReload(this.ammoSelector, (Player)entity, stack, this);
        }
    }

    @Override
    public boolean shouldHandleWhileReloading(ItemStack stack) {
        return true;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.damage").m_130946_(" " + this.properties.projectileData.getBaseDamage(this) + " x " + this.bulletPreShot));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.max_spread").m_130946_(" " + this.getMaxSpread(stack)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.min_spread").m_130946_(" " + this.getMinSpread(stack)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.speed").m_130946_(" " + this.properties.projectileData.getSpeed(this)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.reload_len").m_130946_(" " + (float)this.getBaseReloadLength(stack) / 20.0f + " x N s"));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.recoil").m_130946_(" " + this.getRecoilUp(stack)));
        tooltip.add((Component)Component.m_237119_().m_130946_(Component.m_237115_((String)"tooltip.gunscraft.ammo_price").getString().replace("$", "" + this.getAmmoPrice())));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.ammo_use").m_130946_(" " + Component.m_237115_((String)this.ammoSelector.getAmmo().m_5524_()).getString()));
        tooltip.add((Component)Component.m_237119_().m_130946_(Component.m_237115_((String)"tooltip.gunscraft.effective_range").getString().replace("$", "" + this.properties.projectileData.getEffectiveRange(this))));
    }

    public static class ReloadingTask
    implements IReloadingTask,
    IBreakableReloading {
        public ItemStack stack;
        public int tick = 0;
        public boolean mainHand;
        public boolean completed;
        public int singleReloadLength;
        public int enterReloadDelay;
        public int reloadCount;
        public int reloadedCount = 0;
        public String bulletInsertSound;
        public int insertBulletSoundDelay;
        public PumpActionShotGun gun;
        boolean firstTick = true;
        int endTime;

        public ReloadingTask(ItemStack stack, int singleReloadLength, int enterReloadDelay, int reloadCount, boolean mainHand, String bulletInsertSound, int insertBulletSoundDelay, PumpActionShotGun gun) {
            this.stack = stack;
            this.mainHand = mainHand;
            this.singleReloadLength = singleReloadLength;
            this.enterReloadDelay = enterReloadDelay;
            this.reloadCount = reloadCount;
            this.bulletInsertSound = bulletInsertSound;
            this.insertBulletSoundDelay = insertBulletSoundDelay;
            this.gun = gun;
            this.endTime = enterReloadDelay + reloadCount * singleReloadLength;
        }

        @Override
        public boolean isCompleted() {
            return this.completed;
        }

        @Override
        public void tick(Player clientPlayer, int point) {
            ItemStack heldStack;
            ItemStack itemStack = heldStack = this.mainHand ? clientPlayer.m_21205_() : clientPlayer.m_21206_();
            if (ItemStack.m_41656_((ItemStack)heldStack, (ItemStack)this.stack)) {
                this.tick += point;
                Clients.mainHandStatus.aiming.set(false);
            } else {
                this.completed = true;
                PacketHandler.simpleChannel.sendToServer((Object)new ShotGunReloadPacket(this.mainHand, true, false, false));
            }
            if (this.firstTick) {
                PacketHandler.simpleChannel.sendToServer((Object)new ShotGunReloadPacket(this.mainHand, false, true, false));
                this.firstTick = false;
                Clients.mainHandStatus.dryFired = false;
            }
            if (this.tick == this.enterReloadDelay + (this.reloadedCount + 1) * this.singleReloadLength - this.insertBulletSoundDelay) {
                PacketHandler.simpleChannel.sendToServer((Object)new ShotGunReloadPacket(this.mainHand, false, false, true));
                this.gun.reload(this.stack, (LivingEntity)clientPlayer, this.mainHand);
                ++this.reloadedCount;
                SoundEvents.playSound(this.bulletInsertSound, (LivingEntity)clientPlayer, 1.0f, 1.0f);
            }
            if (this.reloadedCount >= this.reloadCount && this.tick >= this.endTime) {
                this.completed = true;
                PacketHandler.simpleChannel.sendToServer((Object)new ShotGunReloadPacket(this.mainHand, true, false, false));
                if (this.gun.getNeedChamber(this.stack)) {
                    BoltActionGun.ChamberTask task = this.gun.getChamberTask(true, this.stack);
                    task.restrictNBT = false;
                    ChamberTaskHandler.INSTANCE.setChamberTask(task);
                }
            }
        }

        @Override
        public void end() {
            this.reloadedCount = this.reloadCount;
            this.tick = this.endTime;
        }

        @Override
        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        public boolean isMainHand() {
            return this.mainHand;
        }

        @Override
        public int getCustomStatus() {
            return 0;
        }
    }
}

