/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.guns;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.config.CommonConfig;
import sheridan.gunscraft.data.GunProperties;
import sheridan.gunscraft.entities.projectile.GenericProjectile;
import sheridan.gunscraft.events.IReloadingTask;
import sheridan.gunscraft.events.ReloadingHandler;
import sheridan.gunscraft.items.ammos.GenericAmmo;
import sheridan.gunscraft.items.guns.GenericGun;
import sheridan.gunscraft.items.guns.IBreakableReloading;
import sheridan.gunscraft.items.guns.IChamberStatus;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.items.guns.utils.ChamberTaskHandler;
import sheridan.gunscraft.items.guns.utils.ProjectileData;
import sheridan.gunscraft.network.PacketHandler;
import sheridan.gunscraft.network.packets.ShotGunReloadPacket;

public class RegularShotGun
extends GenericGun
implements IChamberStatus {
    public int bulletPreShot;
    public float gunSpread;
    public String bulletInsertSound;
    public int insertBulletSoundDelay;
    public int firstReloadLength;
    public int enterReloadLength;

    public RegularShotGun(Item.Properties properties, boolean canHoldInOneHand, int[] fireModes, String normalFireSound, String normalReloadSound, int chamberCount, String seriesName, String bulletType, String type, ResourceLocation[] textures, int bulletPreShot, float gunSpread, String bulletInsertSound, int insertBulletSoundDelay, int firstReloadLength, int enterReloadLength, GunProperties gunProperties) {
        super(properties, canHoldInOneHand, fireModes, normalFireSound, normalReloadSound, chamberCount, seriesName, bulletType, type, textures, gunProperties);
        this.bulletInsertSound = bulletInsertSound;
        this.gunSpread = gunSpread;
        this.bulletPreShot = bulletPreShot;
        this.insertBulletSoundDelay = insertBulletSoundDelay;
        this.enterReloadLength = enterReloadLength;
        this.firstReloadLength = firstReloadLength;
    }

    @Override
    public void shoot(ItemStack stack, LivingEntity entity, boolean mainHand, float spread) {
        int ammoLeft = this.getAmmoLeft(stack);
        if (ammoLeft > 0 && entity instanceof Player) {
            boolean useAmmo;
            Player player = (Player)entity;
            long now = System.currentTimeMillis();
            player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                if (mainHand) {
                    cap.lastShootRight = now;
                } else {
                    cap.lastShootLeft = now;
                }
                cap.dataChanged = true;
            });
            boolean bl = useAmmo = !player.m_7500_() || CommonConfig.getCreativeModeUseAmmo();
            if (useAmmo) {
                this.setAmmoLeft(stack, ammoLeft - 1);
            }
            if (!entity.m_9236_().m_5776_() && this.properties.projectileData != null) {
                RegularShotGun.shotGunShoot(this.bulletPreShot, 1, spread, this.gunSpread, entity, this.properties.projectileData, this);
            }
        }
    }

    @Override
    public boolean preReload(ItemStack stack, LivingEntity entity, boolean mainHand) {
        if (ReloadingHandler.INSTANCE.isReloading() || ReloadingHandler.INSTANCE.getGenericReloadFlag()) {
            return false;
        }
        boolean allow = super.preReload(stack, entity, mainHand);
        if (allow) {
            ChamberTaskHandler.INSTANCE.clear();
        }
        return allow;
    }

    public static void shotGunShoot(int count, int shootCount, float spread, float baseSpread, LivingEntity entity, ProjectileData projectileData, IGenericGun gun) {
        Vec3 aimRay = entity.m_20154_();
        float aimRaySpread = spread * 0.00812345f;
        Vec3 shootRay = new Vec3(aimRay.f_82479_, aimRay.f_82480_, aimRay.f_82481_).m_82541_().m_82520_(GenericProjectile.RANDOM.nextGaussian() * (double)aimRaySpread, GenericProjectile.RANDOM.nextGaussian() * (double)aimRaySpread, GenericProjectile.RANDOM.nextGaussian() * (double)aimRaySpread);
        for (int j = 0; j < shootCount; ++j) {
            for (int i = 0; i < count; ++i) {
                projectileData.spawnProjectile((Player)entity, shootRay, baseSpread, gun);
            }
        }
    }

    @Override
    public boolean preShoot(ItemStack stack, LivingEntity entity, boolean mainHand) {
        boolean allow = super.preShoot(stack, entity, mainHand);
        if (this.getAmmoLeft(stack) > 0) {
            ReloadingHandler.INSTANCE.breakTask(mainHand);
        }
        return allow;
    }

    @Override
    public IReloadingTask getReloadTask(ItemStack stack, boolean mainHand) {
        return new ReloadingTask(stack, this.properties.reloadLength, this.properties.fullReloadLength, this.enterReloadLength, this.getMagSize(stack) - this.getAmmoLeft(stack), mainHand, this.bulletInsertSound, this.insertBulletSoundDelay, this);
    }

    @Override
    public void reload(ItemStack stack, LivingEntity entity, boolean mainHand) {
        if (this.ammoSelector != null) {
            GenericAmmo.onSingleReload(this.ammoSelector, (Player)entity, stack, this);
        }
    }

    @Override
    public boolean shouldHandleWhileReloading(ItemStack stack) {
        return true;
    }

    @Override
    public boolean active(ItemStack stack) {
        return this.getNeedChamber(stack);
    }

    @Override
    public boolean getNeedChamber(ItemStack stack) {
        return this.getAmmoLeft(stack) == 0;
    }

    public void handleClientReload(ReloadingTask task, Player player) {
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.damage").m_130946_(" " + this.properties.projectileData.getBaseDamage(this) + " x " + this.bulletPreShot));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.max_spread").m_130946_(" " + this.getMaxSpread(stack)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.min_spread").m_130946_(" " + this.getMinSpread(stack)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.speed").m_130946_(" " + this.properties.projectileData.getSpeed(this)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.reload_len").m_130946_(" " + (float)this.getBaseReloadLength(stack) / 20.0f + " x N s"));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.recoil").m_130946_(" " + this.getRecoilUp(stack)));
        tooltip.add((Component)Component.m_237119_().m_130946_(Component.m_237115_((String)"tooltip.gunscraft.ammo_price").getString().replace("$", "" + this.getAmmoPrice())));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.ammo_use").m_130946_(" " + Component.m_237115_((String)this.ammoSelector.getAmmo().m_5524_()).getString()));
        tooltip.add((Component)Component.m_237119_().m_130946_(Component.m_237115_((String)"tooltip.gunscraft.effective_range").getString().replace("$", "" + this.properties.projectileData.getEffectiveRange(this))));
    }

    public static class ReloadingTask
    implements IReloadingTask,
    IBreakableReloading {
        public ItemStack stack;
        public int tick;
        public boolean mainHand;
        public boolean completed;
        public int singleReloadLength;
        public int enterReloadDelay;
        public int reloadCount;
        public int reloadedCount;
        public String bulletInsertSound;
        public int insertBulletSoundDelay;
        public RegularShotGun gun;
        boolean firstTick;
        int endTime;
        int mark;

        public ReloadingTask(ItemStack stack, int singleReloadLength, int firstReloadLength, int enterReloadDelay, int reloadCount, boolean mainHand, String bulletInsertSound, int insertBulletSoundDelay, RegularShotGun gun) {
            this.mark = gun.getNeedChamber(stack) ? 1 : 0;
            this.stack = stack;
            this.tick = 0;
            this.reloadedCount = 0;
            this.mainHand = mainHand;
            this.singleReloadLength = singleReloadLength;
            this.enterReloadDelay = enterReloadDelay;
            this.reloadCount = reloadCount;
            this.bulletInsertSound = bulletInsertSound;
            this.insertBulletSoundDelay = insertBulletSoundDelay;
            this.gun = gun;
            this.firstTick = true;
            this.endTime = enterReloadDelay + reloadCount * singleReloadLength;
            if (this.mark == 1) {
                this.endTime += firstReloadLength - singleReloadLength + 4;
            }
        }

        @Override
        public boolean isCompleted() {
            return this.completed;
        }

        @Override
        public void tick(Player clientPlayer, int point) {
            ItemStack heldStack;
            ItemStack itemStack = heldStack = this.mainHand ? clientPlayer.m_21205_() : clientPlayer.m_21206_();
            if (ItemStack.m_41656_((ItemStack)heldStack, (ItemStack)this.stack)) {
                this.tick += point;
                Clients.mainHandStatus.aiming.set(false);
            } else {
                this.completed = true;
                PacketHandler.simpleChannel.sendToServer((Object)new ShotGunReloadPacket(this.mainHand, true, false, false));
            }
            if (this.firstTick) {
                PacketHandler.simpleChannel.sendToServer((Object)new ShotGunReloadPacket(this.mainHand, false, true, false));
                this.firstTick = false;
                Clients.mainHandStatus.dryFired = false;
            }
            this.gun.handleClientReload(this, clientPlayer);
            if (this.reloadedCount >= this.reloadCount && this.tick >= this.endTime) {
                this.completed = true;
                PacketHandler.simpleChannel.sendToServer((Object)new ShotGunReloadPacket(this.mainHand, true, false, false));
            }
        }

        public void reloadSingle() {
            PacketHandler.simpleChannel.sendToServer((Object)new ShotGunReloadPacket(this.mainHand, false, false, true));
            ++this.reloadedCount;
        }

        @Override
        public void end() {
            this.reloadedCount = this.reloadCount;
            this.tick = this.endTime;
        }

        @Override
        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        public boolean isMainHand() {
            return this.mainHand;
        }

        @Override
        public int getCustomStatus() {
            return this.mark;
        }
    }
}

