/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.guns.regular;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.config.CommonConfig;
import sheridan.gunscraft.data.GunProperties;
import sheridan.gunscraft.items.guns.MagShotGun;
import sheridan.gunscraft.items.guns.PumpActionShotGun;

public class Beretta686
extends MagShotGun {
    public Beretta686() {
        super(new Item.Properties().m_41487_(1), false, new int[]{0, 4}, "item.beretta_686.fire", "item.m870.reload", 2, "beretta_686", "shotgun", "shotgun", new ResourceLocation[]{new ResourceLocation("gunscraft", "textures/guns/beretta_686/beretta_686_basic.png")}, 8, 1.4f, new GunProperties().setBaseMagSize(2).setBaseSpread(1.7f).setMaxSpread(2.7f).setSpreadPreShoot(1.4f).setShootDelay(10).setReloadLength(64).setFullReloadLength(64).setAdsSpeed(4.5f).setRecoilUp(6.5f).setRecoilRandom(1.0f).setRecoilDec(3.0f).setAmmoPrice(5).setFireSoundVol(4.5f));
    }

    @Override
    public boolean shootCreateBulletShell() {
        return false;
    }

    @Override
    public void reload(ItemStack stack, LivingEntity entity, boolean mainHand) {
        super.reload(stack, entity, mainHand);
        this.handleMuzzleFlashState(stack);
    }

    private void handleMuzzleFlashState(ItemStack stack) {
        int fireMode = this.getFireMode(stack);
        int ammoLeft = this.getAmmoLeft(stack);
        if (ammoLeft == 2) {
            if (fireMode == 4) {
                this.setMuzzleFlashState(stack, "volley");
            } else {
                this.setMuzzleFlashState(stack, "normal");
            }
        } else if (ammoLeft <= 1) {
            this.setMuzzleFlashState(stack, "normal_down");
        }
    }

    @Override
    public boolean preShoot(ItemStack stack, LivingEntity entity, boolean mainHand) {
        this.handleMuzzleFlashState(stack);
        return super.preShoot(stack, entity, mainHand);
    }

    @Override
    public void shoot(ItemStack stack, LivingEntity entity, boolean mainHand, float spread) {
        this.handleMuzzleFlashState(stack);
        int fireMode = this.getFireMode(stack);
        if (fireMode == 4) {
            int ammoLeft = this.getAmmoLeft(stack);
            int fireCount = Math.min(this.chamberCount, ammoLeft);
            if (ammoLeft > 0 && entity instanceof Player) {
                boolean useAmmo;
                Player player = (Player)entity;
                player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                    if (mainHand) {
                        cap.lastShootRight = System.currentTimeMillis();
                    } else {
                        cap.lastShootLeft = System.currentTimeMillis();
                    }
                    cap.dataChanged = true;
                });
                boolean bl = useAmmo = !player.m_7500_() || CommonConfig.getCreativeModeUseAmmo();
                if (useAmmo) {
                    this.setAmmoLeft(stack, ammoLeft - fireCount);
                }
                if (!entity.m_9236_().m_5776_() && this.properties.projectileData != null) {
                    PumpActionShotGun.shotGunShoot(8, fireCount, spread, this.gunSpread, entity, this.properties.projectileData, this);
                }
            }
            return;
        }
        super.shoot(stack, entity, mainHand, spread);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.damage").m_130946_(" " + this.properties.projectileData.getBaseDamage(this) + " x " + this.bulletPreShot));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.max_spread").m_130946_(" " + this.getMaxSpread(stack)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.min_spread").m_130946_(" " + this.getMinSpread(stack)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.speed").m_130946_(" " + this.properties.projectileData.getSpeed(this)));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.reload_len").m_130946_(" " + (float)this.getBaseReloadLength(stack) / 20.0f + " s"));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.recoil").m_130946_(" " + this.getRecoilUp(stack)));
        tooltip.add((Component)Component.m_237119_().m_130946_(Component.m_237115_((String)"tooltip.gunscraft.ammo_price").getString().replace("$", "" + this.getAmmoPrice())));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.gunscraft.ammo_use").m_130946_(" " + Component.m_237115_((String)this.ammoSelector.getAmmo().m_5524_()).getString()));
        tooltip.add((Component)Component.m_237119_().m_130946_(Component.m_237115_((String)"tooltip.gunscraft.effective_range").getString().replace("$", "" + this.properties.projectileData.getEffectiveRange(this))));
    }
}

