/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.items.guns.utils;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sheridan.gunscraft.entities.EntityRegister;
import sheridan.gunscraft.entities.projectile.GenericProjectile;
import sheridan.gunscraft.items.guns.IGenericGun;

public class ProjectileData {
    public float baseDamage;
    public float minDamage;
    public int projectileModelType;
    public float effectiveRange;
    public float speed;
    public int force;

    public ProjectileData(float baseDamage, float minDamage, int projectileModelType, float effectiveRange, float speed, int force) {
        this.baseDamage = baseDamage;
        this.minDamage = minDamage;
        this.projectileModelType = projectileModelType;
        this.effectiveRange = effectiveRange;
        this.speed = speed;
        this.force = force;
    }

    public ProjectileData() {
    }

    public float getBaseDamage(IGenericGun gun) {
        return this.baseDamage;
    }

    public float getEffectiveRange(IGenericGun gun) {
        return this.effectiveRange;
    }

    public float getSpeed(IGenericGun gun) {
        return this.speed;
    }

    public void spawnProjectile(Player entity, Vec3 aimRay, float spread, IGenericGun gun) {
        Level level = entity.m_9236_();
        float damage = (float)((double)this.getBaseDamage(gun) * ((double)Math.round((Math.random() - 0.5) * 20.0) * 0.01 + 1.0));
        GenericProjectile projectile = new GenericProjectile((EntityType<? extends GenericProjectile>)((EntityType)EntityRegister.GENERIC_PROJECTILE.get()), level, (LivingEntity)entity, aimRay, this.getSpeed(gun), spread, damage, this.minDamage, this.projectileModelType, this.getEffectiveRange(gun) * 16.0f, this.force, gun);
        level.m_7967_((Entity)projectile);
    }

    public void handleJsonObj(JsonObject jsonObject) {
        jsonObject.addProperty("baseDamage", (Number)Float.valueOf(this.baseDamage));
        jsonObject.addProperty("minDamage", (Number)Float.valueOf(this.minDamage));
        jsonObject.addProperty("projectileModelType", (Number)this.projectileModelType);
        jsonObject.addProperty("effectiveRange", (Number)Float.valueOf(this.effectiveRange));
        jsonObject.addProperty("speed", (Number)Float.valueOf(this.speed));
        jsonObject.addProperty("force", (Number)this.force);
    }

    public void readFromNBT(CompoundTag tag) {
        this.baseDamage = tag.m_128457_("baseDamage");
        this.minDamage = tag.m_128457_("minDamage");
        this.projectileModelType = tag.m_128451_("projectileModelType");
        this.effectiveRange = tag.m_128457_("effectiveRange");
        this.speed = tag.m_128457_("speed");
        this.force = tag.m_128451_("force");
    }

    public CompoundTag getNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("baseDamage", this.baseDamage);
        tag.m_128350_("minDamage", this.minDamage);
        tag.m_128405_("projectileModelType", this.projectileModelType);
        tag.m_128350_("effectiveRange", this.effectiveRange);
        tag.m_128350_("speed", this.speed);
        tag.m_128405_("force", this.force);
        return tag;
    }
}

