/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.render.utils.Quaternions;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    private int tempIndex = 2;
    private boolean finished = true;
    private long lastHandle = 0L;

    @Accessor(value="zoom")
    abstract float getZoom();

    @Accessor(value="zoomX")
    abstract float getZoomX();

    @Accessor(value="zoomY")
    abstract float getZoomY();

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void onTick(CallbackInfo ci) {
        Clients.zoom = this.getZoom();
        Clients.zoomX = this.getZoomX();
        Clients.zoomY = this.getZoomY();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(at={@At(value="HEAD")}, method={"bobView"}, cancellable=true)
    private void resetViewBobbingRenderingHand(PoseStack poseStackIn, float partialTicks, CallbackInfo ci) {
        if (Clients.isInFirstPersonGunView) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            if (Clients.mainHandStatus.aiming.get()) {
                this.handleShake(poseStackIn);
            }
        }
    }

    private void handleShake(PoseStack poseStackIn) {
        if (Clients.mainHandStatus.aiming.get()) {
            long timeDis;
            long lastShoot = Clients.mainHandStatus.lastShoot;
            if (!this.finished) {
                if (this.lastHandle == 0L) {
                    this.lastHandle = lastShoot;
                }
                timeDis = System.currentTimeMillis() - this.lastHandle;
            } else {
                timeDis = System.currentTimeMillis() - lastShoot;
            }
            if (timeDis < 100L) {
                if (this.finished) {
                    this.finished = false;
                    this.lastHandle = System.currentTimeMillis();
                }
                float progress = (float)timeDis / 100.0f;
                if (this.tempIndex == 2) {
                    this.tempIndex = Math.random() > 0.5 ? 1 : -1;
                }
                float rz = (float)Math.sin((double)progress * Math.PI) * (float)this.tempIndex * 0.9f * Clients.cameraRecoilShakeAnimationScale;
                float rx = Math.abs(rz * 0.5f);
                float ry = rz * 0.3f;
                poseStackIn.m_252781_(Quaternions.rotateDeg(rx, ry, rz));
            } else {
                this.tempIndex = 2;
                this.finished = true;
            }
        }
    }
}

