/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.mixin;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.capability.PlayerStatus;
import sheridan.gunscraft.capability.PlayerStatusProvider;
import sheridan.gunscraft.events.ReloadingHandler;
import sheridan.gunscraft.items.guns.IGenericGun;

@Mixin(value={HumanoidModel.class})
public class HumanoidModelMixin {
    @Inject(at={@At(value="HEAD")}, method={"poseLeftArm"})
    public void leftArmPose(LivingEntity p_102879_, CallbackInfo ci) {
        if (p_102879_ instanceof Player) {
            Player player = (Player)p_102879_;
            if (player.m_19879_() == Clients.clientPlayerId) {
                if (ReloadingHandler.INSTANCE.isReloading()) {
                    ((HumanoidModel)this).f_102816_ = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                }
            } else {
                player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                    if (cap.reloading) {
                        ((HumanoidModel)this).f_102816_ = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                    }
                });
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"poseRightArm"})
    public void rightArmPose(LivingEntity p_102879_, CallbackInfo ci) {
        if (p_102879_ instanceof Player) {
            Player player = (Player)p_102879_;
            if (player.m_19879_() == Clients.clientPlayerId) {
                if (ReloadingHandler.INSTANCE.isReloading()) {
                    ((HumanoidModel)this).f_102815_ = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                }
            } else {
                player.getCapability(PlayerStatusProvider.CAPABILITY).ifPresent(cap -> {
                    if (cap.reloading) {
                        ((HumanoidModel)this).f_102815_ = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                    }
                });
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setupAnim*"})
    public void setUpAngles(LivingEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        Player player;
        if (entityIn instanceof Player && !(player = (Player)entityIn).m_6069_()) {
            boolean changePose;
            boolean isClientPlayer;
            Item itemMain = player.m_21205_().m_41720_();
            Item itemOff = player.m_21206_().m_41720_();
            boolean holdGunMain = itemMain instanceof IGenericGun;
            boolean holdGunOff = itemOff instanceof IGenericGun;
            IGenericGun gunMain = holdGunMain ? (IGenericGun)itemMain : null;
            IGenericGun gunOff = holdGunOff ? (IGenericGun)itemOff : null;
            boolean bl = isClientPlayer = entityIn.m_19879_() == Clients.clientPlayerId;
            if (isClientPlayer) {
                changePose = !ReloadingHandler.INSTANCE.isReloading();
            } else {
                PlayerStatus status = PlayerStatusProvider.getStatus(player);
                boolean bl2 = changePose = status != PlayerStatus.EMPTY && !status.reloading;
            }
            if (changePose) {
                ModelPart rightArm = ((HumanoidModel)this).f_102811_;
                ModelPart leftArm = ((HumanoidModel)this).f_102812_;
                ModelPart head = ((HumanoidModel)this).f_102808_;
                if (holdGunMain && holdGunOff) {
                    if (gunMain.canHoldInOneHand() && gunOff.canHoldInOneHand()) {
                        rightArm.f_104204_ = -0.1f + head.f_104204_;
                        leftArm.f_104204_ = 0.1f + head.f_104204_;
                        rightArm.f_104203_ = -1.5707964f + head.f_104203_;
                        leftArm.f_104203_ = -1.5707964f + head.f_104203_;
                    } else {
                        rightArm.f_104204_ = -0.1f + head.f_104204_;
                        rightArm.f_104203_ = -1.5707964f + head.f_104203_;
                        leftArm.f_104204_ = 0.1f + head.f_104204_ + 0.675f;
                        leftArm.f_104203_ = -1.5707964f + head.f_104203_;
                    }
                } else if (holdGunMain) {
                    rightArm.f_104204_ = -0.1f + head.f_104204_;
                    rightArm.f_104203_ = -1.5707964f + head.f_104203_;
                    leftArm.f_104204_ = 0.1f + head.f_104204_ + 0.675f;
                    leftArm.f_104203_ = -1.5707964f + head.f_104203_;
                } else if (holdGunOff && gunOff.canHoldInOneHand()) {
                    leftArm.f_104204_ = 0.1f + head.f_104204_;
                    leftArm.f_104203_ = -1.5707964f + head.f_104203_;
                }
            }
        }
    }
}

