/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.config.ClientConfig;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.model.IGunModelRenderer;
import sheridan.gunscraft.render.GunRenderer;
import sheridan.gunscraft.render.TransformData;

@Mixin(value={ItemRenderer.class})
public class RenderItemMixin {
    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    public void renderItem(ItemStack itemStackIn, ItemDisplayContext transformTypeIn, boolean p_115146_, PoseStack poseStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BakedModel p_115151_, CallbackInfo ci) {
        if (itemStackIn != null && itemStackIn.m_41720_() instanceof IGenericGun) {
            TransformData data;
            if (transformTypeIn == ItemDisplayContext.GUI && ClientConfig.getRenderVanillaModelGui()) {
                return;
            }
            if (transformTypeIn == ItemDisplayContext.GROUND && ClientConfig.getRenderVanillaModelGround()) {
                return;
            }
            IGunModelRenderer model = Clients.gunModelMap.get(itemStackIn.m_41720_());
            if (model != null && (data = Clients.transformDataMap.get(itemStackIn.m_41720_())) != null) {
                GunRenderer.INSTANCE.justRenderModel(itemStackIn, transformTypeIn, poseStackIn, bufferIn, combinedLightIn, combinedOverlayIn, (IGenericGun)itemStackIn.m_41720_(), model, data);
                ci.cancel();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderStatic(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/level/Level;III)V"}, cancellable=true)
    public void renderItemHeld(LivingEntity livingEntityIn, ItemStack itemStackIn, ItemDisplayContext transformTypeIn, boolean leftHand, PoseStack poseStackIn, MultiBufferSource bufferIn, Level p_174249_, int combinedLightIn, int combinedOverlayIn, int p_174252_, CallbackInfo ci) {
        if (livingEntityIn instanceof Player) {
            TransformData data;
            IGunModelRenderer model;
            boolean isGun;
            boolean bl = isGun = itemStackIn != null && itemStackIn.m_41720_() instanceof IGenericGun;
            if (isGun && (model = Clients.gunModelMap.get(itemStackIn.m_41720_())) != null && (data = Clients.transformDataMap.get(itemStackIn.m_41720_())) != null) {
                GunRenderer.INSTANCE.renderWithLivingEntity(livingEntityIn, poseStackIn, itemStackIn, transformTypeIn, bufferIn, (IGenericGun)itemStackIn.m_41720_(), combinedLightIn, combinedOverlayIn, leftHand, model, data);
                ci.cancel();
            }
        }
    }
}

