/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.model.attachments.grips;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentRenderEntry;
import sheridan.gunscraft.model.IAttachmentModel;
import sheridan.gunscraft.model.modelPartCopy.CubeDeformation;
import sheridan.gunscraft.model.modelPartCopy.CubeListBuilder;
import sheridan.gunscraft.model.modelPartCopy.LayerDefinition;
import sheridan.gunscraft.model.modelPartCopy.MeshDefinition;
import sheridan.gunscraft.model.modelPartCopy.ModelPart;
import sheridan.gunscraft.model.modelPartCopy.PartDefinition;
import sheridan.gunscraft.render.GunRenderContext;

@OnlyIn(value=Dist.CLIENT)
public class ModelGrip<T extends Entity>
extends EntityModel<T>
implements IAttachmentModel {
    private final ModelPart grip;
    List<ResourceLocation> textures;

    public ModelGrip(List<ResourceLocation> textures) {
        this(ModelGrip.createBodyLayer().bakeRoot());
        this.textures = textures;
    }

    public ModelGrip(ModelPart root) {
        this.grip = root.getChild("grip");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition grip = partdefinition.addOrReplaceChild("grip", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -2.0f, -7.0f, 10.0f, 5.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = grip.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 20).addBox(-4.5f, -4.0f, -2.5f, 7.0f, 25.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.4f, (float)10.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r2 = grip.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(28, 20).addBox(-2.5f, -3.0f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition cube_r3 = grip.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)0.4f, (float)6.9f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = grip.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(5, 3).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)0.5f, (float)-1.7f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition bone = grip.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create(meshdefinition, 64, 64);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    @Override
    public void render(GunRenderContext context, AttachmentRenderEntry attachmentRenderEntry) {
        this.grip.copyFrom(attachmentRenderEntry.translation);
        context.render(this.grip, context.getVertexConsumer(RenderType.m_110452_((ResourceLocation)this.textures.get(0))));
        this.grip.resetPose();
    }

    @Override
    public void render(GunRenderContext context, AttachmentRenderEntry attachmentRenderEntry, ModelPart posePart) {
        this.grip.copyFrom(posePart);
        context.render(this.grip, context.getVertexConsumer(RenderType.m_110452_((ResourceLocation)this.textures.get(0))));
        this.grip.resetPose();
    }
}

