/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.model.attachments.grips.laserSight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentRenderEntry;
import sheridan.gunscraft.model.IAttachmentModel;
import sheridan.gunscraft.model.attachments.grips.laserSight.ModelLaser;
import sheridan.gunscraft.model.modelPartCopy.CubeListBuilder;
import sheridan.gunscraft.model.modelPartCopy.LayerDefinition;
import sheridan.gunscraft.model.modelPartCopy.MeshDefinition;
import sheridan.gunscraft.model.modelPartCopy.ModelPart;
import sheridan.gunscraft.model.modelPartCopy.PartDefinition;
import sheridan.gunscraft.render.GunRenderContext;

public class ModelLaserSight<T extends Entity>
extends EntityModel<T>
implements IAttachmentModel {
    private final ModelPart pistol;
    public static final ModelLaser<?> LASER = new ModelLaser(ModelLaser.createBodyLayer().bakeRoot());
    private final ModelPart rifle;
    private final ModelPart pistol_laser_point;
    private final ModelPart rifle_laser_point;
    List<ResourceLocation> textures;

    public ModelLaserSight(List<ResourceLocation> textures) {
        this(ModelLaserSight.createBodyLayer().bakeRoot());
        this.textures = textures;
    }

    public ModelLaserSight(ModelPart root) {
        this.pistol = root.getChild("pistol");
        this.rifle = root.getChild("rifle");
        this.pistol_laser_point = this.pistol.getChild("laser_point2");
        this.rifle_laser_point = this.rifle.getChild("laser_point");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition pistol = partdefinition.addOrReplaceChild("pistol", CubeListBuilder.create().texOffs(102, 0).addBox(-2.5f, 1.2f, -4.0f, 5.0f, 5.0f, 10.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))).texOffs(72, 21).addBox(-3.5f, -0.8f, -4.0f, 7.0f, 2.0f, 8.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))).texOffs(10, 7).addBox(2.0f, 3.2f, 0.0f, 1.0f, 1.0f, 2.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.UP, Direction.NORTH, Direction.EAST))), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = pistol.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 7).addBox(-3.0f, 0.0f, -3.0f, 3.0f, 3.0f, 2.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.EAST))), PartPose.m_171423_((float)2.0f, (float)3.7f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition cube_r2 = pistol.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -1.0f, -3.0f, 4.0f, 4.0f, 3.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)2.0f, (float)4.4f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition laser_point2 = pistol.addOrReplaceChild("laser_point2", CubeListBuilder.create(), PartPose.m_171419_((float)0.0f, (float)3.7f, (float)-7.0f));
        PartDefinition rifle = partdefinition.addOrReplaceChild("rifle", CubeListBuilder.create().texOffs(68, 67).addBox(-5.0f, -3.0f, -8.0f, 10.0f, 4.0f, 16.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))).texOffs(100, 46).addBox(-3.0f, 1.0f, -8.0f, 6.0f, 4.0f, 16.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition cube_r3 = rifle.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(70, 38).addBox(0.0f, -1.0f, -1.0f, 1.0f, 1.0f, 28.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))), PartPose.m_171419_((float)-0.7f, (float)7.5f, (float)-15.0f));
        PartDefinition bone2 = rifle.addOrReplaceChild("bone2", CubeListBuilder.create().texOffs(100, 21).addBox(3.3301f, 2.5f, -20.0f, 1.0f, 5.0f, 20.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.NORTH, Direction.EAST))).texOffs(30, 98).addBox(-4.3301f, 2.5f, -20.0f, 1.0f, 5.0f, 20.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.NORTH))), PartPose.m_171419_((float)0.0f, (float)2.5f, (float)10.0f));
        PartDefinition cube_r4 = bone2.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(76, 87).addBox(0.0f, 0.0f, -1.0f, 5.0f, 1.0f, 20.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.UP, Direction.NORTH))), PartPose.m_171423_((float)-3.8301f, (float)6.634f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition cube_r5 = bone2.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(52, 103).addBox(-1.0f, 1.0f, -1.0f, 1.0f, 5.0f, 20.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)5.1962f, (float)7.0f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)1.0472f));
        PartDefinition cube_r6 = bone2.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(72, 0).addBox(-1.0f, 0.0f, -1.0f, 5.0f, 1.0f, 20.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.NORTH))), PartPose.m_171423_((float)-3.4641f, (float)2.0f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition cube_r7 = bone2.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 94).addBox(0.0f, 0.0f, -1.0f, 5.0f, 1.0f, 20.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.NORTH))), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition bone3 = rifle.addOrReplaceChild("bone3", CubeListBuilder.create().texOffs(34, 66).addBox(0.4641f, 2.0f, -20.0f, 3.0f, 4.0f, 28.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST))).texOffs(36, 34).addBox(-3.4641f, 2.0f, -20.0f, 3.0f, 4.0f, 28.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST))), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)3.0f));
        PartDefinition cube_r8 = bone3.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, -2.0f, -1.0f, 4.0f, 3.0f, 28.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.UP, Direction.NORTH))), PartPose.m_171423_((float)-3.8301f, (float)4.634f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition cube_r9 = bone3.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(0, 62).addBox(-3.0f, 2.0f, -1.0f, 3.0f, 4.0f, 28.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)5.1962f, (float)5.0f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)1.0472f));
        PartDefinition cube_r10 = bone3.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(0, 31).addBox(0.0f, 0.0f, -1.0f, 4.0f, 3.0f, 28.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.UP, Direction.NORTH))), PartPose.m_171423_((float)-3.4641f, (float)2.0f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition cube_r11 = bone3.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(36, 3).addBox(1.0f, 0.0f, -1.0f, 4.0f, 3.0f, 28.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.UP, Direction.NORTH))), PartPose.m_171423_((float)-0.866f, (float)-0.5f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition laser_point = rifle.addOrReplaceChild("laser_point", CubeListBuilder.create(), PartPose.m_171419_((float)0.0f, (float)7.5f, (float)-16.0f));
        return LayerDefinition.create(meshdefinition, 144, 144);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    private void renderLaser(PoseStack poseStack, boolean isPistol, GunRenderContext context) {
        poseStack.m_85836_();
        if (isPistol) {
            this.pistol.translateAndRotate(poseStack);
            LASER.render(poseStack, this.pistol_laser_point, 0xF000F0, 655360, context);
        } else {
            this.rifle.translateAndRotate(poseStack);
            LASER.render(poseStack, this.rifle_laser_point, 0xF000F0, 655360, context);
        }
        poseStack.m_85849_();
    }

    @Override
    public void render(GunRenderContext context, AttachmentRenderEntry attachmentRenderEntry) {
        PoseStack poseStack = context.poseStack;
        if (context.gun.isPistol()) {
            VertexConsumer vertexConsumer = context.getVertexConsumer(RenderType.m_110452_((ResourceLocation)this.textures.get(0)));
            this.pistol.copyFrom(attachmentRenderEntry.translation);
            context.render(this.pistol, vertexConsumer);
            this.renderLaser(context, poseStack, true);
            this.pistol.resetPose();
        } else {
            VertexConsumer vertexConsumer = context.getVertexConsumer(RenderType.m_110452_((ResourceLocation)this.textures.get(0)));
            this.rifle.copyFrom(attachmentRenderEntry.translation);
            context.render(this.rifle, vertexConsumer);
            this.renderLaser(context, poseStack, false);
            this.rifle.resetPose();
        }
    }

    private void renderLaser(GunRenderContext context, PoseStack poseStack, boolean isPistol) {
        if (context.transformType.m_269069_() || context.transformType == ItemDisplayContext.GROUND) {
            this.renderLaser(poseStack, isPistol, context);
        }
    }

    @Override
    public void render(GunRenderContext context, AttachmentRenderEntry attachmentRenderEntry, ModelPart posePart) {
        PoseStack poseStack = context.poseStack;
        if (context.gun.isPistol()) {
            VertexConsumer vertexConsumer = context.getVertexConsumer(RenderType.m_110452_((ResourceLocation)this.textures.get(0)));
            this.pistol.copyFrom(posePart);
            context.render(this.pistol, vertexConsumer);
            this.renderLaser(context, poseStack, true);
            this.pistol.resetPose();
        } else {
            VertexConsumer vertexConsumer = context.getVertexConsumer(RenderType.m_110452_((ResourceLocation)this.textures.get(0)));
            this.rifle.copyFrom(posePart);
            context.render(this.rifle, vertexConsumer);
            this.renderLaser(context, poseStack, false);
            this.rifle.resetPose();
        }
    }
}

