/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.model.attachments.muzzles.compensator;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentRenderEntry;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.model.IAttachmentModel;
import sheridan.gunscraft.model.modelPartCopy.CubeListBuilder;
import sheridan.gunscraft.model.modelPartCopy.LayerDefinition;
import sheridan.gunscraft.model.modelPartCopy.MeshDefinition;
import sheridan.gunscraft.model.modelPartCopy.ModelPart;
import sheridan.gunscraft.model.modelPartCopy.PartDefinition;
import sheridan.gunscraft.render.GunRenderContext;

public class ModelCompensator<T extends Entity>
extends EntityModel<T>
implements IAttachmentModel {
    private final ModelPart compensator_ak;
    private final ModelPart compensator_ar;
    private final ModelPart compensator_smg;
    public List<ResourceLocation> textures;

    public ModelCompensator(List<ResourceLocation> textures) {
        this(ModelCompensator.createBodyLayer().bakeRoot());
        this.textures = textures;
    }

    public ModelCompensator(ModelPart root) {
        this.compensator_ak = root.getChild("compensator_ak");
        this.compensator_ar = root.getChild("compensator_ar");
        this.compensator_smg = root.getChild("compensator_smg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition compensator_ak = partdefinition.addOrReplaceChild("compensator_ak", CubeListBuilder.create(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = compensator_ak.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(30, 36).addBox(1.0f, 1.0f, 0.0f, 5.0f, 5.0f, 8.0f, new HashSet<Direction>(Arrays.asList(Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)0.0f, (float)-4.8426f, (float)-20.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition cube_r2 = compensator_ak.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 6.0f, 6.0f, 17.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)0.0f, (float)-4.1426f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition compensator_ar = partdefinition.addOrReplaceChild("compensator_ar", CubeListBuilder.create(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = compensator_ar.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 23).addBox(0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 14.0f, new HashSet<Direction>(Arrays.asList(Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)0.0f, (float)-3.6f, (float)-19.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition cube_r4 = compensator_ar.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(24, 23).addBox(-1.0f, -1.0f, 0.0f, 6.0f, 6.0f, 7.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition compensator_smg = partdefinition.addOrReplaceChild("compensator_smg", CubeListBuilder.create(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = compensator_smg.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 6).addBox(1.0f, 1.0f, 0.0f, 3.0f, 3.0f, 2.0f, new HashSet<Direction>(Arrays.asList(Direction.DOWN, Direction.WEST, Direction.UP, Direction.EAST))), PartPose.m_171423_((float)0.0f, (float)-2.9f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition cube_r6 = compensator_smg.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(29, 0).addBox(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 9.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))).texOffs(0, 0).addBox(0.0f, 0.0f, 11.0f, 4.0f, 4.0f, 2.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)0.0f, (float)-2.2f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        return LayerDefinition.create(meshdefinition, 64, 64);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    @Override
    public void render(GunRenderContext context, AttachmentRenderEntry attachmentRenderEntry) {
        ModelPart part = this.compensator_ar;
        IGenericGun gun = context.gun;
        if (gun.getType().equals("ak")) {
            part = this.compensator_ak;
        } else if (gun.getType().equals("smg") || gun.getType().equals("pistol")) {
            part = this.compensator_smg;
        }
        if (part != null) {
            part.copyFrom(attachmentRenderEntry.translation);
            context.render(part, context.getVertexConsumer(RenderType.m_110458_((ResourceLocation)this.textures.get(0))));
            part.resetPose();
        }
    }

    @Override
    public void render(GunRenderContext context, AttachmentRenderEntry attachmentRenderEntry, ModelPart posePart) {
        ModelPart part = this.compensator_ar;
        IGenericGun gun = context.gun;
        if (gun.getType().equals("ak")) {
            part = this.compensator_ak;
        } else if (gun.getType().equals("smg") || gun.getType().equals("pistol")) {
            part = this.compensator_smg;
        }
        if (part != null) {
            part.copyFrom(posePart);
            context.render(part, context.getVertexConsumer(RenderType.m_110458_((ResourceLocation)this.textures.get(0))));
            part.resetPose();
        }
    }
}

