/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.model.attachments.scopes;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import sheridan.gunscraft.ClientGlobalWeaponTranslator;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.events.RenderEvents;
import sheridan.gunscraft.model.modelPartCopy.ModelPart;
import sheridan.gunscraft.render.GunRenderContext;
import sheridan.gunscraft.render.fx.RenderTypes;

public class SightViewRenderer {
    private static final ResourceLocation SCOPE_BACKGROUND = new ResourceLocation("gunscraft", "textures/fx/scope_background.png");
    private static final BufferBuilder STENCIL_VIEW_BUFFER = new BufferBuilder(0x100000);
    private static final ResourceLocation GENERIC_SCOPE = new ResourceLocation("gunscraft", "textures/fx/generic_scope.png");

    public static void handleFirstPersonScopeViewRender(GunRenderContext context, ModelPart glass_shape, ModelPart glass, ModelPart crosshair, ResourceLocation glassTexture, ResourceLocation crosshairTexture, ResourceLocation modelTexture, boolean glowingCrosshair, float crosshairScale, float backgroundScale, float backgroundZDepth, ModelPart ... body) {
        float aimingProgress = 0.0f;
        PoseStack poseStack = context.poseStack;
        if (context.mainHand && Clients.mainHandStatus.aiming.get()) {
            aimingProgress = Clients.mainHandStatus.getLerpAimingProgress();
        }
        if (RenderEvents.isStencilEnabled()) {
            if (aimingProgress > 0.75f) {
                SightViewRenderer.renderFirstPersonStencilScopeView(poseStack, glass_shape, crosshair, glassTexture, crosshairTexture, modelTexture, context.packedLight, context.packedOverlay, glowingCrosshair, crosshairScale, backgroundScale, backgroundZDepth, body);
            } else {
                SightViewRenderer.renderNormal(context, modelTexture, glass, body);
            }
        } else if (aimingProgress >= 1.0f) {
            SightViewRenderer.renderFirstPersonClassicScopeView(context, crosshair);
        } else {
            SightViewRenderer.renderNormal(context, modelTexture, glass, body);
        }
    }

    private static void renderNormal(GunRenderContext context, ResourceLocation modelTexture, ModelPart glass, ModelPart ... body) {
        VertexConsumer bodyCustomer = context.getVertexConsumer(RenderType.m_110452_((ResourceLocation)modelTexture));
        for (ModelPart part : body) {
            if (part == null) continue;
            part.render(context.poseStack, bodyCustomer, context.packedLight, context.packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        glass.render(context.poseStack, bodyCustomer, context.packedLight, context.packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderFirstPersonStencilScopeView(PoseStack poseStack, ModelPart glassShape, ModelPart crosshair, ResourceLocation glassTexture, ResourceLocation crosshairTexture, ResourceLocation bodyTexture, int light, int overlay, boolean glowingCrosshair, float crosshairScale, float backgroundScale, float backgroundZDepth, ModelPart ... body) {
        poseStack.m_85836_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)STENCIL_VIEW_BUFFER);
        GL11.glEnable((int)2960);
        RenderSystem.clear((int)1024, (boolean)Minecraft.f_91002_);
        GlStateManager._stencilFunc((int)519, (int)1, (int)255);
        GlStateManager._stencilMask((int)255);
        GlStateManager._stencilOp((int)7680, (int)7680, (int)7681);
        glassShape.render(poseStack, bufferSource.m_6299_(RenderTypes.getStencilCull(glassTexture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        bufferSource.m_109911_();
        GlStateManager._stencilFunc((int)517, (int)1, (int)255);
        GlStateManager._stencilMask((int)0);
        VertexConsumer bodyVertex = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)bodyTexture));
        for (ModelPart part : body) {
            if (part == null) continue;
            part.render(poseStack, bodyVertex, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        bufferSource.m_109911_();
        GlStateManager._stencilFunc((int)514, (int)1, (int)255);
        if (glowingCrosshair) {
            RenderSystem.enableBlend();
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderTypes.getAttachmentOverlayDepth(crosshairTexture));
        poseStack.m_85836_();
        crosshair.translateAndRotate(poseStack);
        poseStack.m_85841_(crosshairScale, crosshairScale, crosshairScale);
        SightViewRenderer.renderCrosshair(poseStack, vertexConsumer);
        bufferSource.m_109911_();
        if (glowingCrosshair) {
            RenderSystem.disableBlend();
        }
        poseStack.m_85849_();
        crosshair.resetPose();
        poseStack.m_85836_();
        crosshair.z += backgroundZDepth;
        crosshair.translateAndRotate(poseStack);
        poseStack.m_85841_(backgroundScale, backgroundScale, backgroundScale);
        SightViewRenderer.renderCrosshair(poseStack, bufferSource.m_6299_(RenderTypes.getTest(SCOPE_BACKGROUND)));
        bufferSource.m_109911_();
        poseStack.m_85849_();
        crosshair.resetPose();
        GlStateManager._stencilFunc((int)519, (int)0, (int)255);
        GlStateManager._stencilMask((int)255);
        GlStateManager._stencilOp((int)7680, (int)7680, (int)7681);
        glassShape.render(poseStack, bufferSource.m_6299_(RenderTypes.getStencilCull(glassTexture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        bufferSource.m_109911_();
        GlStateManager._stencilMask((int)0);
        GL11.glDisable((int)2960);
        poseStack.m_85849_();
        STENCIL_VIEW_BUFFER.m_85729_();
    }

    private static void renderCrosshair(PoseStack poseStack, VertexConsumer vertexConsumer) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        vertexConsumer.m_252986_(matrix4f, -0.5f, -0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.5f, -0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.5f, 0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        vertexConsumer.m_252986_(matrix4f, -0.5f, 0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
    }

    public static void renderFirstPersonClassicScopeView(GunRenderContext context, ModelPart crosshair) {
        PoseStack poseStack = context.poseStack;
        poseStack.m_85836_();
        crosshair.z = -5.0f;
        crosshair.xScale = 2.44f;
        crosshair.yScale = 2.44f;
        crosshair.zScale = 1.0f;
        crosshair.translateAndRotate(poseStack);
        SightViewRenderer.renderCrosshair(poseStack, context.getVertexConsumer(RenderTypes.getAttachmentOverlayDepth(GENERIC_SCOPE)));
        crosshair.resetPose();
        poseStack.m_85849_();
    }

    public static void renderFirstPersonRedDotView(GunRenderContext context, ModelPart crosshair, ModelPart root, ResourceLocation bodyTexture, ResourceLocation crosshairTexture, int light, int overlay, float crosshairScale) {
        PoseStack poseStack = context.poseStack;
        poseStack.m_85836_();
        VertexConsumer vertexConsumer = context.getVertexConsumer(RenderType.m_110452_((ResourceLocation)bodyTexture));
        root.render(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        root.translateAndRotate(poseStack);
        crosshair.translateAndRotate(poseStack);
        poseStack.m_85841_(crosshairScale, crosshairScale, crosshairScale);
        poseStack.m_252880_(-Mth.m_14036_((float)-0.5f, (float)(ClientGlobalWeaponTranslator.INSTANCE.swingRy * 0.1f), (float)0.5f), Mth.m_14036_((float)-0.5f, (float)(ClientGlobalWeaponTranslator.INSTANCE.swingRx * 0.1f), (float)0.5f), 0.0f);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        VertexConsumer crosshairVertexConsumer = context.getVertexConsumer(RenderTypes.getAttachmentOverlayDepth(crosshairTexture));
        crosshairVertexConsumer.m_252986_(matrix4f, -0.5f, -0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        crosshairVertexConsumer.m_252986_(matrix4f, 0.5f, -0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        crosshairVertexConsumer.m_252986_(matrix4f, 0.5f, 0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        crosshairVertexConsumer.m_252986_(matrix4f, -0.5f, 0.5f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }
}

