/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.model.attachments.scopes.holographic;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import sheridan.gunscraft.Clients;
import sheridan.gunscraft.items.attachments.util.newSys.AttachmentRenderEntry;
import sheridan.gunscraft.model.IAttachmentModel;
import sheridan.gunscraft.model.attachments.scopes.SightViewRenderer;
import sheridan.gunscraft.model.modelPartCopy.CubeListBuilder;
import sheridan.gunscraft.model.modelPartCopy.LayerDefinition;
import sheridan.gunscraft.model.modelPartCopy.MeshDefinition;
import sheridan.gunscraft.model.modelPartCopy.ModelPart;
import sheridan.gunscraft.model.modelPartCopy.PartDefinition;
import sheridan.gunscraft.render.GunRenderContext;

public class ModelHolographic<T extends Entity>
extends EntityModel<T>
implements IAttachmentModel {
    private final ModelPart holographic;
    private final ModelPart glass;
    private final ModelPart crosshair;
    private List<ResourceLocation> textures;
    public static final ResourceLocation STYLE_0 = new ResourceLocation("gunscraft", "textures/fx/holographic/green.png");

    public ModelHolographic(List<ResourceLocation> textures) {
        this(ModelHolographic.createBodyLayer().bakeRoot());
        this.textures = textures;
    }

    public ModelHolographic(ModelPart root) {
        this.holographic = root.getChild("holographic");
        this.glass = this.holographic.getChild("glass");
        this.crosshair = this.holographic.getChild("crosshair");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition holographic = partdefinition.addOrReplaceChild("holographic", CubeListBuilder.create().texOffs(39, 38).addBox(3.0f, 0.0f, -18.3f, 3.0f, 3.0f, 33.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))).texOffs(0, 0).addBox(-6.0f, -5.0f, -15.3f, 12.0f, 5.0f, 30.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.EAST))).texOffs(75, 0).addBox(-6.0f, -2.0f, -18.3f, 12.0f, 2.0f, 6.0f, new HashSet<Direction>(Arrays.asList(Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))).texOffs(59, 74).addBox(-6.0f, -7.0f, 7.7f, 12.0f, 2.0f, 7.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN))).texOffs(0, 71).addBox(5.0f, -15.0f, 7.7f, 1.0f, 8.0f, 7.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.NORTH))).texOffs(0, 60).addBox(-2.5981f, -16.5f, 7.7f, 6.0f, 1.0f, 7.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.UP, Direction.NORTH))).texOffs(2, 62).addBox(-3.4019f, -16.5f, 7.7f, 1.0f, 1.0f, 7.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))).texOffs(54, 0).addBox(-6.0f, -15.0f, 7.7f, 1.0f, 8.0f, 7.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.NORTH, Direction.EAST))).texOffs(0, 71).addBox(6.0f, -3.0f, -1.3f, 1.0f, 6.0f, 19.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))).texOffs(0, 35).addBox(6.0f, -15.6f, 3.7f, 1.0f, 13.0f, 12.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST))).texOffs(72, 25).addBox(-3.4641f, -17.6f, 3.7f, 7.0f, 1.0f, 12.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.UP, Direction.NORTH))).texOffs(84, 25).addBox(-3.5359f, -17.6f, 3.7f, 1.0f, 1.0f, 12.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.EAST))).texOffs(0, 0).addBox(-7.0f, -15.6f, 3.7f, 1.0f, 13.0f, 12.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST))).texOffs(54, 0).addBox(-7.0f, -3.0f, -1.3f, 1.0f, 6.0f, 19.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))).texOffs(0, 35).addBox(-6.0f, 0.0f, -18.3f, 3.0f, 3.0f, 33.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-6.0f));
        PartDefinition cube_r1 = holographic.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(39, 35).addBox(0.0f, -4.0f, -12.0f, 1.0f, 4.0f, 12.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)-7.0f, (float)-15.6f, (float)15.7f, (float)0.0f, (float)0.0f, (float)1.0472f));
        PartDefinition cube_r2 = holographic.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(39, 51).addBox(-1.0f, -4.0f, -12.0f, 1.0f, 4.0f, 12.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)7.0f, (float)-15.6f, (float)15.7f, (float)0.0f, (float)0.0f, (float)-1.0472f));
        PartDefinition cube_r3 = holographic.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -4.3f, 1.0f, 2.0f, 5.0f, new HashSet<Direction>(Arrays.asList(Direction.DOWN, Direction.WEST, Direction.EAST))).texOffs(0, 35).addBox(13.0f, 0.0f, -4.3f, 1.0f, 2.0f, 5.0f, new HashSet<Direction>(Arrays.asList(Direction.DOWN, Direction.WEST, Direction.EAST))), PartPose.m_171423_((float)-7.0f, (float)-3.6344f, (float)17.4042f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = holographic.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(14, 35).addBox(0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 8.0f, new HashSet<Direction>(Arrays.asList(Direction.DOWN, Direction.WEST, Direction.EAST))).texOffs(53, 35).addBox(13.0f, 0.0f, 0.0f, 1.0f, 4.0f, 8.0f, new HashSet<Direction>(Arrays.asList(Direction.DOWN, Direction.WEST, Direction.EAST))), PartPose.m_171423_((float)-7.0f, (float)-3.0f, (float)-1.3f, (float)0.829f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = holographic.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(21, 74).addBox(-2.0f, 0.0f, -7.0f, 12.0f, 2.0f, 7.0f, new HashSet<Direction>(Arrays.asList(Direction.DOWN))), PartPose.m_171423_((float)-4.0f, (float)-7.0f, (float)7.7f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r6 = holographic.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(14, 0).addBox(0.0f, -3.0f, -7.0f, 1.0f, 3.0f, 7.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)-6.0f, (float)-15.0f, (float)14.7f, (float)0.0f, (float)0.0f, (float)1.0472f));
        PartDefinition cube_r7 = holographic.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(53, 51).addBox(-1.0f, -3.0f, -7.0f, 1.0f, 3.0f, 7.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.WEST, Direction.NORTH))), PartPose.m_171423_((float)6.0f, (float)-15.0f, (float)14.7f, (float)0.0f, (float)0.0f, (float)-1.0472f));
        PartDefinition cube_r8 = holographic.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 7).addBox(-1.0f, 0.0f, -2.0f, 1.0f, 2.0f, 2.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH))), PartPose.m_171423_((float)-6.5f, (float)-3.0f, (float)6.7f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = holographic.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(6, 7).addBox(-1.0f, 0.0f, -2.0f, 1.0f, 2.0f, 2.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH, Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH))), PartPose.m_171423_((float)-6.5f, (float)-3.0f, (float)13.7f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r10 = holographic.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(76, 9).addBox(-12.0f, -4.0f, 0.0f, 12.0f, 4.0f, 2.0f, new HashSet<Direction>(Arrays.asList(Direction.DOWN, Direction.WEST, Direction.UP, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)6.0f, (float)-2.0f, (float)-18.3f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r11 = holographic.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(61, 95).addBox(-12.0f, -1.0f, 0.0f, 12.0f, 1.0f, 1.0f, new HashSet<Direction>(Arrays.asList(Direction.WEST, Direction.NORTH, Direction.EAST))), PartPose.m_171423_((float)6.0f, (float)-4.2929f, (float)-16.0071f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition glass = holographic.addOrReplaceChild("glass", CubeListBuilder.create().texOffs(78, 38).addBox(-9.0f, -9.0f, -1.0f, 10.0f, 9.0f, 1.0f, new HashSet<Direction>(Arrays.asList(Direction.SOUTH))), PartPose.m_171419_((float)4.0f, (float)-6.6f, (float)11.0f));
        PartDefinition crosshair = holographic.addOrReplaceChild("crosshair", CubeListBuilder.create(), PartPose.m_171419_((float)0.0f, (float)-11.5f, (float)-69.0f));
        return LayerDefinition.create(meshdefinition, 112, 112);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    @Override
    public void render(GunRenderContext context, AttachmentRenderEntry attachmentRenderEntry) {
        if (context.isFirstPerson && Clients.shouldRenderScopeOverlay()) {
            this.glass.visible = false;
            this.holographic.copyFrom(attachmentRenderEntry.translation);
            SightViewRenderer.renderFirstPersonRedDotView(context, this.crosshair, this.holographic, this.textures.get(0), STYLE_0, context.packedLight, context.packedOverlay, 0.16f);
            PoseStack poseStack = context.poseStack;
            this.holographic.translateAndRotate(poseStack);
            this.holographic.resetPose();
        } else {
            this.glass.visible = false;
            this.holographic.copyFrom(attachmentRenderEntry.translation);
            context.render(this.holographic, context.getVertexConsumer(RenderType.m_110452_((ResourceLocation)this.textures.get(0))));
            this.holographic.resetPose();
        }
    }

    @Override
    public void render(GunRenderContext context, AttachmentRenderEntry attachmentRenderEntry, ModelPart posePart) {
        if (context.isFirstPerson && Clients.shouldRenderScopeOverlay()) {
            this.glass.visible = false;
            this.holographic.copyFrom(posePart);
            SightViewRenderer.renderFirstPersonRedDotView(context, this.crosshair, this.holographic, this.textures.get(0), STYLE_0, context.packedLight, context.packedOverlay, 0.16f);
            PoseStack poseStack = context.poseStack;
            this.holographic.translateAndRotate(poseStack);
            this.holographic.resetPose();
        } else {
            this.glass.visible = false;
            this.holographic.copyFrom(posePart);
            context.render(this.holographic, context.getVertexConsumer(RenderType.m_110452_((ResourceLocation)this.textures.get(0))));
            this.holographic.resetPose();
        }
    }
}

