/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.model.guns;

import net.minecraft.client.model.geom.PartPose;
import net.minecraft.world.item.ItemDisplayContext;
import sheridan.gunscraft.model.modelPartCopy.ModelPart;
import sheridan.gunscraft.render.GunRenderContext;

public class BulletChainRenderer {
    public static void handleBulletChainAnimation(GunRenderContext gunRenderContext, ModelPart ... bullets) {
        int count = bullets.length;
        int ammoLeft = gunRenderContext.bulletLeft;
        float reloadProgress = gunRenderContext.getReloadProgress();
        float shootProgress = gunRenderContext.getShootProgress();
        for (int i = 0; i < count - 1; ++i) {
            ModelPart currentBullet = bullets[count - i - 1];
            ModelPart nextBullet = bullets[count - i - 2];
            if (ammoLeft <= i + 1 && !(reloadProgress > 0.45f)) continue;
            BulletChainRenderer.translateBullet(shootProgress, currentBullet, nextBullet, gunRenderContext.transformType);
        }
    }

    public static void translateBullet(float shootProgress, ModelPart prevBulletModel, ModelPart nextBulletModel, ItemDisplayContext transformType) {
        if (transformType.m_269069_() || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            PartPose partPose = nextBulletModel.getInitialPose();
            float x = (partPose.f_171405_ - prevBulletModel.x) * shootProgress;
            float y = (partPose.f_171406_ - prevBulletModel.y) * shootProgress;
            float z = (partPose.f_171407_ - prevBulletModel.z) * shootProgress;
            prevBulletModel.x += x;
            prevBulletModel.y += y;
            prevBulletModel.z += z;
        }
        prevBulletModel.visible = true;
    }
}

