/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.model.modelPartCopy;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public final class ModelPart {
    public float x;
    public float y;
    public float z;
    public float xRot;
    public float yRot;
    public float zRot;
    public float xScale = 1.0f;
    public float yScale = 1.0f;
    public float zScale = 1.0f;
    public boolean visible = true;
    public boolean skipDraw;
    private final List<Cube> cubes;
    private final Map<String, ModelPart> children;
    private PartPose initialPose = PartPose.f_171404_;

    public ModelPart(List<Cube> cubes, Map<String, ModelPart> children) {
        this.cubes = cubes;
        this.children = children;
    }

    public PartPose storePose() {
        return PartPose.m_171423_((float)this.x, (float)this.y, (float)this.z, (float)this.xRot, (float)this.yRot, (float)this.zRot);
    }

    public PartPose getInitialPose() {
        return this.initialPose;
    }

    public void setInitialPose(PartPose p_233561_) {
        this.initialPose = p_233561_;
    }

    public void resetPose() {
        this.loadPose(this.initialPose);
    }

    public void loadPose(PartPose p_171323_) {
        this.x = p_171323_.f_171405_;
        this.y = p_171323_.f_171406_;
        this.z = p_171323_.f_171407_;
        this.xRot = p_171323_.f_171408_;
        this.yRot = p_171323_.f_171409_;
        this.zRot = p_171323_.f_171410_;
        this.xScale = 1.0f;
        this.yScale = 1.0f;
        this.zScale = 1.0f;
    }

    public void copyFrom(ListTag tag) {
        this.x = tag.m_128775_(0);
        this.y = tag.m_128775_(1);
        this.z = tag.m_128775_(2);
        this.xRot = tag.m_128775_(3);
        this.yRot = tag.m_128775_(4);
        this.zRot = tag.m_128775_(5);
        this.xScale = tag.m_128775_(6);
        this.yScale = tag.m_128775_(7);
        this.zScale = tag.m_128775_(8);
    }

    public void copyFrom(ModelPart p_104316_) {
        this.xScale = p_104316_.xScale;
        this.yScale = p_104316_.yScale;
        this.zScale = p_104316_.zScale;
        this.xRot = p_104316_.xRot;
        this.yRot = p_104316_.yRot;
        this.zRot = p_104316_.zRot;
        this.x = p_104316_.x;
        this.y = p_104316_.y;
        this.z = p_104316_.z;
    }

    public boolean hasChild(String p_233563_) {
        return this.children.containsKey(p_233563_);
    }

    public ModelPart getChild(String p_171325_) {
        ModelPart modelpart = this.children.get(p_171325_);
        if (modelpart == null) {
            throw new NoSuchElementException("Can't find part " + p_171325_);
        }
        return modelpart;
    }

    public void setPos(float p_104228_, float p_104229_, float p_104230_) {
        this.x = p_104228_;
        this.y = p_104229_;
        this.z = p_104230_;
    }

    public void setRotation(float p_171328_, float p_171329_, float p_171330_) {
        this.xRot = p_171328_;
        this.yRot = p_171329_;
        this.zRot = p_171330_;
    }

    public void render(PoseStack p_104302_, VertexConsumer p_104303_, int p_104304_, int p_104305_) {
        this.render(p_104302_, p_104303_, p_104304_, p_104305_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(PoseStack p_104307_, VertexConsumer p_104308_, int p_104309_, int p_104310_, float p_104311_, float p_104312_, float p_104313_, float p_104314_) {
        if (!(!this.visible || this.cubes.isEmpty() && this.children.isEmpty())) {
            p_104307_.m_85836_();
            this.translateAndRotate(p_104307_);
            if (!this.skipDraw) {
                this.compile(p_104307_.m_85850_(), p_104308_, p_104309_, p_104310_, p_104311_, p_104312_, p_104313_, p_104314_);
            }
            for (ModelPart modelpart : this.children.values()) {
                modelpart.render(p_104307_, p_104308_, p_104309_, p_104310_, p_104311_, p_104312_, p_104313_, p_104314_);
            }
            p_104307_.m_85849_();
        }
    }

    public void visit(PoseStack p_171310_, Visitor p_171311_) {
        this.visit(p_171310_, p_171311_, "");
    }

    private void visit(PoseStack p_171313_, Visitor p_171314_, String p_171315_) {
        if (!this.cubes.isEmpty() || !this.children.isEmpty()) {
            p_171313_.m_85836_();
            this.translateAndRotate(p_171313_);
            PoseStack.Pose posestack$pose = p_171313_.m_85850_();
            for (int i = 0; i < this.cubes.size(); ++i) {
                p_171314_.visit(posestack$pose, p_171315_, i, this.cubes.get(i));
            }
            String s = p_171315_ + "/";
            this.children.forEach((p_171320_, p_171321_) -> p_171321_.visit(p_171313_, p_171314_, s + p_171320_));
            p_171313_.m_85849_();
        }
    }

    public void translateAndRotate(PoseStack p_104300_) {
        p_104300_.m_252880_(this.x * 0.0625f, this.y * 0.0625f, this.z * 0.0625f);
        if (this.xRot != 0.0f || this.yRot != 0.0f || this.zRot != 0.0f) {
            p_104300_.m_252781_(new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
        }
        if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
            p_104300_.m_85841_(this.xScale, this.yScale, this.zScale);
        }
    }

    public void translateAndRotateInitialPose(PoseStack p_104300_) {
        p_104300_.m_252880_(this.initialPose.f_171405_ * 0.0625f, this.initialPose.f_171406_ * 0.0625f, this.initialPose.f_171407_ * 0.0625f);
        if (this.initialPose.f_171408_ != 0.0f || this.initialPose.f_171409_ != 0.0f || this.initialPose.f_171410_ != 0.0f) {
            p_104300_.m_252781_(new Quaternionf().rotationZYX(this.zRot, this.yRot, this.xRot));
        }
    }

    private void compile(PoseStack.Pose p_104291_, VertexConsumer p_104292_, int p_104293_, int p_104294_, float p_104295_, float p_104296_, float p_104297_, float p_104298_) {
        for (Cube modelpart$cube : this.cubes) {
            modelpart$cube.compile(p_104291_, p_104292_, p_104293_, p_104294_, p_104295_, p_104296_, p_104297_, p_104298_);
        }
    }

    public Cube getRandomCube(RandomSource p_233559_) {
        return this.cubes.get(p_233559_.m_188503_(this.cubes.size()));
    }

    public boolean isEmpty() {
        return this.cubes.isEmpty();
    }

    public void offsetPos(Vector3f p_253873_) {
        this.x += p_253873_.x();
        this.y += p_253873_.y();
        this.z += p_253873_.z();
    }

    public void offsetRotation(Vector3f p_253983_) {
        this.xRot += p_253983_.x();
        this.yRot += p_253983_.y();
        this.zRot += p_253983_.z();
    }

    public void offsetScale(Vector3f p_253957_) {
        this.xScale += p_253957_.x();
        this.yScale += p_253957_.y();
        this.zScale += p_253957_.z();
    }

    public Stream<ModelPart> getAllParts() {
        return Stream.concat(Stream.of(this), this.children.values().stream().flatMap(ModelPart::getAllParts));
    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface Visitor {
        public void visit(PoseStack.Pose var1, String var2, int var3, Cube var4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Cube {
        private Polygon[] polygons;
        public float minX;
        public float minY;
        public float minZ;
        public float maxX;
        public float maxY;
        public float maxZ;

        public Cube(float originX, float originY, float originZ, float xLen, float yLen, float zLen, float xGrow, float yGrow, float zGrow, float textureWidth, float textureHeight, Set<UvPolygon> uvPolygons) {
            this.minX = originX;
            this.minY = originY;
            this.minZ = originZ;
            this.maxX = originX + xLen;
            this.maxY = originY + yLen;
            this.maxZ = originZ + zLen;
            this.polygons = new Polygon[uvPolygons.size()];
            float growMaxX = originX + xLen;
            float growMaxY = originY + yLen;
            float growMaxZ = originZ + zLen;
            Vertex vertex0 = new Vertex(growMaxX += xGrow, originY -= yGrow, originZ -= zGrow);
            Vertex vertex1 = new Vertex(growMaxX, growMaxY += yGrow, originZ);
            Vertex vertex2 = new Vertex(originX -= xGrow, growMaxY, originZ);
            Vertex vertex3 = new Vertex(originX, originY, growMaxZ += zGrow);
            Vertex vertex4 = new Vertex(growMaxX, originY, growMaxZ);
            Vertex vertex5 = new Vertex(growMaxX, growMaxY, growMaxZ);
            Vertex vertex6 = new Vertex(originX, growMaxY, growMaxZ);
            Vertex vertex7 = new Vertex(originX, originY, originZ);
            int index = 0;
            for (UvPolygon polygon : uvPolygons) {
                switch (polygon.direction) {
                    case UP: {
                        this.polygons[index] = new Polygon(new Vertex[]{vertex4, vertex3, vertex7, vertex0}, polygon.u1, polygon.v1, polygon.u2, polygon.v2, textureWidth, textureHeight, false, Direction.DOWN);
                        break;
                    }
                    case DOWN: {
                        this.polygons[index] = new Polygon(new Vertex[]{vertex1, vertex2, vertex6, vertex5}, polygon.u1, polygon.v1, polygon.u2, polygon.v2, textureWidth, textureHeight, false, Direction.UP);
                        break;
                    }
                    case EAST: {
                        this.polygons[index] = new Polygon(new Vertex[]{vertex7, vertex3, vertex6, vertex2}, polygon.u1, polygon.v1, polygon.u2, polygon.v2, textureWidth, textureHeight, false, Direction.WEST);
                        break;
                    }
                    case NORTH: {
                        this.polygons[index] = new Polygon(new Vertex[]{vertex0, vertex7, vertex2, vertex1}, polygon.u1, polygon.v1, polygon.u2, polygon.v2, textureWidth, textureHeight, false, Direction.NORTH);
                        break;
                    }
                    case WEST: {
                        this.polygons[index] = new Polygon(new Vertex[]{vertex4, vertex0, vertex1, vertex5}, polygon.u1, polygon.v1, polygon.u2, polygon.v2, textureWidth, textureHeight, false, Direction.EAST);
                        break;
                    }
                    case SOUTH: {
                        this.polygons[index] = new Polygon(new Vertex[]{vertex3, vertex4, vertex5, vertex6}, polygon.u1, polygon.v1, polygon.u2, polygon.v2, textureWidth, textureHeight, false, Direction.SOUTH);
                    }
                }
                ++index;
            }
        }

        public Cube(int u, int v, float originX, float originY, float originZ, float xLen, float yLen, float zLen, float xGrow, float yGrow, float zGrow, boolean mirror, float textureWidth, float textureHeight, Set<Direction> directions) {
            this.minX = originX;
            this.minY = originY;
            this.minZ = originZ;
            this.maxX = originX + xLen;
            this.maxY = originY + yLen;
            this.maxZ = originZ + zLen;
            this.polygons = new Polygon[directions.size()];
            float growMaxX = originX + xLen;
            float growMaxY = originY + yLen;
            float growMaxZ = originZ + zLen;
            originX -= xGrow;
            originY -= yGrow;
            originZ -= zGrow;
            growMaxX += xGrow;
            growMaxY += yGrow;
            growMaxZ += zGrow;
            if (mirror) {
                float f3 = growMaxX;
                growMaxX = originX;
                originX = f3;
            }
            Vertex vertex0 = new Vertex(growMaxX, originY, originZ, 0.0f, 8.0f);
            Vertex vertex1 = new Vertex(growMaxX, growMaxY, originZ, 8.0f, 8.0f);
            Vertex vertex2 = new Vertex(originX, growMaxY, originZ, 8.0f, 0.0f);
            Vertex vertex3 = new Vertex(originX, originY, growMaxZ, 0.0f, 0.0f);
            Vertex vertex4 = new Vertex(growMaxX, originY, growMaxZ, 0.0f, 8.0f);
            Vertex vertex5 = new Vertex(growMaxX, growMaxY, growMaxZ, 8.0f, 8.0f);
            Vertex vertex6 = new Vertex(originX, growMaxY, growMaxZ, 8.0f, 0.0f);
            Vertex vertex7 = new Vertex(originX, originY, originZ, 0.0f, 0.0f);
            float f4 = u;
            float f5 = (float)u + zLen;
            float f6 = (float)u + zLen + xLen;
            float f7 = (float)u + zLen + xLen + xLen;
            float f8 = (float)u + zLen + xLen + zLen;
            float f9 = (float)u + zLen + xLen + zLen + xLen;
            float f10 = v;
            float f11 = (float)v + zLen;
            float f12 = (float)v + zLen + yLen;
            int i = 0;
            if (directions.contains(Direction.DOWN)) {
                this.polygons[i++] = new Polygon(new Vertex[]{vertex4, vertex3, vertex7, vertex0}, f5, f10, f6, f11, textureWidth, textureHeight, mirror, Direction.DOWN);
            }
            if (directions.contains(Direction.UP)) {
                this.polygons[i++] = new Polygon(new Vertex[]{vertex1, vertex2, vertex6, vertex5}, f6, f11, f7, f10, textureWidth, textureHeight, mirror, Direction.UP);
            }
            if (directions.contains(Direction.WEST)) {
                this.polygons[i++] = new Polygon(new Vertex[]{vertex7, vertex3, vertex6, vertex2}, f4, f11, f5, f12, textureWidth, textureHeight, mirror, Direction.WEST);
            }
            if (directions.contains(Direction.NORTH)) {
                this.polygons[i++] = new Polygon(new Vertex[]{vertex0, vertex7, vertex2, vertex1}, f5, f11, f6, f12, textureWidth, textureHeight, mirror, Direction.NORTH);
            }
            if (directions.contains(Direction.EAST)) {
                this.polygons[i++] = new Polygon(new Vertex[]{vertex4, vertex0, vertex1, vertex5}, f6, f11, f8, f12, textureWidth, textureHeight, mirror, Direction.EAST);
            }
            if (directions.contains(Direction.SOUTH)) {
                this.polygons[i] = new Polygon(new Vertex[]{vertex3, vertex4, vertex5, vertex6}, f8, f11, f9, f12, textureWidth, textureHeight, mirror, Direction.SOUTH);
            }
        }

        public void compile(PoseStack.Pose pose, VertexConsumer vertexConsumer, int light, int overlay, float r, float g, float b, float a) {
            Matrix4f matrix4f = pose.m_252922_();
            Matrix3f matrix3f = pose.m_252943_();
            for (Polygon polygon : this.polygons) {
                Vector3f vector3f = matrix3f.transform(new Vector3f((Vector3fc)polygon.normal));
                float f = vector3f.x();
                float f1 = vector3f.y();
                float f2 = vector3f.z();
                for (Vertex vertex : polygon.vertices) {
                    float f3 = vertex.pos.x() * 0.0625f;
                    float f4 = vertex.pos.y() * 0.0625f;
                    float f5 = vertex.pos.z() * 0.0625f;
                    Vector4f vector4f = matrix4f.transform(new Vector4f(f3, f4, f5, 1.0f));
                    vertexConsumer.m_5954_(vector4f.x(), vector4f.y(), vector4f.z(), r, g, b, a, vertex.u, vertex.v, overlay, light, f, f1, f2);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Vertex {
        public final Vector3f pos;
        public final float u;
        public final float v;

        public Vertex(float x, float y, float z, float u, float v) {
            this(new Vector3f(x, y, z), u, v);
        }

        public Vertex(float x, float y, float z) {
            this(new Vector3f(x, y, z));
        }

        public Vertex(Vector3f pos) {
            this.pos = pos;
            this.u = 0.0f;
            this.v = 0.0f;
        }

        public Vertex remap(float u, float v) {
            return new Vertex(this.pos, u, v);
        }

        public Vertex(Vector3f pos, float u, float v) {
            this.pos = pos;
            this.u = u;
            this.v = v;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Polygon {
        public final Vertex[] vertices;
        public final Vector3f normal;

        public Polygon(Vertex[] vertices, float u1, float v1, float u2, float v2, float textureWidth, float textureHeight, boolean mirror, Direction direction) {
            this.vertices = vertices;
            vertices[0] = vertices[0].remap(u2 / textureWidth, v1 / textureHeight);
            vertices[1] = vertices[1].remap(u1 / textureWidth, v1 / textureHeight);
            vertices[2] = vertices[2].remap(u1 / textureWidth, v2 / textureHeight);
            vertices[3] = vertices[3].remap(u2 / textureWidth, v2 / textureHeight);
            if (mirror) {
                int i = vertices.length;
                for (int j = 0; j < i / 2; ++j) {
                    Vertex vertex = vertices[j];
                    vertices[j] = vertices[i - 1 - j];
                    vertices[i - 1 - j] = vertex;
                }
            }
            this.normal = direction.m_253071_();
            if (mirror) {
                this.normal.mul(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    public static class UvPolygon {
        public Direction direction;
        public float u1;
        public float v1;
        public float u2;
        public float v2;

        public UvPolygon(Direction direction, float u1, float v1, float u2, float v2) {
            this.direction = direction;
            this.u1 = u1;
            this.v1 = v1;
            this.u2 = u2;
            this.v2 = v2;
        }
    }
}

