/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.model.playerOriginal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sheridan.gunscraft.model.modelPartCopy.CubeDeformation;
import sheridan.gunscraft.model.modelPartCopy.CubeListBuilder;
import sheridan.gunscraft.model.modelPartCopy.LayerDefinition;
import sheridan.gunscraft.model.modelPartCopy.MeshDefinition;
import sheridan.gunscraft.model.modelPartCopy.ModelPart;
import sheridan.gunscraft.model.modelPartCopy.PartDefinition;

@OnlyIn(value=Dist.CLIENT)
public class ModelPlayerArms<T extends Entity>
extends EntityModel<T> {
    private final ModelPart left_arm_slim;
    private final ModelPart right_arm_slim;
    private final ModelPart left_sleeve_slim;
    private final ModelPart right_sleeve_slim;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_sleeve;
    private final ModelPart right_sleeve;
    public static ModelPlayerArms INSTANCE = new ModelPlayerArms(ModelPlayerArms.createBodyLayer().bakeRoot());
    private Map<String, ModelPart[]> modelPartMap;

    public ModelPlayerArms(ModelPart root) {
        this.left_arm_slim = root.getChild("left_arm_slim");
        this.right_arm_slim = root.getChild("right_arm_slim");
        this.left_sleeve_slim = root.getChild("left_sleeve_slim");
        this.right_sleeve_slim = root.getChild("right_sleeve_slim");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.left_sleeve = root.getChild("left_sleeve");
        this.right_sleeve = root.getChild("right_sleeve");
        this.modelPartMap = new HashMap<String, ModelPart[]>();
        this.modelPartMap.put("left_arm_slim", new ModelPart[]{this.left_arm_slim, this.left_sleeve_slim});
        this.modelPartMap.put("right_arm_slim", new ModelPart[]{this.right_arm_slim, this.right_sleeve_slim});
        this.modelPartMap.put("left_arm", new ModelPart[]{this.left_arm, this.left_sleeve});
        this.modelPartMap.put("right_arm", new ModelPart[]{this.right_arm, this.right_sleeve});
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition left_arm_slim = partdefinition.addOrReplaceChild("left_arm_slim", CubeListBuilder.create().texOffs(224, 336).addBox(-10.5f, 0.0f, -14.0f, 21.0f, 84.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm_slim = partdefinition.addOrReplaceChild("right_arm_slim", CubeListBuilder.create().texOffs(280, 112).addBox(-10.5f, 0.0f, -14.0f, 21.0f, 84.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_sleeve_slim = partdefinition.addOrReplaceChild("left_sleeve_slim", CubeListBuilder.create().texOffs(336, 336).addBox(-10.5f, 0.0f, -14.0f, 21.0f, 84.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_sleeve_slim = partdefinition.addOrReplaceChild("right_sleeve_slim", CubeListBuilder.create().texOffs(280, 224).addBox(-10.5f, 0.0f, -14.0f, 21.0f, 84.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(224, 336).addBox(-14.0f, 0.0f, -14.0f, 28.0f, 84.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(280, 112).addBox(-14.0f, 0.0f, -14.0f, 28.0f, 84.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_sleeve = partdefinition.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(336, 336).addBox(-14.0f, 0.0f, -14.0f, 28.0f, 84.0f, 28.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_sleeve = partdefinition.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(336, 224).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create(meshdefinition, 448, 448);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void render(String name, ModelPart posePart, PoseStack poseStack, ResourceLocation texture, int light, int overlay, float scale, MultiBufferSource bufferSource) {
        ModelPart[] models;
        if (this.modelPartMap.containsKey(name) && (models = this.modelPartMap.get(name)) != null) {
            ModelPart arm = models[0];
            ModelPart sleeve = models[1];
            if (arm != null && sleeve != null) {
                VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
                arm.copyFrom(posePart);
                arm.yScale = 1.5f * scale;
                arm.xScale = scale;
                arm.zScale = scale;
                arm.render(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                sleeve.copyFrom(posePart);
                sleeve.xScale = 1.25f * scale;
                sleeve.yScale = 1.5f * scale;
                sleeve.zScale = 1.25f * scale;
                sleeve.render(poseStack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                arm.resetPose();
                sleeve.resetPose();
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }
}

