/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import sheridan.gunscraft.network.packets.IPacket;

public class GiveBackItemPacket
implements IPacket<GiveBackItemPacket> {
    public int itemId;
    public int count;

    public GiveBackItemPacket() {
    }

    public GiveBackItemPacket(int itemId, int count) {
        this.itemId = itemId;
        this.count = count;
    }

    @Override
    public void encode(GiveBackItemPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.itemId);
        buffer.writeInt(message.count);
    }

    @Override
    public GiveBackItemPacket decode(FriendlyByteBuf buffer) {
        GiveBackItemPacket packet = new GiveBackItemPacket();
        packet.itemId = buffer.readInt();
        packet.count = buffer.readInt();
        return packet;
    }

    @Override
    public void handle(GiveBackItemPacket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                ItemStack returnStack = new ItemStack((ItemLike)Item.m_41445_((int)message.itemId), message.count);
                ItemEntity entity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), returnStack);
                player.m_9236_().m_7967_((Entity)entity);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

