/*
 * Decompiled with CFR 0.152.
 */
package sheridan.gunscraft.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import sheridan.gunscraft.items.guns.GenericGun;
import sheridan.gunscraft.items.guns.IGenericGun;
import sheridan.gunscraft.network.packets.IPacket;
import sheridan.gunscraft.sounds.SoundEvents;

public class GunFirePacket
implements IPacket<GunFirePacket> {
    public boolean mainHand;
    public float spread;

    public GunFirePacket() {
    }

    public GunFirePacket(boolean mainHand, float spread) {
        this.mainHand = mainHand;
        this.spread = spread;
    }

    @Override
    public void encode(GunFirePacket message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.mainHand);
        buffer.writeFloat(message.spread);
    }

    @Override
    public GunFirePacket decode(FriendlyByteBuf buffer) {
        GunFirePacket packet = new GunFirePacket();
        packet.mainHand = buffer.readBoolean();
        packet.spread = buffer.readFloat();
        return packet;
    }

    @Override
    public void handle(GunFirePacket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            boolean mainHand;
            ItemStack heldStack;
            Item patt1629$temp;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (patt1629$temp = (heldStack = (mainHand = message.mainHand) ? player.m_21205_() : player.m_21206_()).m_41720_()) instanceof IGenericGun) {
                IGenericGun gun = (IGenericGun)patt1629$temp;
                gun.shoot(heldStack, (LivingEntity)player, mainHand, message.spread);
                float[] soundArgs = gun.getSoundArgs(heldStack, gun);
                SoundEvents.playSound(((GenericGun)heldStack.m_41720_()).normalFireSound, (LivingEntity)player, soundArgs[0], soundArgs[1]);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

